/**
 * 
 */
package org.gcube.portlets.user.occurrencemanagement.client.event;

import org.gcube.portlets.user.occurrencemanagement.shared.ElaborationType;

import com.google.gwt.event.shared.GwtEvent;


/**
 * @author Francesco Mangiacrapa francesco.mangiacrapa@isti.cnr.it
 *
 */
public class ReLoadListOccurrencesEvent extends GwtEvent<ReLoadListIOccurrencesEventHandler> {
	
	public static final GwtEvent.Type<ReLoadListIOccurrencesEventHandler> TYPE = new Type<ReLoadListIOccurrencesEventHandler>();

	private ElaborationType loadType;
	
	@Override
	public Type<ReLoadListIOccurrencesEventHandler> getAssociatedType() {
		return TYPE;
	}

	@Override
	protected void dispatch(ReLoadListIOccurrencesEventHandler handler) {
		handler.onLoadListImportedOccurrences(this);	
	}
	
	public ReLoadListOccurrencesEvent(ElaborationType loadType){
		this.loadType = loadType;
	}

	public ElaborationType getLoadType() {
		return loadType;
	}
	
}
