package org.gcube.portlets.user.occurrencemanagement.client;

import org.gcube.portlets.user.occurrencemanagement.client.view.panel.GxtBorderLayoutMainPanel;
import org.gcube.portlets.user.occurrencemanagement.client.view.panel.GxtCardLayoutMainPanel;
import org.gcube.portlets.user.occurrencemanagement.client.view.panel.computation.CenterComputationPanelMng;
import org.gcube.portlets.user.occurrencemanagement.client.view.panel.computation.DetailsOperationPanelMng;
import org.gcube.portlets.user.occurrencemanagement.client.view.panel.data.CenterDataPanelMng;
import org.gcube.portlets.user.occurrencemanagement.client.view.panel.data.ExplorerDataPanelMng;
import org.gcube.portlets.user.occurrencemanagement.client.view.panel.operation.CenterAlgorithmPanelMng;
import org.gcube.portlets.user.occurrencemanagement.client.view.panel.operation.ExplorerOperationPanelMng;



public class OccurrenceManagementMainPanel {

	private GxtBorderLayoutMainPanel borderLayoutContainer;
	private GxtCardLayoutMainPanel gxtCardLayoutMainPanel; 
	
	private ExplorerDataPanelMng explorerDataPanelMng;
	private CenterDataPanelMng centerDataPanelMng;
	
	private CenterAlgorithmPanelMng centerOperationPanelMng;
	private ExplorerOperationPanelMng explorerOperationPanelMng;
	private CenterComputationPanelMng centerComputationPanelMng;
	private DetailsOperationPanelMng detailsOperationManager;
	

	public OccurrenceManagementMainPanel() {

		this.centerDataPanelMng = new CenterDataPanelMng();
		this.explorerDataPanelMng = new ExplorerDataPanelMng();
		
		this.centerOperationPanelMng = new CenterAlgorithmPanelMng();
		this.explorerOperationPanelMng = new ExplorerOperationPanelMng();
		
		this.centerComputationPanelMng = new CenterComputationPanelMng();
		
		this.detailsOperationManager = new DetailsOperationPanelMng();
		
		this.gxtCardLayoutMainPanel = new GxtCardLayoutMainPanel(centerDataPanelMng, explorerDataPanelMng, centerOperationPanelMng, explorerOperationPanelMng, centerComputationPanelMng, detailsOperationManager);
		
		this.borderLayoutContainer = new GxtBorderLayoutMainPanel(gxtCardLayoutMainPanel);
		
	}


	public GxtBorderLayoutMainPanel getBorderLayoutContainer() {
		return borderLayoutContainer;
	}


	public void setBorderLayoutContainer(GxtBorderLayoutMainPanel borderLayoutContainer) {
		this.borderLayoutContainer = borderLayoutContainer;
	}


	public GxtCardLayoutMainPanel getGxtCardLayoutMainPanel() {
		return gxtCardLayoutMainPanel;
	}


	public void setGxtCardLayoutMainPanel(
			GxtCardLayoutMainPanel gxtCardLayoutMainPanel) {
		this.gxtCardLayoutMainPanel = gxtCardLayoutMainPanel;
	}


	public ExplorerDataPanelMng getExplorerDataPanelMng() {
		return explorerDataPanelMng;
	}


	public void setExplorerDataPanelMng(ExplorerDataPanelMng explorerDataPanelMng) {
		this.explorerDataPanelMng = explorerDataPanelMng;
	}


	public CenterDataPanelMng getCenterDataPanelMng() {
		return centerDataPanelMng;
	}


	public void setCenterDataPanelMng(CenterDataPanelMng centerDataPanelMng) {
		this.centerDataPanelMng = centerDataPanelMng;
	}


	public CenterAlgorithmPanelMng getCenterOperationPanelMng() {
		return centerOperationPanelMng;
	}


	public void setCenterOperationPanelMng(
			CenterAlgorithmPanelMng centerOperationPanelMng) {
		this.centerOperationPanelMng = centerOperationPanelMng;
	}


	public ExplorerOperationPanelMng getExplorerOperationPanelMng() {
		return explorerOperationPanelMng;
	}


	public void setExplorerOperationPanelMng(ExplorerOperationPanelMng explorerOperationPanelMng) {
		this.explorerOperationPanelMng = explorerOperationPanelMng;
	}


	public CenterComputationPanelMng getCenterComputationPanelMng() {
		return centerComputationPanelMng;
	}


	public DetailsOperationPanelMng getDetailsOperationManager() {
		return detailsOperationManager;
	}

}
