/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.occurrencemanagement.client.statistical.form;

import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.HorizontalPanel;
import com.extjs.gxt.ui.client.widget.Html;
import com.extjs.gxt.ui.client.widget.Label;
import com.extjs.gxt.ui.client.widget.layout.LayoutData;
import com.extjs.gxt.ui.client.widget.layout.TableData;
import com.google.gwt.user.client.ui.Widget;
import org.gcube.portlets.user.occurrencemanagement.client.rpc.OccurrenceManagementServiceAsync;
import org.gcube.portlets.user.occurrencemanagement.client.statistical.form.AbstractField;
import org.gcube.portlets.user.occurrencemanagement.client.statistical.form.BooleanField;
import org.gcube.portlets.user.occurrencemanagement.client.statistical.form.ColumnField;
import org.gcube.portlets.user.occurrencemanagement.client.statistical.form.ColumnListField;
import org.gcube.portlets.user.occurrencemanagement.client.statistical.form.DoubleField;
import org.gcube.portlets.user.occurrencemanagement.client.statistical.form.EnumField;
import org.gcube.portlets.user.occurrencemanagement.client.statistical.form.FileField;
import org.gcube.portlets.user.occurrencemanagement.client.statistical.form.FloatField;
import org.gcube.portlets.user.occurrencemanagement.client.statistical.form.IntField;
import org.gcube.portlets.user.occurrencemanagement.client.statistical.form.ListIntField;
import org.gcube.portlets.user.occurrencemanagement.client.statistical.form.ListStringField;
import org.gcube.portlets.user.occurrencemanagement.client.statistical.form.StringField;
import org.gcube.portlets.user.occurrencemanagement.client.statistical.form.TabularField;
import org.gcube.portlets.user.occurrencemanagement.shared.statisticalparameter.ListParameter;
import org.gcube.portlets.user.occurrencemanagement.shared.statisticalparameter.ObjectParameter;
import org.gcube.portlets.user.occurrencemanagement.shared.statisticalparameter.Parameter;

public class OperatorFieldWidget
extends HorizontalPanel {
    private Parameter parameter;
    private AbstractField field;

    public OperatorFieldWidget(Parameter p, OccurrenceManagementServiceAsync service) {
        this.setStyleAttribute("margin", "10px");
        this.parameter = p;
        Label label = new Label(p.getName());
        label.addStyleName("label-fra");
        this.add((Widget)label, (LayoutData)new TableData("200px", "30px"));
        try {
            if (p.isObject()) {
                this.field = this.createObjectField((ObjectParameter)p);
            } else if (p.isEnum()) {
                this.field = new EnumField(p);
            } else if (p.isTabular()) {
                this.field = new TabularField(p, service);
            } else if (p.isColumn()) {
                this.field = new ColumnField(p);
            } else if (p.isColumnList()) {
                this.field = new ColumnListField(p);
            } else if (p.isList()) {
                this.field = this.createListField((ListParameter)p);
            } else if (p.isFile()) {
                this.field = new FileField(p);
            }
            this.add(this.field.getWidget());
            if (p.getDescription() != null) {
                Html descr = new Html(p.getDescription());
                descr.addStyleName("workflow-fieldDescription");
                this.add((Component)descr);
            }
        }
        catch (Exception e) {
            this.add((Component)new Html("Error in field retrieving."));
        }
    }

    public Parameter getParameter() {
        return this.parameter;
    }

    public String getFieldValue() {
        return this.field.getValue();
    }

    public String getValue() {
        return this.getFieldValue();
    }

    private AbstractField createObjectField(ObjectParameter p) {
        String type = p.getType();
        if (type.contentEquals(Integer.class.getName())) {
            return new IntField((Parameter)p);
        }
        if (type.contentEquals(String.class.getName())) {
            return new StringField((Parameter)p);
        }
        if (type.contentEquals(Boolean.class.getName())) {
            return new BooleanField((Parameter)p);
        }
        if (type.contentEquals(Double.class.getName())) {
            return new DoubleField((Parameter)p);
        }
        if (type.contentEquals(Float.class.getName())) {
            return new FloatField((Parameter)p);
        }
        return null;
    }

    private AbstractField createListField(ListParameter p) {
        String type = p.getType();
        if (type.contentEquals(String.class.getName()) || type.contentEquals("STRING")) {
            return new ListStringField((Parameter)p);
        }
        if (type.contentEquals(Integer.class.getName()) || type.contentEquals("NUMBER")) {
            return new ListIntField((Parameter)p);
        }
        return null;
    }

    public void updateOperatorParameterValue() {
        this.parameter.setValue(this.getFieldValue());
    }

    public AbstractField getField() {
        return this.field;
    }

    public boolean isValid() {
        if (this.field != null) {
            return this.field.isValid();
        }
        return false;
    }
}

