/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.occurrencemanagement.client.statistical.form;

import com.extjs.gxt.ui.client.data.BeanModel;
import com.extjs.gxt.ui.client.data.ModelData;
import com.extjs.gxt.ui.client.store.ListStore;
import com.extjs.gxt.ui.client.widget.CheckBoxListView;
import com.extjs.gxt.ui.client.widget.Html;
import com.extjs.gxt.ui.client.widget.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import org.gcube.portlets.user.occurrencemanagement.client.statistical.form.AbstractField;
import org.gcube.portlets.user.occurrencemanagement.client.statistical.form.ColumnListField;
import org.gcube.portlets.user.occurrencemanagement.shared.statisticalparameter.ColumnListParameter;
import org.gcube.portlets.user.occurrencemanagement.shared.statisticalparameter.Parameter;
import org.gcube.portlets.user.occurrencemanagement.shared.statisticalparameter.TableItem;

public class ColumnListField
extends AbstractField {
    private CheckBoxListView<BeanModel> view;
    private VerticalPanel vp = new VerticalPanel();
    String value = null;
    private String tableId;
    private ColumnListParameter columnListParameter;

    public ColumnListField(Parameter parameter) {
        super(parameter);
        this.columnListParameter = (ColumnListParameter)parameter;
        this.view = new CheckBoxListView();
        ListStore store = new ListStore();
        this.view.setStore(store);
        this.view.setDisplayProperty("name");
        this.view.setSize(150, 100);
        this.view.mask();
        this.showNoSelectionField();
    }

    private void showNoSelectionField() {
        this.vp.removeAll();
        this.vp.add((Widget)this.view);
        this.vp.add((Widget)new Html("<div class='workflow-parameters-description'>Select table from parameter " + this.columnListParameter.getReferredTabularParameterName() + "</div>"));
        this.vp.layout();
    }

    private void showFieldWithSelection(TableItem tableItem) {
        this.vp.removeAll();
        this.vp.add((Widget)this.view);
        this.vp.add((Widget)new Html("<div class='workflow-parameters-description'>Columns of Table " + tableItem.getName() + "</div>"));
        this.vp.layout();
    }

    public String getValue() {
        String separator = this.columnListParameter.getSeparator();
        String value = "";
        boolean first = true;
        for (BeanModel beanModel : this.view.getChecked()) {
            String columnName = ((ColumnItem)beanModel).getName();
            value = value + (first ? "" : separator) + columnName;
            first = false;
        }
        return value;
    }

    public Widget getWidget() {
        return this.vp;
    }

    public void fireEvent(Object message) {
        if (message == null) {
            this.view.getStore().removeAll();
            this.view.mask();
            this.showNoSelectionField();
        } else {
            TableItem tableItem = (TableItem)message;
            this.view.getStore().removeAll();
            for (String columnName : tableItem.getColumnNames()) {
                this.view.getStore().add((ModelData)new ColumnItem(this, columnName));
            }
            this.view.unmask();
            this.showFieldWithSelection(tableItem);
        }
    }

    public boolean isValid() {
        return this.view.getChecked().size() > 0;
    }
}

