/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.occurrencemanagement.client.statistical;

import com.extjs.gxt.ui.client.event.SelectionListener;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.Html;
import com.extjs.gxt.ui.client.widget.LayoutContainer;
import com.extjs.gxt.ui.client.widget.MessageBox;
import com.extjs.gxt.ui.client.widget.Text;
import com.extjs.gxt.ui.client.widget.button.Button;
import com.extjs.gxt.ui.client.widget.form.FormButtonBinding;
import com.extjs.gxt.ui.client.widget.form.FormPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gcube.portlets.user.occurrencemanagement.client.resources.Resources;
import org.gcube.portlets.user.occurrencemanagement.client.rpc.OccurrenceManagementServiceAsync;
import org.gcube.portlets.user.occurrencemanagement.client.statistical.WorkflowOperatorPanel;
import org.gcube.portlets.user.occurrencemanagement.client.statistical.form.AbstractField;
import org.gcube.portlets.user.occurrencemanagement.client.statistical.form.OperatorFieldWidget;
import org.gcube.portlets.user.occurrencemanagement.client.statistical.form.TabularField;
import org.gcube.portlets.user.occurrencemanagement.shared.JobOccurrencesModel;
import org.gcube.portlets.user.occurrencemanagement.shared.statisticalparameter.ColumnListParameter;
import org.gcube.portlets.user.occurrencemanagement.shared.statisticalparameter.ColumnParameter;
import org.gcube.portlets.user.occurrencemanagement.shared.statisticalparameter.Operator;
import org.gcube.portlets.user.occurrencemanagement.shared.statisticalparameter.Parameter;

public class WorkflowOperatorPanel
extends LayoutContainer {
    private static final String START_BUTTON_TOOLTIP = "Start Computation";
    private Operator operator;
    private OccurrenceManagementServiceAsync service;
    private FormPanel parametersPanel = new FormPanel();
    private Map<String, OperatorFieldWidget> fieldWidgetsMap = new HashMap();
    private Map<Parameter, String> parameterValues = new HashMap();
    private WorkflowOperatorPanelHandler handler = null;
    private List<JobOccurrencesModel> listTable;

    public WorkflowOperatorPanel(OccurrenceManagementServiceAsync service, Operator operator, WorkflowOperatorPanelHandler handler, List<JobOccurrencesModel> listTable) {
        this(service, operator, listTable);
        this.setHandler(handler);
        this.listTable = listTable;
    }

    public WorkflowOperatorPanel(OccurrenceManagementServiceAsync service, Operator operator, List<JobOccurrencesModel> listTable) {
        this.listTable = listTable;
        this.service = service;
        this.operator = operator;
        this.setHeight(50);
        this.setAutoHeight(true);
        Html title = new Html(operator.getName());
        title.addStyleName("workflow-title");
        this.add((Component)title);
        String descr = operator.getDescription();
        descr = descr == null || descr.contentEquals("") ? "no-description" : operator.getDescription();
        Html description = new Html(descr);
        description.addStyleName("workflow-description");
        this.add((Component)description);
        this.parametersPanel = new /* Unavailable Anonymous Inner Class!! */;
        Text pm = new Text("Parameters");
        pm.addStyleName("parameters-fra");
        this.parametersPanel.setHeaderVisible(false);
        this.parametersPanel.setBodyBorder(true);
        this.parametersPanel.add((Widget)pm);
        this.parametersPanel.setCollapsible(false);
        this.parametersPanel.expand();
        this.parametersPanel.setStyleAttribute("margin", "20px");
        this.add((Component)this.parametersPanel);
        this.loadOperatorParameters();
    }

    private void loadOperatorParameters() {
        this.showForm();
    }

    protected void showForm() {
        for (Parameter p : this.operator.getOperatorParameters()) {
            OperatorFieldWidget fieldWidget = new OperatorFieldWidget(p, this.service);
            this.fieldWidgetsMap.put(p.getName(), fieldWidget);
            this.parametersPanel.add((Widget)fieldWidget);
        }
        for (Parameter p : this.operator.getOperatorParameters()) {
            if (p.isColumn() || p.isColumnList()) {
                String tabParamName = p.isColumn() ? ((ColumnParameter)p).getReferredTabularParameterName() : ((ColumnListParameter)p).getReferredTabularParameterName();
                try {
                    TabularField tabularField = (TabularField)((OperatorFieldWidget)this.fieldWidgetsMap.get(tabParamName)).getField();
                    AbstractField field = ((OperatorFieldWidget)this.fieldWidgetsMap.get(p.getName())).getField();
                    tabularField.addChangeListener(field);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    MessageBox.alert((String)"Error", (String)("Column parameter \"" + p.getName() + " refers to a tabular parameter that doesn't exists (" + tabParamName + ")\""), null);
                }
                continue;
            }
            if (!p.isTabular()) continue;
            System.out.println("is TABULAR YES");
            TabularField tabularField = (TabularField)((OperatorFieldWidget)this.fieldWidgetsMap.get(p.getName())).getField();
            tabularField.setListTable(this.listTable);
        }
        this.parametersPanel.expand();
        Button submit = new Button(START_BUTTON_TOOLTIP);
        submit.setToolTip(START_BUTTON_TOOLTIP);
        submit.setIcon(Resources.startComputation());
        submit.setStyleAttribute("margin-left", "20px");
        submit.setStyleAttribute("margin-bottom", "20px");
        submit.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.parametersPanel.add((Widget)submit);
        FormButtonBinding binding = new FormButtonBinding(this.parametersPanel);
        binding.addButton(submit);
        this.parametersPanel.layout();
    }

    public void updateOperatorParametersValues() {
        for (Map.Entry entry : this.fieldWidgetsMap.entrySet()) {
            OperatorFieldWidget fieldWidget = (OperatorFieldWidget)entry.getValue();
            fieldWidget.updateOperatorParameterValue();
        }
    }

    public Operator getOperator() {
        return this.operator;
    }

    public void setHandler(WorkflowOperatorPanelHandler handler) {
        this.handler = handler;
    }

    static /* synthetic */ Map access$000(WorkflowOperatorPanel x0) {
        return x0.fieldWidgetsMap;
    }

    static /* synthetic */ Operator access$100(WorkflowOperatorPanel x0) {
        return x0.operator;
    }
}

