package org.gcube.portlets.user.occurrencemanagement.server;

import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.ServletException;

import org.apache.log4j.Logger;
import org.gcube.application.framework.core.session.ASLSession;
import org.gcube.common.homelibrary.home.HomeLibrary;
import org.gcube.common.homelibrary.home.workspace.Workspace;
import org.gcube.common.homelibrary.home.workspace.WorkspaceFolder;
import org.gcube.common.homelibrary.util.WorkspaceUtil;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.data.harmonization.occurrence.impl.model.statistical.AlgorithmParameter;
import org.gcube.data.harmonization.occurrence.impl.model.statistical.StatisticalComputation;
import org.gcube.data.harmonization.occurrence.impl.model.statistical.StatisticalFeature;
import org.gcube.data.harmonization.occurrence.impl.model.types.DataType;
import org.gcube.dataanalysis.ecoengine.configuration.AlgorithmConfiguration;
import org.gcube.portlets.user.occurrencemanagement.client.rpc.OccurrenceManagementService;
import org.gcube.portlets.user.occurrencemanagement.server.service.GxtReconciliationServiceConverter;
import org.gcube.portlets.user.occurrencemanagement.server.service.ReconciliationService;
import org.gcube.portlets.user.occurrencemanagement.server.tabular.OccurrenceManagementDataSourceFactory;
import org.gcube.portlets.user.occurrencemanagement.server.util.SessionUtil;
import org.gcube.portlets.user.occurrencemanagement.shared.ElaborationType;
import org.gcube.portlets.user.occurrencemanagement.shared.JobOccurrencesModel;
import org.gcube.portlets.user.occurrencemanagement.shared.statisticalparameter.ColumnListParameter;
import org.gcube.portlets.user.occurrencemanagement.shared.statisticalparameter.ColumnParameter;
import org.gcube.portlets.user.occurrencemanagement.shared.statisticalparameter.EnumParameter;
import org.gcube.portlets.user.occurrencemanagement.shared.statisticalparameter.ListParameter;
import org.gcube.portlets.user.occurrencemanagement.shared.statisticalparameter.ObjectParameter;
import org.gcube.portlets.user.occurrencemanagement.shared.statisticalparameter.Operator;
import org.gcube.portlets.user.occurrencemanagement.shared.statisticalparameter.OperatorCategory;
import org.gcube.portlets.user.occurrencemanagement.shared.statisticalparameter.Parameter;
import org.gcube.portlets.user.occurrencemanagement.shared.statisticalparameter.TabularParameter;
import org.gcube.portlets.user.tdw.server.datasource.DataSourceFactoryRegistry;

import com.google.gwt.user.server.rpc.RemoteServiceServlet;


/**
 * The server side implementation of the RPC service.
 */
@SuppressWarnings("serial")
public class OccurrenceManagementServiceImpl extends RemoteServiceServlet implements OccurrenceManagementService {
	
	public static Logger logger = Logger.getLogger(OccurrenceManagementServiceImpl.class);
	private final static String SEPARATOR = AlgorithmConfiguration.getListSeparator();
	
	protected ASLSession getASLSession()
	{
		return SessionUtil.getAslSession(this.getThreadLocalRequest().getSession());
	}
	
//	protected Workspace getWorkspace() throws InternalErrorException, HomeNotFoundException, WorkspaceFolderNotFoundException
//	{
//		return SessionUtil.getWorkspace(this.getThreadLocalRequest().getSession());
//	}
	
	public void init() throws ServletException {
	    super.init();

	    try {
	        Class.forName("org.postgresql.Driver");
	    } catch (ClassNotFoundException e) {
	        throw new ServletException("Error initializing the db",e);
	    }
	    
	    DataSourceFactoryRegistry.getInstance().add(new OccurrenceManagementDataSourceFactory());
	    
//		CSVTargetRegistry.getInstance().add(new CsvImportServer());
    }


	@Override
	public List<JobOccurrencesModel> getListOccurrencesSet(ElaborationType elaborationType, boolean onlyNotCompleted) throws Exception {
		
		logger.trace("Get List Occurrences type: "+ elaborationType + " onlyNotCompleted: " + onlyNotCompleted);
		
		System.out.println("Get List Occurrences type: "+ elaborationType + " onlyNotCompleted." + onlyNotCompleted);
		
		ArrayList<JobOccurrencesModel> listJob = new ArrayList<JobOccurrencesModel>();
		
		try{
			
			ReconciliationService reconciliationService = SessionUtil.getService(getASLSession());

			switch (elaborationType) {
			
				case IMPORTED:
	
//					listJob = GxtReconciliationServiceConverter.getImportedListOccurrencesJob(reconciliationService.getImportedList());
					
					listJob = GxtReconciliationServiceConverter.getImportRequestOccurrencesJob(reconciliationService.getDataList(), onlyNotCompleted);
					
					break;
					
				case COMPUTATION:
					
					listJob = GxtReconciliationServiceConverter.getSubmittedOperationOccurrencesJob(reconciliationService.getSubmittedOperationList(), onlyNotCompleted);
						
					break;
			}

		}
		
		catch (Exception e) {
			e.printStackTrace();
			logger.trace(e);
			logger.error("Error on get list occurrences " +e.getMessage());
			throw new Exception("Error on get list occurrences");
		}
		
		return listJob;
	}
	
	public void initServervice() throws Exception{
		
	    try {
	    	SessionUtil.getService(getASLSession());
			SessionUtil.getCsvImportServer(getASLSession());
		} catch (Exception e) {
		     throw new Exception("Error initializing the csv import",e);
		}
		
	}
	
//	@Override
//	public void importOccurrences(String workspaceItemId, String listOccurrencesName, String description) {
//		
//		System.out.println("import occurences with workspaceItemId:  " + workspaceItemId + " name: " + listOccurrencesName + " description: " +description);
//		logger.trace("import occurences with workspaceItemId:  " + workspaceItemId + " name: " + listOccurrencesName + " description: " +description);
//		
//		try{
//			
//			ReconciliationService reconciliationService = SessionUtil.getService(getASLSession());
//			
//			reconciliationService.importOccurrencesFromWorkspace(workspaceItemId, listOccurrencesName, description);
//		}
//		
//		catch (Exception e) {
//			logger.trace(e);
//			logger.error("Error in importOccurrences " +e.getMessage());
////			throw new Exception("Error in importOccurrences");
//		}
//		
//	}
	
	/* (non-Javadoc)
	 * @see org.gcube.portlets.user.statisticalmanager.client.StatisticalManagerService#getParameters(org.gcube.portlets.user.statisticalmanager.client.bean.Operator)
	 */
	@Override
	public List<Operator> getListOperator() throws Exception {

		initServervice(); //TODO TEMP
		
		List<Operator> listOperator = new ArrayList<Operator>();
		
		try{
			
		ReconciliationService reconciliationService = SessionUtil.getService(getASLSession());
		
		// get parameters info
		logger.trace("Get operators...");

		List<StatisticalFeature> listFeatures = reconciliationService.getCapabilities();
		
		for (StatisticalFeature statisticalFeature : listFeatures) {
			
			Operator operator = new Operator();
			
			StatisticalComputation computation = statisticalFeature.getComputation();
			
			operator.setId(computation.getAlgorithm());
			operator.setName(computation.getAlgorithm());
			operator.setDescription(computation.getDescription());
		
			OperatorCategory category = new OperatorCategory(computation.getCategory(), "", "");
			operator.setCategory(category);
			
			List<AlgorithmParameter> listParameter = statisticalFeature.getParameters();
			
			List<Parameter> operatorParameters = new ArrayList<Parameter>();
			
			for (AlgorithmParameter algorithmParameter : listParameter) {
			
				DataType smType = algorithmParameter.getType();
				String paramName = algorithmParameter.getName();
				String paramDescription = algorithmParameter.getDescription();
				String defaultValue = algorithmParameter.getDefaultValue();
				
				switch (algorithmParameter.getType().getType()) {
				
				case TABULAR:
					TabularParameter tabularParam = new TabularParameter(paramName, paramDescription);
					for(String value : smType.getValue())
		 				tabularParam.addTemplate(value);
					operatorParameters.add(tabularParam);
					
					break;
					
				case PRIMITIVE:
					
					String objectType = smType.getValue().get(0);				
					ObjectParameter objectParam = new ObjectParameter(paramName, paramDescription, objectType, defaultValue);
					operatorParameters.add(objectParam);
					
					break;
					
					
				case ENUM:
					
					List<String> values = smType.getValue();
					EnumParameter enumParam = new EnumParameter(paramName, paramDescription, values, defaultValue);
					operatorParameters.add(enumParam);
					
					break;
					
					
				case LIST:
					
					String listType =  smType.getValue().get(0);	
					ListParameter listParam = new ListParameter(paramName, paramDescription, listType, SEPARATOR);
					operatorParameters.add(listParam);
					
					break;
					
				case COLUMN:
					
					String referredTabularParameterName = smType.getValue().get(0);	
					ColumnParameter columnParam = new ColumnParameter(paramName, paramDescription, referredTabularParameterName, defaultValue);
					operatorParameters.add(columnParam);
					
					break;
					
				case COLUMN_LIST:
					
					String referredTabular= smType.getValue().get(0);
					ColumnListParameter columnListParameter = new ColumnListParameter(paramName, paramDescription, referredTabular, SEPARATOR);
					operatorParameters.add(columnListParameter);
					
					break;

			
				}
				
				operator.setOperatorParameters(operatorParameters);
			}
			
			listOperator.add(operator);
		}
		
		}catch (Exception e) {
			logger.error("Error in getListOperator: ", e);
			throw new Exception("Error in getListOperator");
		}

		return listOperator;
	}

	@Override
	public String startComputation(Operator operator, String computationTitle, String computationDescription) throws Exception {
		
		//FOR DEBUG
		System.out.println("startComputation...");
		System.out.println("Operator: "+operator);
		System.out.println("Category: "+ operator.getCategory());
		
		logger.trace("startComputation...");
		logger.trace("Operator: "+operator);
		
		
		try{
			
			ReconciliationService reconciliationService = SessionUtil.getService(getASLSession());
			
			Map<String, String> hash = new HashMap<String, String>();
			
			for (Parameter parameter : operator.getOperatorParameters()) {
				
				//FOR DEBUG
				System.out.println("Parameter : " +parameter.getName() + "   value: " + parameter.getValue());
				
				logger.trace("Parameter:  " +parameter.getName() + "   value: " + parameter.getValue());
				
				hash.put(parameter.getName(), parameter.getValue());
			}
			
//			OperatorCategory opCat = new OperatorCategory(operator.getCategory().getId(), operator.getCategory().getBriefDescription(), operator.getCategory().getDescription());
			
			StatisticalComputation stat = new StatisticalComputation(operator.getId(), operator.getDescription(), operator.getCategory().getId()); //TODO id or name
			
			logger.trace("submit operatiorn...");
			reconciliationService.submitOperation(stat, hash,computationTitle,computationDescription);
			logger.trace("submit return");
			
			return "OK";
			
		}
		catch (Exception e) {
			logger.error("Error in startComputation ", e);
			throw new Exception("Error in startComputation");
		}

	}
	
	@Override
	public Boolean saveSelectedOccurrencePoints(String resourceId, ElaborationType elaborationType, String destinationFolderId, String fileName) throws Exception {
		logger.trace("saveSelectedOccurrencePoints resourceId "+ resourceId + " destinationFolderId: "+destinationFolderId+" fileName: "+fileName);
		System.out.println("saveSelectedOccurrencePoints resourceId "+ resourceId + " destinationFolderId: "+destinationFolderId+" fileName: "+fileName);

		File file = null;
		String mimeType = "text/csv";
		
		try {
			
			ReconciliationService reconciliationService = SessionUtil.getService(getASLSession());

			file = reconciliationService.getResourceAsFile(resourceId,GxtReconciliationServiceConverter.convertToOperationType(elaborationType));
			
			logger.trace("tmp file: "+file.getAbsolutePath());
			System.out.println("tmp file: "+file.getAbsolutePath());

			ASLSession session = getASLSession();
			
			ScopeProvider.instance.set(session.getScope().toString());
			Workspace workspace = HomeLibrary.getUserWorkspace(session.getUsername());

			WorkspaceFolder folder = (WorkspaceFolder)workspace.getItem(destinationFolderId);
			fileName = WorkspaceUtil.getUniqueName(fileName, folder);
			folder.createExternalFileItem(fileName, "Occurrence points generated files", mimeType, new FileInputStream(file));

			file.delete();

			logger.trace("Save complete");
			System.out.println("Save complete");
			
			return true;

		} catch (Exception e) {

			logger.error("An error occurred saving the generated file into the workspace", e);
			throw new Exception(e.getMessage());
		}
	}
	
	@Override
	public void deleteResourceById(String resourceId) throws Exception{
		
		logger.trace("deleteResourceById resourceId "+ resourceId);
		System.out.println("deleteResourceById resourceId "+ resourceId);
		try {
			
			ReconciliationService reconciliationService = SessionUtil.getService(getASLSession());

			reconciliationService.deleteResourceById(resourceId);
			
			logger.trace("delete resourceId "+ resourceId + " OK");
			System.out.println("delete resourceId "+ resourceId + " OK");

		} catch (Exception e) {

			logger.error("An error occurred deleting occurrence", e);
			throw new Exception(e.getMessage());
		}
	}

}
