package org.gcube.portlets.user.occurrencemanagement.client.view.panel.computation;


import org.gcube.portlets.user.occurrencemanagement.client.ConstantsPortletOccurrence;
import org.gcube.portlets.user.occurrencemanagement.client.OccurrenceApplicationController;
import org.gcube.portlets.user.occurrencemanagement.client.dialog.MessageBoxAlert;
import org.gcube.portlets.user.occurrencemanagement.client.dialog.MessageBoxConfirm;
import org.gcube.portlets.user.occurrencemanagement.client.event.OpenTableEvent;
import org.gcube.portlets.user.occurrencemanagement.client.event.ReLoadListOccurrencesEvent;
import org.gcube.portlets.user.occurrencemanagement.client.job.JobManager;
import org.gcube.portlets.user.occurrencemanagement.client.job.WindowInfoJobsSpecies;
import org.gcube.portlets.user.occurrencemanagement.client.resources.Resources;
import org.gcube.portlets.user.occurrencemanagement.shared.ElaborationStatus;
import org.gcube.portlets.user.occurrencemanagement.shared.ElaborationType;
import org.gcube.portlets.user.occurrencemanagement.shared.JobOccurrencesModel;

import com.extjs.gxt.ui.client.Style.ButtonScale;
import com.extjs.gxt.ui.client.Style.SortDir;
import com.extjs.gxt.ui.client.data.BaseModelData;
import com.extjs.gxt.ui.client.data.ModelData;
import com.extjs.gxt.ui.client.event.BaseEvent;
import com.extjs.gxt.ui.client.event.ButtonEvent;
import com.extjs.gxt.ui.client.event.Events;
import com.extjs.gxt.ui.client.event.Listener;
import com.extjs.gxt.ui.client.event.MenuEvent;
import com.extjs.gxt.ui.client.event.MessageBoxEvent;
import com.extjs.gxt.ui.client.event.SelectionChangedEvent;
import com.extjs.gxt.ui.client.event.SelectionChangedListener;
import com.extjs.gxt.ui.client.event.SelectionListener;
import com.extjs.gxt.ui.client.widget.ContentPanel;
import com.extjs.gxt.ui.client.widget.Dialog;
import com.extjs.gxt.ui.client.widget.button.Button;
import com.extjs.gxt.ui.client.widget.grid.Grid;
import com.extjs.gxt.ui.client.widget.layout.FitLayout;
import com.extjs.gxt.ui.client.widget.menu.Menu;
import com.extjs.gxt.ui.client.widget.menu.MenuItem;
import com.extjs.gxt.ui.client.widget.toolbar.SeparatorToolItem;
import com.extjs.gxt.ui.client.widget.toolbar.ToolBar;
import com.google.gwt.user.client.ui.AbstractImagePrototype;



public class ResultLoadPanel extends ContentPanel{
	
	private ToolBar toolbar;
	private Grid<BaseModelData> grid;
	private Button buttonInfo = new Button(INFO);
	private Button buttonView =  new Button(VIEW);
	private Button buttonCancel =  new Button(CANCEL);
	
	private static final String VIEW = "View";
	private final static String INFO = "Info";
	private static final String CANCEL = "Cancel";
	private JobManager jobManager;
	private Button buttonRefresh;
	private static final String REFRESH = "Refresh";
	
	public ResultLoadPanel(final JobManager jobManager) {
		setLayout(new FitLayout());
		setBodyBorder(false);
		
		setHeading("Results");
		
		this.jobManager = jobManager;
		
		this.grid = jobManager.getGridJob().getGrid();
		
		this.grid.getStore().sort(JobOccurrencesModel.ENDTIME, SortDir.ASC);
		
		this.grid.getSelectionModel().addSelectionChangedListener(new SelectionChangedListener<BaseModelData>() {
			
			@Override
			public void selectionChanged(SelectionChangedEvent<BaseModelData> se) {
				System.out.println("selection grid change");
				
				ModelData target = se.getSelectedItem();
				
				if(target!=null)
					enableButtonOnClick(true);
				else
					enableButtonOnClick(false);
				
			}
		});
		
		addListener(Events.Expand, new Listener<BaseEvent>() {

			@Override
			public void handleEvent(BaseEvent be) {
				jobManager.getGridJob().updateProgressSize();
			}
		});
		
		createGridToolBar();
		createMenuItemsOnGrid();
		
		this.add(jobManager.getGridJob());

	}
	
	public void createMenuItemsOnGrid(){
		
		Menu menu = new Menu();
		
		MenuItem menuInfo = new MenuItem(); 
		menuInfo.setId(INFO );
		menuInfo.setText(INFO);  
		menuInfo.setIcon(AbstractImagePrototype.create(Resources.getImageInfo()));
		
		menuInfo.addSelectionListener(new SelectionListener<MenuEvent>() {

			@Override
			public void componentSelected(MenuEvent ce) {
				
				BaseModelData jobModel = grid.getSelectionModel().getSelectedItem();
				
				info(jobModel);
			}

		});

		menu.add(menuInfo);
			
		MenuItem menuView = new MenuItem(); 
		menuView.setId(VIEW);
		menuView.setText(VIEW);  
		menuView.setIcon(AbstractImagePrototype.create(Resources.getImageTable()));
		
		menuView.addSelectionListener(new SelectionListener<MenuEvent>() {
			
			@Override
			public void componentSelected(MenuEvent ce) {
				
				BaseModelData jobModel = grid.getSelectionModel().getSelectedItem();
				
				view(jobModel);
			}

		});
		
		menu.add(menuView);
		
		MenuItem menuCancel= new MenuItem(); 
		menuCancel.setId(CANCEL);
		menuCancel.setText(CANCEL);  
		menuCancel.setIcon(AbstractImagePrototype.create(Resources.getImageDelete()));
		
		menuCancel.addSelectionListener(new SelectionListener<MenuEvent>() {
			
			@Override
			public void componentSelected(MenuEvent ce) {
				
				BaseModelData jobModel = grid.getSelectionModel().getSelectedItem();
				
				cancel(jobModel);
			}

		});

		menu.add(menuCancel);
		
		grid.setContextMenu(menu);
	
		
	}

	private void createGridToolBar(){
		
		this.toolbar = new ToolBar();
		
		buttonInfo.setScale(ButtonScale.MEDIUM);
//		buttonInfo.setIconAlign(IconAlign.LEFT);
//		buttonInfo.setArrowAlign(ButtonArrowAlign.RIGHT);
		buttonInfo.setIcon(AbstractImagePrototype.create(Resources.getImageInfo()));
		buttonInfo.setStyleAttribute("margin-left", "5px");
		buttonInfo.addSelectionListener(new SelectionListener<ButtonEvent>() {
			
			@Override
			public void componentSelected(ButtonEvent ce) {
				
				BaseModelData jobModel = grid.getSelectionModel().getSelectedItem();
				
				info(jobModel);
			}
		});
		
		buttonView.setIcon(AbstractImagePrototype.create(Resources.getImageTable()));
		buttonView.setScale(ButtonScale.MEDIUM);

		buttonView.addListener(Events.OnClick, new Listener<BaseEvent>() {

			@Override
			public void handleEvent(BaseEvent be) {
				
				BaseModelData jobModel = grid.getSelectionModel().getSelectedItem();
				
				view(jobModel);
			}
		});
		
		

		buttonCancel.setScale(ButtonScale.MEDIUM);
		buttonCancel.setIcon(AbstractImagePrototype.create(Resources.getImageDelete()));
		
		buttonCancel.addListener(Events.OnClick, new Listener<BaseEvent>() {

			@Override
			public void handleEvent(BaseEvent be) {
				
				BaseModelData jobModel = grid.getSelectionModel().getSelectedItem();
				
				cancel(jobModel);

			}
	
		});
		
		buttonRefresh =  new Button(REFRESH);
		buttonRefresh.setScale(ButtonScale.MEDIUM);
		buttonRefresh.setIcon(Resources.getIconRefresh());
		
		buttonRefresh.addListener(Events.OnClick, new Listener<BaseEvent>() {

			@Override
			public void handleEvent(BaseEvent be) {
				
				refresh();
	
			}

		});

		toolbar.add(buttonInfo);
		toolbar.add(new SeparatorToolItem());
		
		toolbar.add(buttonView);
		toolbar.add(new SeparatorToolItem());
		
		toolbar.add(buttonCancel);
		toolbar.add(new SeparatorToolItem());
		
		toolbar.add(buttonRefresh);
		toolbar.add(new SeparatorToolItem());
		
		setTopComponent(toolbar);
		
		enableButtonOnClick(false);
	}
	
	private void cancel(final BaseModelData jobModel){
		
		if(jobModel!=null){
			
			String name = jobModel.get(JobOccurrencesModel.JOBNAME);
			
			MessageBoxConfirm mbc = new MessageBoxConfirm("Confirm delete", ConstantsPortletOccurrence.MESSAGE_CONFIRM_DELETE  + " "+ name+"?");
			mbc.getMessageBoxConfirm().addCallback(new Listener<MessageBoxEvent>() {
		          
			public void handleEvent(MessageBoxEvent be) {
				
				//IF CANCELLED
				String clickedButton = be.getButtonClicked().getItemId();
				if(clickedButton.equals(Dialog.YES)){
					
					final String jobIdentifier = jobModel.get(JobOccurrencesModel.JOBINDENTIFIER);

				}
			}	
			});
		}
		
	}
	
	private void info(BaseModelData jobModel){
		
		if(jobModel!=null){
			
			String id = jobModel.get(JobOccurrencesModel.JOBINDENTIFIER);
			WindowInfoJobsSpecies win = jobManager.getGridJob().getListWindowInfo().get(id);
			win.show();
		}
	}
	
	
	private void view(BaseModelData jobModel){
		
		if(jobModel!=null){
			
			if(!jobModel.get(JobOccurrencesModel.STATUS).equals(ElaborationStatus.COMPLETED)){
				new MessageBoxAlert("Alert", "The computation was not completed!",null);
				return;
			}
			
			String id = jobModel.get(JobOccurrencesModel.JOBINDENTIFIER);
			String name = jobModel.get(JobOccurrencesModel.JOBNAME);
			
			OccurrenceApplicationController.getEventBus().fireEvent(new OpenTableEvent(name,name));
		
		}
	}
	
	public void enableButtonOnClick(boolean bool){
		this.buttonCancel.setEnabled(bool);
		this.buttonInfo.setEnabled(bool);
		this.buttonView.setEnabled(bool);
	}
	
	public JobManager getJobManager(){
		return jobManager;
	}
	
	private void refresh() {
		this.jobManager.reset();
		OccurrenceApplicationController.getEventBus().fireEvent(new ReLoadListOccurrencesEvent(ElaborationType.COMPUTATION));
	}
}