package org.gcube.portlets.user.occurrencemanagement.client.view.panel.computation;

import java.util.List;

import org.gcube.portlets.user.occurrencemanagement.client.ConstantsPortletOccurrence;
import org.gcube.portlets.user.occurrencemanagement.client.OccurrenceApplicationController;
import org.gcube.portlets.user.occurrencemanagement.client.dialog.MessageBoxConfirm;
import org.gcube.portlets.user.occurrencemanagement.client.event.DeleteResourceEvent;
import org.gcube.portlets.user.occurrencemanagement.client.event.DetailsComputationSelectedEvent;
import org.gcube.portlets.user.occurrencemanagement.client.event.ReLoadListOccurrencesEvent;
import org.gcube.portlets.user.occurrencemanagement.client.job.JobManager;
import org.gcube.portlets.user.occurrencemanagement.client.resources.Resources;
import org.gcube.portlets.user.occurrencemanagement.shared.ElaborationType;
import org.gcube.portlets.user.occurrencemanagement.shared.JobOccurrencesModel;

import com.extjs.gxt.ui.client.Style.ButtonScale;
import com.extjs.gxt.ui.client.Style.SortDir;
import com.extjs.gxt.ui.client.data.BaseModelData;
import com.extjs.gxt.ui.client.data.ModelData;
import com.extjs.gxt.ui.client.event.BaseEvent;
import com.extjs.gxt.ui.client.event.Events;
import com.extjs.gxt.ui.client.event.Listener;
import com.extjs.gxt.ui.client.event.MenuEvent;
import com.extjs.gxt.ui.client.event.MessageBoxEvent;
import com.extjs.gxt.ui.client.event.SelectionChangedEvent;
import com.extjs.gxt.ui.client.event.SelectionChangedListener;
import com.extjs.gxt.ui.client.event.SelectionListener;
import com.extjs.gxt.ui.client.store.Record;
import com.extjs.gxt.ui.client.widget.ContentPanel;
import com.extjs.gxt.ui.client.widget.Dialog;
import com.extjs.gxt.ui.client.widget.button.Button;
import com.extjs.gxt.ui.client.widget.grid.Grid;
import com.extjs.gxt.ui.client.widget.layout.FitLayout;
import com.extjs.gxt.ui.client.widget.menu.Menu;
import com.extjs.gxt.ui.client.widget.menu.MenuItem;
import com.extjs.gxt.ui.client.widget.toolbar.SeparatorToolItem;
import com.extjs.gxt.ui.client.widget.toolbar.ToolBar;
import com.google.gwt.user.client.ui.AbstractImagePrototype;



public class GridComputationPanel extends ContentPanel{
	
	private ToolBar toolbar;
	private JobManager jobManager;
	private Grid<BaseModelData> grid;
	private static final String CANCEL = "Cancel";
	private static final String REFRESH = "Refresh";
	
	private Button buttonCancel;
	private Button buttonRefresh;
	
	
	public GridComputationPanel(final JobManager jobManager) {
		setBorders(false);
		setLayout(new FitLayout());
		setHeaderVisible(false);
		
		setHeading("Computation");
		
		this.jobManager = jobManager;
		
		this.grid = jobManager.getGridJob().getGrid();
		
		this.grid.getStore().sort(JobOccurrencesModel.ENDTIME, SortDir.ASC);
		
		this.grid.getSelectionModel().addSelectionChangedListener(new SelectionChangedListener<BaseModelData>() {
			
			@Override
			public void selectionChanged(SelectionChangedEvent<BaseModelData> se) {
				
				ModelData target = se.getSelectedItem();
				JobOccurrencesModel occurrenceModel = null;
				
				if(target!=null){
					enableButtonOnClick(true);
					occurrenceModel = (JobOccurrencesModel) target.get(JobOccurrencesModel.OCCURRENCEMODEL);
				}
				else
					enableButtonOnClick(false);
				
				
				
				OccurrenceApplicationController.getEventBus().fireEvent(new DetailsComputationSelectedEvent(occurrenceModel));
				
			}
		});
		
		this.grid.getView().setAutoFill(true);
		
		createGridToolBar();
		createMenuItemsOnGrid();
		
		this.add(jobManager.getGridJob());
		
	}
	
	public void updateProgressSize(){
		 jobManager.getGridJob().updateProgressSize();
	}
	
	private void createGridToolBar(){
		
		this.toolbar = new ToolBar();
		
		buttonCancel =  new Button(CANCEL);
		buttonCancel.setScale(ButtonScale.MEDIUM);
		buttonCancel.setIcon(AbstractImagePrototype.create(Resources.getImageDelete()));
		
		buttonCancel.addListener(Events.OnClick, new Listener<BaseEvent>() {

			@Override
			public void handleEvent(BaseEvent be) {
				
				BaseModelData jobModel = grid.getSelectionModel().getSelectedItem();
				
				cancel(jobModel);
	
			}
		});
		
		buttonRefresh =  new Button(REFRESH);
		buttonRefresh.setScale(ButtonScale.MEDIUM);
		buttonRefresh.setIcon(Resources.getIconRefresh());
		
		buttonRefresh.addListener(Events.OnClick, new Listener<BaseEvent>() {

			@Override
			public void handleEvent(BaseEvent be) {
				
				refresh();
	
			}

		});

		toolbar.add(buttonCancel);
		toolbar.add(new SeparatorToolItem());
		
		toolbar.add(buttonRefresh);
		toolbar.add(new SeparatorToolItem());
		
		setTopComponent(toolbar);
		
		enableButtonOnClick(false);
	}
	
	public void createMenuItemsOnGrid(){
	
		Menu menu = new Menu();
		
		MenuItem menuCancel= new MenuItem(); 
		menuCancel.setId(CANCEL);
		menuCancel.setText(CANCEL);  
		menuCancel.setIcon(AbstractImagePrototype.create(Resources.getImageDelete()));
		
		menuCancel.addSelectionListener(new SelectionListener<MenuEvent>() {
			
			@Override
			public void componentSelected(MenuEvent ce) {
				
				BaseModelData jobModel = grid.getSelectionModel().getSelectedItem();
				
				cancel(jobModel);
			}

		});

		menu.add(menuCancel);
		
		grid.setContextMenu(menu);
		
	}
	
	private void cancel(final BaseModelData baseModel){
		
		if(baseModel!=null){
			
			String name = baseModel.get(JobOccurrencesModel.JOBNAME);
			
			MessageBoxConfirm mbc = new MessageBoxConfirm("Confirm delete", ConstantsPortletOccurrence.MESSAGE_CONFIRM_DELETE  + " "+ name+"? This operation will delete the data created by computation" );
			mbc.getMessageBoxConfirm().addCallback(new Listener<MessageBoxEvent>() {
		          
			public void handleEvent(MessageBoxEvent be) {
				
				//IF CANCELLED
				String clickedButton = be.getButtonClicked().getItemId();
				if(clickedButton.equals(Dialog.YES)){
					
					String computationId  = baseModel.get(JobOccurrencesModel.COMPUTATIONID);
					String occurrenceId  = baseModel.get(JobOccurrencesModel.JOBINDENTIFIER);
					
					OccurrenceApplicationController.getEventBus().fireEvent(new DeleteResourceEvent(computationId, occurrenceId, ElaborationType.COMPUTATION));

				}
			}	
			});
		}
		
	}
	
	
	public boolean deleteItemById(String identifier){
		
		BaseModelData baseModel = grid.getStore().findModel(JobOccurrencesModel.JOBINDENTIFIER, identifier);
		
		if(baseModel!=null)
				return deleteItem(baseModel);
	
		else
			System.out.println("Delete Error: file target with " + identifier + " identifier not exist in store" );
			
		return false;
	}


	/**
	 * 
	 * @param itemTarget (MANDATORY)
	 * @return
	 */
	private boolean deleteItem(BaseModelData itemTarget) {
	
		Record record = grid.getStore().getRecord(itemTarget);
		
		if (record != null) {
			
			BaseModelData item = (BaseModelData) record.getModel();
			grid.getStore().remove(item);
			return true;
		} else
			System.out.println("Record Error: occurrence target with "
					+ itemTarget.get(JobOccurrencesModel.JOBINDENTIFIER)
					+ " identifier not exist in store");
	
		return false;
	
	}
		
	public void enableButtonOnClick(boolean bool){
		this.buttonCancel.setEnabled(bool);
	}
	
	public JobManager getJobManager(){
		return jobManager;
	}
	
	public List<BaseModelData> getOccurrencesLoaded(){
		return this.grid.getStore().getModels();
	}
	
	private void refresh() {
		this.jobManager.reset();
		OccurrenceApplicationController.getEventBus().fireEvent(new ReLoadListOccurrencesEvent(ElaborationType.COMPUTATION));
	}
}
