package org.gcube.portlets.user.occurrencemanagement.client.job;

import java.util.ArrayList;
import java.util.List;

import org.gcube.portlets.user.occurrencemanagement.shared.JobOccurrencesModel;

import com.extjs.gxt.ui.client.Style.HorizontalAlignment;
import com.extjs.gxt.ui.client.data.ModelData;
import com.extjs.gxt.ui.client.store.ListStore;
import com.extjs.gxt.ui.client.widget.ContentPanel;
import com.extjs.gxt.ui.client.widget.LayoutContainer;
import com.extjs.gxt.ui.client.widget.grid.ColumnConfig;
import com.extjs.gxt.ui.client.widget.grid.ColumnModel;
import com.extjs.gxt.ui.client.widget.grid.Grid;
import com.extjs.gxt.ui.client.widget.layout.FitLayout;

public class JobsInfoContainer extends LayoutContainer {

	private ColumnModel cm;
	private Grid<ModelData> grid;
	private ContentPanel cp;
	private ListStore<ModelData> store;

	public JobsInfoContainer(ListStore<ModelData> store) {

		this.store = store;
		
		initContentPanel();

		List<ColumnConfig> columns = new ArrayList<ColumnConfig>();

		
		ColumnConfig name = new ColumnConfig(JobOccurrencesModel.JOBNAME, JobOccurrencesModel.JOBNAME, 200);
		columns.add(name);

		ColumnConfig status = new ColumnConfig(JobOccurrencesModel.STATUS, JobOccurrencesModel.STATUS, 70);
		columns.add(status);

		cm = new ColumnModel(columns);

		grid = new Grid<ModelData>(this.store, cm);
		grid.setBorders(true);
		grid.setStripeRows(true);
		grid.getView().setAutoFill(true);
		grid.setColumnLines(true);
		grid.setColumnReordering(true);
		grid.setStyleAttribute("borderTop", "none");
		
		cp.add(grid);
	}

	private void initContentPanel() {
		setLayout(new FitLayout());
		getAriaSupport().setPresentation(true);
		cp = new ContentPanel();
		cp.setHeaderVisible(false);
		cp.setBodyBorder(true);
		cp.setLayout(new FitLayout());
		cp.setButtonAlign(HorizontalAlignment.CENTER);
		cp.setLayout(new FitLayout());
//		cp.getHeader().setIconAltText("Grid Icon");
		cp.setSize(400, 250);

		add(cp);
	}
	
	public void updateStore(ListStore<ModelData> store){
	
		this.store.removeAll();
		for (ModelData modelData : store.getModels())
			this.store.add(modelData);
		
		cp.layout();
	}

	public void setHeaderTitle(String title) {
		cp.setHeading(title);
		cp.layout();
	}

}