/**
 * 
 */
package org.gcube.portlets.user.occurrencemanagement.client;

import org.gcube.portlets.user.occurrencemanagement.client.ConstantsPortletOccurrence.HeaderOccurrenceMenuItem;
import org.gcube.portlets.user.occurrencemanagement.client.event.HeaderMenuItemSelectEvent;
import org.gcube.portlets.user.occurrencemanagement.client.resources.Resources;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;

/**
 * 
 * @author Francesco Mangiacrapa francesco.mangiacrapa@isti.cnr.it
 *
 */
public class HeaderOccurrence extends HorizontalPanel {

	Image menuGoBack, menuInputData, menuOperation, menuComputation, logoOccurrence;
	HeaderOccurrenceMenuItem currentSelection = null;
	Image currentImageSelection = null;
	/**
	 * 
	 */
	public HeaderOccurrence() {
		super();
		
		logoOccurrence = new Image(Resources.logoOccurrence());


		
		menuInputData = new Image(Resources.menuItemData());
		menuInputData.addStyleName("menuItemImage");
		menuInputData.addClickHandler(new ClickHandler() {
			@Override
			public void onClick(ClickEvent event) {
				OccurrenceApplicationController.getEventBus().fireEvent(new HeaderMenuItemSelectEvent(HeaderOccurrenceMenuItem.DATA));
				setMenuSelected(HeaderOccurrenceMenuItem.DATA);
			}
		});
		
		menuOperation = new Image(Resources.menuItemOperations());
		menuOperation.addStyleName("menuItemImage");
		menuOperation.addClickHandler(new ClickHandler() {
			@Override
			public void onClick(ClickEvent event) {
				OccurrenceApplicationController.getEventBus().fireEvent(new HeaderMenuItemSelectEvent(HeaderOccurrenceMenuItem.OPERATION));
				setMenuSelected(HeaderOccurrenceMenuItem.OPERATION);
			}
		});
		

		menuComputation = new Image(Resources.menuItemComputations());
		menuComputation.addStyleName("menuItemImage");
		menuComputation.addClickHandler(new ClickHandler() {
			@Override
			public void onClick(ClickEvent event) {
				OccurrenceApplicationController.getEventBus().fireEvent(new HeaderMenuItemSelectEvent(HeaderOccurrenceMenuItem.COMPUTATION));
				setMenuSelected(HeaderOccurrenceMenuItem.COMPUTATION);
			}
		});
		
		
//		this.add(menuGoBack);
		this.add(logoOccurrence);
		this.add(menuInputData);
		this.add(menuOperation);
		this.add(menuComputation);


//		this.setCellWidth(menuGoBack, "100px");
		this.setCellWidth(menuInputData, "250px");
		this.setCellWidth(menuOperation, "250px");
		this.setCellWidth(menuComputation, "250px");
		
		setMenuSelected(HeaderOccurrenceMenuItem.DATA);
	}

	/**
	 * 
	 * @param menuItem
	 */
	public void setMenuSelected(HeaderOccurrenceMenuItem menuItem) {
		
		if (menuItem==null) {
			return;
		}else if(currentSelection!=null && currentSelection!=menuItem){
			//remove select style
			if (currentSelection==HeaderOccurrenceMenuItem.DATA)
				menuInputData.removeStyleName("menuItemImage-selected");
			else if (currentSelection==HeaderOccurrenceMenuItem.OPERATION)
				menuOperation.removeStyleName("menuItemImage-selected");
			else if (currentSelection==HeaderOccurrenceMenuItem.COMPUTATION)
				menuComputation.removeStyleName("menuItemImage-selected");
		}
		

		Image imgNew = (menuItem==HeaderOccurrenceMenuItem.DATA ? menuInputData : (menuItem==HeaderOccurrenceMenuItem.OPERATION ? menuOperation : menuComputation));				
		imgNew.addStyleName("menuItemImage-selected");				
		
//		}
		
		currentSelection = menuItem;
	}
}
