/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.occurrencemanagement.client.view.panel.data;

import com.extjs.gxt.ui.client.Style;
import com.extjs.gxt.ui.client.data.BaseModelData;
import com.extjs.gxt.ui.client.event.Events;
import com.extjs.gxt.ui.client.event.Listener;
import com.extjs.gxt.ui.client.event.SelectionListener;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.ContentPanel;
import com.extjs.gxt.ui.client.widget.button.Button;
import com.extjs.gxt.ui.client.widget.grid.Grid;
import com.extjs.gxt.ui.client.widget.menu.Menu;
import com.extjs.gxt.ui.client.widget.menu.MenuItem;
import com.extjs.gxt.ui.client.widget.toolbar.SeparatorToolItem;
import com.extjs.gxt.ui.client.widget.toolbar.ToolBar;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.resources.client.ImageResource;
import com.google.gwt.user.client.ui.AbstractImagePrototype;
import java.util.List;
import org.gcube.portlets.user.occurrencemanagement.client.OccurrenceApplicationController;
import org.gcube.portlets.user.occurrencemanagement.client.dialog.MessageBoxConfirm;
import org.gcube.portlets.user.occurrencemanagement.client.event.OpenTableEvent;
import org.gcube.portlets.user.occurrencemanagement.client.event.ReLoadListOccurrencesEvent;
import org.gcube.portlets.user.occurrencemanagement.client.job.JobManager;
import org.gcube.portlets.user.occurrencemanagement.client.job.WindowInfoJobsSpecies;
import org.gcube.portlets.user.occurrencemanagement.client.resources.Resources;
import org.gcube.portlets.user.occurrencemanagement.shared.ElaborationType;

public class ToolBarDataPanel
extends ContentPanel {
    private static final String VIEW = "View";
    private ToolBar toolbar;
    private JobManager jobManager;
    private Grid<BaseModelData> grid;
    private static final String INFO = "Info";
    private static final String CANCEL = "Cancel";
    private static final String REFRESH = "Refresh";
    private Button buttonInfo;
    private Button buttonView;
    private Button buttonCancel;
    private Button buttonRefresh;

    public ToolBarDataPanel() {
        this.setHeaderVisible(false);
        this.setBodyBorder(false);
        this.createGridToolBar();
    }

    private void createGridToolBar() {
        this.toolbar = new ToolBar();
        this.buttonInfo = new Button(INFO);
        this.buttonInfo.setScale(Style.ButtonScale.MEDIUM);
        this.buttonInfo.setIcon(AbstractImagePrototype.create((ImageResource)Resources.getImageInfo()));
        this.buttonInfo.setStyleAttribute("margin-left", "5px");
        this.buttonInfo.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.buttonView = new Button(VIEW);
        this.buttonView.setIcon(AbstractImagePrototype.create((ImageResource)Resources.getImageTable()));
        this.buttonView.setScale(Style.ButtonScale.MEDIUM);
        this.buttonView.addListener(Events.OnClick, (Listener)new /* Unavailable Anonymous Inner Class!! */);
        this.buttonCancel = new Button(CANCEL);
        this.buttonCancel.setScale(Style.ButtonScale.MEDIUM);
        this.buttonCancel.setIcon(AbstractImagePrototype.create((ImageResource)Resources.getImageDelete()));
        this.buttonCancel.addListener(Events.OnClick, (Listener)new /* Unavailable Anonymous Inner Class!! */);
        this.buttonRefresh = new Button(REFRESH);
        this.buttonRefresh.setScale(Style.ButtonScale.MEDIUM);
        this.buttonRefresh.setIcon(Resources.getIconRefresh());
        this.buttonRefresh.addListener(Events.OnClick, (Listener)new /* Unavailable Anonymous Inner Class!! */);
        this.toolbar.add((Component)this.buttonInfo);
        this.toolbar.add((Component)new SeparatorToolItem());
        this.toolbar.add((Component)this.buttonView);
        this.toolbar.add((Component)new SeparatorToolItem());
        this.toolbar.add((Component)this.buttonCancel);
        this.toolbar.add((Component)new SeparatorToolItem());
        this.toolbar.add((Component)this.buttonRefresh);
        this.toolbar.add((Component)new SeparatorToolItem());
        this.setTopComponent((Component)this.toolbar);
        this.enableButtonOnClick(false);
    }

    public void createMenuItemsOnGrid() {
        Menu menu = new Menu();
        MenuItem menuInfo = new MenuItem();
        menuInfo.setId(INFO);
        menuInfo.setText(INFO);
        menuInfo.setIcon(AbstractImagePrototype.create((ImageResource)Resources.getImageInfo()));
        menuInfo.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        menu.add((Component)menuInfo);
        MenuItem menuView = new MenuItem();
        menuView.setId(VIEW);
        menuView.setText(VIEW);
        menuView.setIcon(AbstractImagePrototype.create((ImageResource)Resources.getImageTable()));
        menuView.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        menu.add((Component)menuView);
        MenuItem menuCancel = new MenuItem();
        menuCancel.setId(CANCEL);
        menuCancel.setText(CANCEL);
        menuCancel.setIcon(AbstractImagePrototype.create((ImageResource)Resources.getImageDelete()));
        menuCancel.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        menu.add((Component)menuCancel);
        this.grid.setContextMenu(menu);
    }

    private void cancel(BaseModelData jobModel) {
        if (jobModel != null) {
            String name = (String)jobModel.get("Name");
            MessageBoxConfirm mbc = new MessageBoxConfirm("Confirm delete", "Are you sure you want to delete " + name + "?");
            mbc.getMessageBoxConfirm().addCallback((Listener)new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    private void info(BaseModelData jobModel) {
        if (jobModel != null) {
            String id = (String)jobModel.get("jobIdentifier");
            WindowInfoJobsSpecies win = (WindowInfoJobsSpecies)this.jobManager.getGridJob().getListWindowInfo().get(id);
            win.show();
        }
    }

    private void view(BaseModelData jobModel) {
        if (jobModel != null) {
            String id = (String)jobModel.get("jobIdentifier");
            String name = (String)jobModel.get("Name");
            OccurrenceApplicationController.getEventBus().fireEvent((GwtEvent)new OpenTableEvent(id, name));
        }
    }

    public void enableButtonOnClick(boolean bool) {
        this.buttonCancel.setEnabled(bool);
        this.buttonInfo.setEnabled(bool);
        this.buttonView.setEnabled(bool);
    }

    public JobManager getJobManager() {
        return this.jobManager;
    }

    public List<BaseModelData> getOccurrencesLoaded() {
        return this.grid.getStore().getModels();
    }

    private void refresh() {
        this.jobManager.reset();
        OccurrenceApplicationController.getEventBus().fireEvent((GwtEvent)new ReLoadListOccurrencesEvent(ElaborationType.IMPORTED));
    }

    static /* synthetic */ Grid access$000(ToolBarDataPanel x0) {
        return x0.grid;
    }

    static /* synthetic */ void access$100(ToolBarDataPanel x0, BaseModelData x1) {
        x0.info(x1);
    }

    static /* synthetic */ void access$200(ToolBarDataPanel x0, BaseModelData x1) {
        x0.view(x1);
    }

    static /* synthetic */ void access$300(ToolBarDataPanel x0, BaseModelData x1) {
        x0.cancel(x1);
    }

    static /* synthetic */ void access$400(ToolBarDataPanel x0) {
        x0.refresh();
    }
}

