/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.occurrencemanagement.client.view.panel.computation;

import com.extjs.gxt.ui.client.Style;
import com.extjs.gxt.ui.client.data.BaseModelData;
import com.extjs.gxt.ui.client.data.ModelData;
import com.extjs.gxt.ui.client.event.Events;
import com.extjs.gxt.ui.client.event.Listener;
import com.extjs.gxt.ui.client.event.SelectionChangedListener;
import com.extjs.gxt.ui.client.event.SelectionListener;
import com.extjs.gxt.ui.client.store.Record;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.ContentPanel;
import com.extjs.gxt.ui.client.widget.Layout;
import com.extjs.gxt.ui.client.widget.button.Button;
import com.extjs.gxt.ui.client.widget.grid.Grid;
import com.extjs.gxt.ui.client.widget.layout.FitLayout;
import com.extjs.gxt.ui.client.widget.menu.Menu;
import com.extjs.gxt.ui.client.widget.menu.MenuItem;
import com.extjs.gxt.ui.client.widget.toolbar.SeparatorToolItem;
import com.extjs.gxt.ui.client.widget.toolbar.ToolBar;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.resources.client.ImageResource;
import com.google.gwt.user.client.ui.AbstractImagePrototype;
import java.util.List;
import org.gcube.portlets.user.occurrencemanagement.client.OccurrenceApplicationController;
import org.gcube.portlets.user.occurrencemanagement.client.dialog.MessageBoxConfirm;
import org.gcube.portlets.user.occurrencemanagement.client.event.ReLoadListOccurrencesEvent;
import org.gcube.portlets.user.occurrencemanagement.client.job.JobManager;
import org.gcube.portlets.user.occurrencemanagement.client.resources.Resources;
import org.gcube.portlets.user.occurrencemanagement.shared.ElaborationType;

public class GridComputationPanel
extends ContentPanel {
    private ToolBar toolbar;
    private JobManager jobManager;
    private Grid<BaseModelData> grid;
    private static final String CANCEL = "Cancel";
    private static final String REFRESH = "Refresh";
    private Button buttonCancel;
    private Button buttonRefresh;

    public GridComputationPanel(JobManager jobManager) {
        this.setBorders(false);
        this.setLayout((Layout)new FitLayout());
        this.setHeaderVisible(false);
        this.setHeading("Computation");
        this.jobManager = jobManager;
        this.grid = jobManager.getGridJob().getGrid();
        this.grid.getStore().sort("End Time", Style.SortDir.ASC);
        this.grid.getSelectionModel().addSelectionChangedListener((SelectionChangedListener)new /* Unavailable Anonymous Inner Class!! */);
        this.grid.getView().setAutoFill(true);
        this.createGridToolBar();
        this.createMenuItemsOnGrid();
        this.add((Component)jobManager.getGridJob());
    }

    public void updateProgressSize() {
        this.jobManager.getGridJob().updateProgressSize();
    }

    private void createGridToolBar() {
        this.toolbar = new ToolBar();
        this.buttonCancel = new Button(CANCEL);
        this.buttonCancel.setScale(Style.ButtonScale.MEDIUM);
        this.buttonCancel.setIcon(AbstractImagePrototype.create((ImageResource)Resources.getImageDelete()));
        this.buttonCancel.addListener(Events.OnClick, (Listener)new /* Unavailable Anonymous Inner Class!! */);
        this.buttonRefresh = new Button(REFRESH);
        this.buttonRefresh.setScale(Style.ButtonScale.MEDIUM);
        this.buttonRefresh.setIcon(Resources.getIconRefresh());
        this.buttonRefresh.addListener(Events.OnClick, (Listener)new /* Unavailable Anonymous Inner Class!! */);
        this.toolbar.add((Component)this.buttonCancel);
        this.toolbar.add((Component)new SeparatorToolItem());
        this.toolbar.add((Component)this.buttonRefresh);
        this.toolbar.add((Component)new SeparatorToolItem());
        this.setTopComponent((Component)this.toolbar);
        this.enableButtonOnClick(false);
    }

    public void createMenuItemsOnGrid() {
        Menu menu = new Menu();
        MenuItem menuCancel = new MenuItem();
        menuCancel.setId(CANCEL);
        menuCancel.setText(CANCEL);
        menuCancel.setIcon(AbstractImagePrototype.create((ImageResource)Resources.getImageDelete()));
        menuCancel.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        menu.add((Component)menuCancel);
        this.grid.setContextMenu(menu);
    }

    private void cancel(BaseModelData baseModel) {
        if (baseModel != null) {
            String name = (String)baseModel.get("Name");
            MessageBoxConfirm mbc = new MessageBoxConfirm("Confirm delete", "Are you sure you want to delete " + name + "? This operation will delete the data created by computation");
            mbc.getMessageBoxConfirm().addCallback((Listener)new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    public boolean deleteItemById(String identifier) {
        BaseModelData baseModel = (BaseModelData)this.grid.getStore().findModel("jobIdentifier", (Object)identifier);
        if (baseModel != null) {
            return this.deleteItem(baseModel);
        }
        System.out.println("Delete Error: file target with " + identifier + " identifier not exist in store");
        return false;
    }

    private boolean deleteItem(BaseModelData itemTarget) {
        Record record = this.grid.getStore().getRecord((ModelData)itemTarget);
        if (record != null) {
            BaseModelData item = (BaseModelData)record.getModel();
            this.grid.getStore().remove((ModelData)item);
            return true;
        }
        System.out.println("Record Error: occurrence target with " + itemTarget.get("jobIdentifier") + " identifier not exist in store");
        return false;
    }

    public void enableButtonOnClick(boolean bool) {
        this.buttonCancel.setEnabled(bool);
    }

    public JobManager getJobManager() {
        return this.jobManager;
    }

    public List<BaseModelData> getOccurrencesLoaded() {
        return this.grid.getStore().getModels();
    }

    private void refresh() {
        this.jobManager.reset();
        OccurrenceApplicationController.getEventBus().fireEvent((GwtEvent)new ReLoadListOccurrencesEvent(ElaborationType.COMPUTATION));
    }

    static /* synthetic */ Grid access$000(GridComputationPanel x0) {
        return x0.grid;
    }

    static /* synthetic */ void access$100(GridComputationPanel x0, BaseModelData x1) {
        x0.cancel(x1);
    }

    static /* synthetic */ void access$200(GridComputationPanel x0) {
        x0.refresh();
    }
}

