package org.gcube.portlets.user.occurrencemanagement.client.view.panel.operation;


import org.gcube.portlets.user.occurrencemanagement.client.view.panel.data.ToolBarDataPanel;

import com.extjs.gxt.ui.client.Style.LayoutRegion;
import com.extjs.gxt.ui.client.Style.Scroll;
import com.extjs.gxt.ui.client.util.Margins;
import com.extjs.gxt.ui.client.widget.ContentPanel;
import com.extjs.gxt.ui.client.widget.layout.BorderLayout;
import com.extjs.gxt.ui.client.widget.layout.BorderLayoutData;
import com.extjs.gxt.ui.client.widget.layout.FitLayout;


/**
 * @author Francesco Mangiacrapa francesco.mangiacrapa@isti.cnr.it
 *
 */
public class GxtBorderLayoutOperationPanel extends ContentPanel {
	private ContentPanel north = new ContentPanel();
	private ContentPanel west = new ContentPanel();
	private ContentPanel center = new ContentPanel();
	private CenterAlgorithmPanelMng operationPanel;
	private ExplorerOperationPanelMng explorerDataPanel;

	
	public GxtBorderLayoutOperationPanel(CenterAlgorithmPanelMng operationPanel, ExplorerOperationPanelMng explorerPanel) {
		this.operationPanel = operationPanel;
		this.explorerDataPanel = explorerPanel;
		this.initLayout();
		this.createLayouts();
	}

	private void initLayout(){
			
		north.setId("NorthOperationPanel");
		north.setLayout(new FitLayout());
		north.setHeaderVisible(false);
	    north.setBodyBorder(false);
		
		west.setId("WestOperationPanel");
		west.setLayout(new FitLayout());
		west.setHeaderVisible(false);
		west.setBodyBorder(false);
		
		center.setId("CenterOperationPanel");
		center.setLayout(new FitLayout());
		center.setBodyBorder(false);
	    center.setHeaderVisible(false);
		center.setScrollMode(Scroll.AUTOX);
		center.setBorders(false);
		
	}
		
	public void createLayouts(){
		final BorderLayout borderLayout = new BorderLayout();
		setLayout(borderLayout);

		setHeaderVisible(false);
		
	    BorderLayoutData northData = new BorderLayoutData(LayoutRegion.NORTH, 37, 37, 37);  
	    northData.setCollapsible(false);  

	    BorderLayoutData westData = new BorderLayoutData(LayoutRegion.WEST, 450,550,600);  
	    westData.setSplit(true);  
	    westData.setCollapsible(true);  
	    westData.setMargins(new Margins(0,3,0,0));
	  
	    BorderLayoutData centerData = new BorderLayoutData(LayoutRegion.CENTER);  
	    centerData.setMargins(new Margins(0));


	    north.add(new ToolBarDataPanel());
	    west.add(explorerDataPanel);
	    center.add(operationPanel);

	    add(west, westData); 
	    add(center, centerData);  
	}

	public void updateHeight(int rootHeight) {
		setHeight(rootHeight);
	}

	public void updateWidth(int rootWidth) {
		setWidth(rootWidth);

	}
}