package org.gcube.portlets.user.occurrencemanagement.client.view.panel.data;

import org.gcube.portlets.user.occurrencemanagement.shared.TableInfo;

import com.extjs.gxt.ui.client.Style.Scroll;
import com.extjs.gxt.ui.client.widget.LayoutContainer;
import com.extjs.gxt.ui.client.widget.layout.FitLayout;

/**
 * @author Francesco Mangiacrapa francesco.mangiacrapa@isti.cnr.it
 *
 */
public class CenterDataPanelMng extends LayoutContainer{
	
	private static final String OCCURRENCES_TABLE = "Occurrences Table";
	private TabularDataOccurrencePanel occurrencesLoadedPanel;

	public CenterDataPanelMng() {
		setLayout(new FitLayout());
		setScrollMode(Scroll.AUTOY);
		setBorders(false);
		occurrencesLoadedPanel  = new TabularDataOccurrencePanel(OCCURRENCES_TABLE);
		add(occurrencesLoadedPanel);
	}
	
	public void openTableInView(TableInfo tableInfo, String titleName){
		occurrencesLoadedPanel.openTable(tableInfo);
		occurrencesLoadedPanel.setHeading(OCCURRENCES_TABLE + ": " + titleName);
		
		System.out.println("Open table with table info: "+tableInfo);
	}
			
	public void setGridWidth(int value){
		occurrencesLoadedPanel.setGridWidth(value);
	}
	
	public void setGridHeight(int value){
		occurrencesLoadedPanel.setGridHeigth(value);
	}
}
