package org.gcube.portlets.user.occurrencemanagement.client.rpc;

import java.util.List;

import org.gcube.portlets.user.occurrencemanagement.shared.ElaborationType;
import org.gcube.portlets.user.occurrencemanagement.shared.JobOccurrencesModel;
import org.gcube.portlets.user.occurrencemanagement.shared.statisticalparameter.Operator;

import com.google.gwt.user.client.rpc.RemoteService;
import com.google.gwt.user.client.rpc.RemoteServiceRelativePath;

/**
 * The client side stub for the RPC service.
 */
@RemoteServiceRelativePath("occurrence")
public interface OccurrenceManagementService extends RemoteService {

	public List<JobOccurrencesModel> getListOccurrencesSet(ElaborationType elaborationType,  boolean onlyNotCompleted) throws Exception;
	
	public List<Operator> getListOperator() throws Exception;

	public String startComputation(Operator operator, String computationTitle, String computationDescription) throws Exception;
	
	public Boolean saveSelectedOccurrencePoints(String resourceId, ElaborationType elaborationType, String destinationFolderId, String fileName) throws Exception;
	
	public void deleteResourceById(String resourceId) throws Exception;

}
