package org.gcube.portlets.user.occurrencemanagement.client;

import com.google.gwt.core.client.EntryPoint;
import com.google.gwt.event.logical.shared.ResizeEvent;
import com.google.gwt.event.logical.shared.ResizeHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.RootPanel;

/**
 * Entry point classes define <code>onModuleLoad()</code>.
 */
public class OccurrenceManagement implements EntryPoint {
	
	
	OccurrenceApplicationController appController;

	/**
	 * This is the entry point method.
	 */
	public void onModuleLoad() {
		appController = new OccurrenceApplicationController();
		appController.go(RootPanel.get(ConstantsPortletOccurrence.PORTLETDIV));
				
		 Window.addResizeHandler(new ResizeHandler() {
             @Override
             public void onResize(ResizeEvent event) {
                     System.out.println("onWindowResized width: "+event.getWidth()+" height: "+event.getHeight());
                     updateSize();
             }
		 });
		 
		 updateSize();

		}
	
	/**
	 * Update window size
	 */
    public void updateSize(){
    	
	    RootPanel workspace = RootPanel.get(ConstantsPortletOccurrence.PORTLETDIV);
	     
	    int topBorder = workspace.getAbsoluteTop();
	     
	    int leftBorder = workspace.getAbsoluteLeft();
	     
	     
	    int rootHeight = Window.getClientHeight() - topBorder - 4;// - ((footer == null)?0:(footer.getOffsetHeight()-15));
	     
	    int rootWidth = Window.getClientWidth() - 2* leftBorder; //- rightScrollBar;
	    
//	    System.out.println("New workspace dimension Height: "+rootHeight+" Width: "+rootWidth);
	    
	    appController.getMainPanel().updateHeight(rootHeight);
	    appController.getMainPanel().updateWidth(rootWidth);
    }
}
