/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.notifications.client.view;

import com.github.gwtbootstrap.client.ui.Button;
import com.github.gwtbootstrap.client.ui.Modal;
import com.github.gwtbootstrap.client.ui.ModalFooter;
import com.github.gwtbootstrap.client.ui.constants.ButtonType;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HasAlignment;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import org.gcube.portlets.user.notifications.client.NotificationsServiceAsync;
import org.gcube.portlets.user.notifications.client.view.templates.CategoryWrapper;
import org.gcube.portlets.user.notifications.shared.NotificationPreference;

public class NotificationSettingsDialog
extends Modal {
    public static final String loading = GWT.getModuleBaseURL() + "../images/feeds-loader.gif";
    public static final String mailSentOK = GWT.getModuleBaseURL() + "../images/yes.png";
    public static final String mailSentNOK = GWT.getModuleBaseURL() + "../images/warning_blue.png";
    public static final int WIDTH = 950;
    ArrayList<CategoryWrapper> myCategories = new ArrayList();
    private VerticalPanel placeholder = new VerticalPanel();
    private ModalFooter footer = new ModalFooter();
    private Button cancel = new Button("Cancel");
    private Button save = new Button("Save");

    public NotificationSettingsDialog(LinkedHashMap<String, ArrayList<NotificationPreference>> preferences, NotificationsServiceAsync notificationService) {
        this.setAnimation(true);
        this.setWidth(950);
        this.setTitle("Notification Settings");
        this.placeholder.setWidth("950px");
        this.placeholder.setHorizontalAlignment(HasAlignment.ALIGN_CENTER);
        this.add((Widget)this.placeholder);
        for (String category : preferences.keySet()) {
            CategoryWrapper cat = new CategoryWrapper(category, preferences.get(category));
            this.add((Widget)cat);
            this.myCategories.add(cat);
        }
        this.save.setType(ButtonType.PRIMARY);
        this.footer.add((Widget)this.save);
        this.footer.add((Widget)this.cancel);
        this.add((Widget)this.footer);
        this.save.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.cancel.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void showDeliveryResult(boolean success) {
        for (CategoryWrapper cat : this.myCategories) {
            cat.removeFromParent();
        }
        if (success) {
            this.placeholder.add((Widget)new HTML("<span style=\"font-size: 20px;\">Notifications Settings saved correctly</span>"));
            this.placeholder.add((Widget)new Image(mailSentOK));
        } else {
            this.placeholder.add((Widget)new Image(mailSentNOK));
            this.placeholder.add((Widget)new HTML("<span style=\"font-size: 20px;\">Sorry, there were problems contacting the server, please try again in a short while.</span>"));
        }
        Button close = new Button("Close");
        close.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.footer.clear();
        this.footer.add((Widget)close);
        this.add((Widget)this.footer);
    }

    static /* synthetic */ void access$000(NotificationSettingsDialog x0, boolean x1) {
        x0.showDeliveryResult(x1);
    }
}

