/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.notifications.client.view.templates;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.query.client.Function;
import com.google.gwt.query.client.GQuery;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.HashMap;
import org.gcube.portal.databook.shared.NotificationChannelType;
import org.gcube.portal.databook.shared.NotificationType;
import org.gcube.portlets.user.gcubewidgets.client.elements.Span;
import org.gcube.portlets.user.notifications.client.view.switchbutton.SwitchButton;
import org.gcube.portlets.user.notifications.client.view.templates.CategoryWrapper;
import org.gcube.portlets.user.notifications.client.view.templates.NotificationPreferenceView;
import org.gcube.portlets.user.notifications.shared.NotificationPreference;

public class CategoryWrapper
extends Composite {
    private static CategoryWrapperUiBinder uiBinder = (CategoryWrapperUiBinder)GWT.create(CategoryWrapperUiBinder.class);
    @UiField
    Span categoryLabel;
    @UiField
    SwitchButton switchButton;
    @UiField
    CheckBox portalCheckbox;
    @UiField
    CheckBox emailCheckbox;
    @UiField
    VerticalPanel categoryPanel;
    ArrayList<NotificationPreferenceView> myPreferences = new ArrayList();

    public CategoryWrapper(String catName, ArrayList<NotificationPreference> preferences) {
        this.initWidget((Widget)uiBinder.createAndBindUi((Object)this));
        this.categoryLabel.setText(catName);
        boolean atLeastOnePreferenceOn = false;
        for (NotificationPreference pref : preferences) {
            NotificationPreferenceView toAdd = new NotificationPreferenceView(pref);
            this.categoryPanel.add((Widget)toAdd);
            this.myPreferences.add(toAdd);
            if (pref.getSelectedChannels()[0] == null || atLeastOnePreferenceOn) continue;
            atLeastOnePreferenceOn = true;
        }
        if (!atLeastOnePreferenceOn) {
            this.setOff();
        } else {
            this.switchButton.setValue(Boolean.valueOf(true));
        }
        this.switchButton.addValueChangeHandler((ValueChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.emailCheckbox.addValueChangeHandler((ValueChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.portalCheckbox.addValueChangeHandler((ValueChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void setOff() {
        int i = this.categoryPanel.getWidgetCount() - 1;
        while (i >= 0) {
            GQuery.$((Object)this.categoryPanel.getWidget(i)).slideUp(0, new Function[0]);
            GQuery.$((Object)this.portalCheckbox).fadeOut(50, new Function[0]);
            GQuery.$((Object)this.emailCheckbox).fadeOut(50, new Function[0]);
            --i;
        }
        this.switchButton.setValue(Boolean.valueOf(false));
    }

    public HashMap<NotificationType, NotificationChannelType[]> getSelectedChannels() {
        HashMap<NotificationType, NotificationChannelType[]> toReturn = new HashMap<NotificationType, NotificationChannelType[]>();
        if (this.switchButton.getValue().booleanValue()) {
            for (NotificationPreferenceView notPref : this.myPreferences) {
                if (notPref.getSelectedChannels() != null && notPref.getSelectedChannels().length > 0) {
                    toReturn.put(notPref.getNotificationType(), notPref.getSelectedChannels());
                    continue;
                }
                toReturn.put(notPref.getNotificationType(), new NotificationChannelType[0]);
            }
        } else {
            for (NotificationPreferenceView notPref : this.myPreferences) {
                toReturn.put(notPref.getNotificationType(), new NotificationChannelType[0]);
            }
        }
        return toReturn;
    }
}

