package org.gcube.portlets.user.notifications.client.view;

import java.util.ArrayList;
import java.util.HashMap;

import org.gcube.portal.databook.shared.NotificationChannelType;
import org.gcube.portlets.user.gcubewidgets.client.popup.GCubeDialog;
import org.gcube.portlets.user.notifications.client.NotificationsServiceAsync;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HasAlignment;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.VerticalPanel;


/**
 * @author Massimiliano Assante ISTI-CNR
 *
 */
public class NotificationSettings extends GCubeDialog {

	private VerticalPanel container = new VerticalPanel();
	private HorizontalPanel buttonsContainerPanel = new HorizontalPanel();
	private HorizontalPanel buttonsPanel = new HorizontalPanel();
	
	public static final String loading = GWT.getModuleBaseURL() + "../images/feeds-loader.gif";
	public static final String mailSentOK = GWT.getModuleBaseURL() + "../images/yes.png";
	public static final String mailSentNOK = GWT.getModuleBaseURL() + "../images/warning_blue.png";
	
	private CheckBox portalCheckbox = new CheckBox("Infrastructure Gateway (this portal)");
	private CheckBox emailCheckbox = new CheckBox("Email");
	private HTML how = new HTML("<span style=\"font-size: 13px;\">How You Get Notifications:</span>");
		
	private Button cancel = new Button("Cancel");
	private Button save = new Button("Save");
	
	public NotificationSettings(final ArrayList<NotificationChannelType> currentChannels, final NotificationsServiceAsync notificationService) {
		super();
		buttonsPanel.setWidth("100%");
		buttonsPanel.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_RIGHT);
		
		container.setStyleName("user-notification");
		container.setWidth("400px");
		container.add(how);
		container.add(new HTML("&nbsp;"));
		container.add(portalCheckbox);
		container.add(emailCheckbox);
		
		buttonsContainerPanel.add(cancel);
		buttonsContainerPanel.add(save);
		buttonsPanel.add(buttonsContainerPanel);
		container.add(buttonsPanel);
		
		setText("Notification Settings");
		setWidget(container);
		
		if (currentChannels.contains(NotificationChannelType.EMAIL))
			emailCheckbox.setValue(true);
		
		if (currentChannels.contains(NotificationChannelType.PORTAL))
			portalCheckbox.setValue(true);
		
		save.addClickHandler(new ClickHandler() {
			@Override
			public void onClick(ClickEvent event) {
				boolean portalChanged = (portalCheckbox.getValue() && !currentChannels.contains(NotificationChannelType.PORTAL) ||
						!portalCheckbox.getValue() && currentChannels.contains(NotificationChannelType.PORTAL));
				
				boolean emailChanged = (emailCheckbox.getValue() && !currentChannels.contains(NotificationChannelType.EMAIL) ||
						!emailCheckbox.getValue() && currentChannels.contains(NotificationChannelType.EMAIL));
				
				HashMap<NotificationChannelType, Boolean> newSettings = new HashMap<NotificationChannelType, Boolean>();
				if (portalChanged) {
					newSettings.put(NotificationChannelType.PORTAL, portalCheckbox.getValue());
				}
				if (emailChanged) {
					newSettings.put(NotificationChannelType.EMAIL, emailCheckbox.getValue());
				}
				
				if (portalChanged || emailChanged)
					notificationService.setNotificationChannels(newSettings, new AsyncCallback<Boolean>() {
						@Override
						public void onSuccess(Boolean result) {
							showDeliveryResult(result);
							
						}
						@Override
						public void onFailure(Throwable caught) {
							showDeliveryResult(false);
						}
					});
				else
					showDeliveryResult(true);
				
			}
		});
		
		cancel.addClickHandler(new ClickHandler() {
			
			@Override
			public void onClick(ClickEvent event) {
				hide();				
			}
		});
		
	}
	
	private void showDeliveryResult(boolean success) {
		container.clear();
		container.setHorizontalAlignment(HasAlignment.ALIGN_CENTER);
		container.setVerticalAlignment(HasVerticalAlignment.ALIGN_MIDDLE);
		if (success) {
			setText("Notifications Settings Saved");
			container.add(new Image(mailSentOK));
		}
		else {
			setText("Notifications Settings Saving Error");
			container.add(new Image(mailSentNOK));
			container.add(new HTML("There were problems contacting the server, please try again in a short while."));
			Button close = new Button("Close");
			close.addClickHandler(new ClickHandler() {				
				@Override
				public void onClick(ClickEvent event) {
					hide();					
				}
			});
		}
		Button close = new Button("Close");
		close.addClickHandler(new ClickHandler() {		
			@Override
			public void onClick(ClickEvent event) {
				hide();				
			}
		});
		container.add(close);		
	}

}
