package org.gcube.portlets.user.notifications.server;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;

import org.gcube.application.framework.core.session.ASLSession;
import org.gcube.application.framework.core.session.SessionManager;
import org.gcube.common.core.utils.logging.GCUBEClientLog;
import org.gcube.portal.custom.communitymanager.OrganizationsUtil;
import org.gcube.portal.custom.scopemanager.scopehelper.ScopeHelper;
import org.gcube.portal.databook.server.DBCassandraAstyanaxImpl;
import org.gcube.portal.databook.server.DatabookStore;
import org.gcube.portal.databook.shared.Notification;
import org.gcube.portal.databook.shared.NotificationChannelType;
import org.gcube.portal.databook.shared.UserInfo;
import org.gcube.portal.databook.shared.ex.NotificationChannelTypeNotFoundException;
import org.gcube.portlets.user.notifications.client.NotificationsService;

import com.google.gwt.user.server.rpc.RemoteServiceServlet;
import com.liferay.portal.kernel.util.WebKeys;
import com.liferay.portal.model.UserModel;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.theme.ThemeDisplay;

/**
 * The server side implementation of the RPC service.
 */
@SuppressWarnings("serial")
public class NotificationsServiceImpl extends RemoteServiceServlet implements NotificationsService {
	/**
	 * 
	 */
	private static GCUBEClientLog _log = new GCUBEClientLog(NotificationsServiceImpl.class);
	/**
	 * The store interface
	 */
	private DatabookStore store;
	/**
	 * used for debugging in eclipse
	 */
	private boolean withinPortal = false;
	/**
	 * connect to cassandra at startup
	 */
	public void init() {
		store = new DBCassandraAstyanaxImpl();
	}

	public void destroy() {
		store.closeConnection();
	}

	/**
	 * the current ASLSession
	 * @return the session
	 */
	private ASLSession getASLSession() {
		String sessionID = this.getThreadLocalRequest().getSession().getId();
		String user = (String) this.getThreadLocalRequest().getSession().getAttribute(ScopeHelper.USERNAME_ATTRIBUTE);
		if (user == null) {
			user = "test.user";
			//user = "massimiliano.assante";

			_log.warn("USER IS NULL setting "+user+" and Running OUTSIDE PORTAL");
			withinPortal = false;
		}
		else {
			withinPortal = true;
		}
		System.out.println("SessionID = " + sessionID);
		return SessionManager.getInstance().getASLSession(sessionID, user);
	}

	public UserInfo getUserInfo() {
		try {
			String username = getASLSession().getUsername();
			String email = username+"@isti.cnr.it";
			String fullName = username+" FULL";
			String thumbnailURL = "images/Avatar_default.png";

			if (withinPortal) {
				UserModel user = UserLocalServiceUtil.getUserByScreenName(OrganizationsUtil.getCompany().getCompanyId(), username);
				thumbnailURL = "/image/user_male_portrait?img_id="+user.getPortraitId();
				fullName = user.getFirstName() + " " + user.getLastName();
				email = user.getEmailAddress();
				ThemeDisplay themeDisplay = (ThemeDisplay) this.getThreadLocalRequest().getSession().getAttribute(WebKeys.THEME_DISPLAY);
				String accountURL = themeDisplay.getURLMyAccount().toString();
				UserInfo toReturn = new UserInfo(username, fullName, thumbnailURL, user.getEmailAddress(), accountURL, true, false, null);
				return toReturn;
			}
			else {
				_log.info("Returning test USER");
				return new UserInfo(getASLSession().getUsername(), fullName, thumbnailURL, email, "fakeAccountUrl", true, false, null);
			}

		} catch (Exception e) {
			e.printStackTrace();
		}
		return new UserInfo();
	}
	
	/**
	 * returns the notifications separated per days
	 */
	public HashMap<Date, ArrayList<Notification>> getUserNotifications() {
		HashMap<Date, ArrayList<Notification>> toReturn = new HashMap<Date, ArrayList<Notification>>();
		try {
			for (Notification notification : store.getAllNotificationByUser(getASLSession().getUsername(), 20)) {
				Date dateWithoutTime = removeTimePart(notification.getTime());
				if (! toReturn.containsKey(dateWithoutTime)) {
					ArrayList<Notification> nots = new ArrayList<Notification>();
					nots.add(notification);
					toReturn.put(dateWithoutTime, nots);
				} else {
					toReturn.get(dateWithoutTime).add(notification);
				}				
			}
		} catch (Exception e) {
			_log.error("While trying to get User notifications");
			e.printStackTrace();
		}
		return toReturn;
	}
	/**
	 * we want notification split per day
	 * @param date
	 * @return the date passad as param with time part set to 00:00:00.0
	 */
	private Date removeTimePart(Date date) {
		Calendar cal = Calendar.getInstance();  
		cal.setTime(date);  

		// Set time fields to zero  
		cal.set(Calendar.HOUR_OF_DAY, 0);  
		cal.set(Calendar.MINUTE, 0);  
		cal.set(Calendar.SECOND, 0);  
		cal.set(Calendar.MILLISECOND, 0);  

		return cal.getTime();  
	}
	/**
	 * this sets all the notifications for this user read
	 */
	public boolean setAllUserNotificationsRead() {
		try {
			store.setAllNotificationReadByUser(getASLSession().getUsername());
		} catch (Exception e) {
			_log.error("While trying to set User notifications Read");
			e.printStackTrace();
		}
		return false;
	}

	@Override
	public ArrayList<NotificationChannelType> getNotificationChannels() {
		ArrayList<NotificationChannelType> toReturn = new ArrayList<NotificationChannelType>();
		try {
			for (NotificationChannelType channel : store.getUserNotificationChannels(getASLSession().getUsername())) 
				toReturn.add(channel);
		
		} catch (NotificationChannelTypeNotFoundException e) {
			e.printStackTrace();
		}
		return toReturn;
	}

	@Override
	public boolean setNotificationChannels(HashMap<NotificationChannelType, Boolean> newSettings) {
		boolean toReturn = false;
		for (NotificationChannelType type : newSettings.keySet()) {
			_log.error("Trying to set User notification Setting: " + type +  " to: " + newSettings.get(type));
			toReturn = store.setUserNotificationChannel(getASLSession().getUsername(), type, newSettings.get(type));
		}
		return toReturn;
	}
}
