/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.notifications.server;

import com.google.gwt.user.server.rpc.RemoteServiceServlet;
import com.liferay.portal.model.User;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.theme.ThemeDisplay;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Properties;
import org.gcube.application.framework.core.session.ASLSession;
import org.gcube.application.framework.core.session.SessionManager;
import org.gcube.common.core.utils.logging.GCUBEClientLog;
import org.gcube.portal.custom.communitymanager.OrganizationsUtil;
import org.gcube.portal.databook.server.DBCassandraAstyanaxImpl;
import org.gcube.portal.databook.server.DatabookStore;
import org.gcube.portal.databook.shared.Notification;
import org.gcube.portal.databook.shared.NotificationChannelType;
import org.gcube.portal.databook.shared.UserInfo;
import org.gcube.portal.databook.shared.ex.NotificationChannelTypeNotFoundException;
import org.gcube.portlets.user.notifications.client.NotificationsService;

public class NotificationsServiceImpl
extends RemoteServiceServlet
implements NotificationsService {
    private static GCUBEClientLog _log = new GCUBEClientLog(NotificationsServiceImpl.class, new Properties[0]);
    private DatabookStore store;
    private boolean withinPortal = false;

    public void init() {
        this.store = new DBCassandraAstyanaxImpl();
    }

    public void destroy() {
        this.store.closeConnection();
    }

    private ASLSession getASLSession() {
        String sessionID = this.getThreadLocalRequest().getSession().getId();
        String user = (String)this.getThreadLocalRequest().getSession().getAttribute("username");
        if (user == null) {
            user = "test.user";
            _log.warn((Object)("USER IS NULL setting " + user + " and Running OUTSIDE PORTAL"));
            this.withinPortal = false;
        } else {
            this.withinPortal = true;
        }
        System.out.println("SessionID = " + sessionID);
        return SessionManager.getInstance().getASLSession(sessionID, user);
    }

    public UserInfo getUserInfo() {
        if (this.getUserFromSession() != null) {
            return this.getUserFromSession();
        }
        try {
            String username = this.getASLSession().getUsername();
            String email = username + "@isti.cnr.it";
            String fullName = username + " FULL";
            String thumbnailURL = "images/Avatar_default.png";
            if (this.withinPortal) {
                User user = UserLocalServiceUtil.getUserByScreenName((long)OrganizationsUtil.getCompany().getCompanyId(), (String)username);
                thumbnailURL = "/image/user_male_portrait?img_id=" + user.getPortraitId();
                fullName = user.getFirstName() + " " + user.getLastName();
                email = user.getEmailAddress();
                ThemeDisplay themeDisplay = (ThemeDisplay)this.getThreadLocalRequest().getSession().getAttribute("THEME_DISPLAY");
                String accountURL = themeDisplay.getURLMyAccount().toString();
                UserInfo toReturn = new UserInfo(username, fullName, thumbnailURL, user.getEmailAddress(), accountURL, true, false, null);
                this.setUserInSession(toReturn);
                return toReturn;
            }
            _log.info((Object)"Returning test USER");
            return new UserInfo(this.getASLSession().getUsername(), fullName, thumbnailURL, email, "fakeAccountUrl", true, false, null);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new UserInfo();
        }
    }

    private UserInfo getUserFromSession() {
        return (UserInfo)this.getASLSession().getAttribute("USER_INFO_ATTR");
    }

    private void setUserInSession(UserInfo user) {
        this.getASLSession().setAttribute("USER_INFO_ATTR", (Object)user);
    }

    public HashMap<Date, ArrayList<Notification>> getUserNotifications() {
        HashMap<Date, ArrayList<Notification>> toReturn = new HashMap<Date, ArrayList<Notification>>();
        try {
            for (Notification notification : this.store.getAllNotificationByUser(this.getASLSession().getUsername(), 20)) {
                Date dateWithoutTime = this.removeTimePart(notification.getTime());
                if (!toReturn.containsKey(dateWithoutTime)) {
                    ArrayList<Notification> nots = new ArrayList<Notification>();
                    nots.add(notification);
                    toReturn.put(dateWithoutTime, nots);
                    continue;
                }
                toReturn.get(dateWithoutTime).add(notification);
            }
        }
        catch (Exception e) {
            _log.error((Object)"While trying to get User notifications");
            e.printStackTrace();
        }
        return toReturn;
    }

    private Date removeTimePart(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    public boolean setAllUserNotificationsRead() {
        try {
            this.store.setAllNotificationReadByUser(this.getASLSession().getUsername());
        }
        catch (Exception e) {
            _log.error((Object)"While trying to set User notifications Read");
            e.printStackTrace();
        }
        return false;
    }

    public ArrayList<NotificationChannelType> getNotificationChannels() {
        ArrayList<NotificationChannelType> toReturn = new ArrayList<NotificationChannelType>();
        try {
            for (NotificationChannelType channel : this.store.getUserNotificationChannels(this.getASLSession().getUsername())) {
                toReturn.add(channel);
            }
        }
        catch (NotificationChannelTypeNotFoundException e) {
            e.printStackTrace();
        }
        return toReturn;
    }

    public boolean setNotificationChannels(HashMap<NotificationChannelType, Boolean> newSettings) {
        boolean toReturn = false;
        for (NotificationChannelType type : newSettings.keySet()) {
            _log.error((Object)("Trying to set User notification Setting: " + type + " to: " + newSettings.get(type)));
            toReturn = this.store.setUserNotificationChannel(this.getASLSession().getUsername(), type, newSettings.get(type).booleanValue());
        }
        return toReturn;
    }
}

