/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.newsfeed.server;

import com.google.gwt.user.server.rpc.RemoteServiceServlet;
import com.liferay.portal.kernel.bean.BeanLocatorException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.service.UserLocalServiceUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.gcube.applicationsupportlayer.social.ApplicationNotificationsManager;
import org.gcube.applicationsupportlayer.social.NotificationsManager;
import org.gcube.applicationsupportlayer.social.shared.SocialNetworkingSite;
import org.gcube.applicationsupportlayer.social.shared.SocialNetworkingUser;
import org.gcube.common.portal.PortalContext;
import org.gcube.portal.databook.server.DBCassandraAstyanaxImpl;
import org.gcube.portal.databook.server.DatabookStore;
import org.gcube.portal.databook.shared.Comment;
import org.gcube.portal.databook.shared.EnhancedFeed;
import org.gcube.portal.databook.shared.Feed;
import org.gcube.portal.databook.shared.Like;
import org.gcube.portal.databook.shared.RangeFeeds;
import org.gcube.portal.databook.shared.ShowUserStatisticAction;
import org.gcube.portal.databook.shared.UserInfo;
import org.gcube.portal.databook.shared.ex.ColumnNameNotFoundException;
import org.gcube.portal.databook.shared.ex.FeedIDNotFoundException;
import org.gcube.portal.databook.shared.ex.FeedTypeNotFoundException;
import org.gcube.portal.databook.shared.ex.LikeIDNotFoundException;
import org.gcube.portal.databook.shared.ex.PrivacyLevelTypeNotFoundException;
import org.gcube.portal.notifications.bean.GenericItemBean;
import org.gcube.portal.notifications.thread.CommentNotificationsThread;
import org.gcube.portal.notifications.thread.LikeNotificationsThread;
import org.gcube.portal.notifications.thread.MentionNotificationsThread;
import org.gcube.portlets.user.newsfeed.client.NewsService;
import org.gcube.portlets.user.newsfeed.server.CustomConfiguration;
import org.gcube.portlets.user.newsfeed.server.NewsServiceImpl;
import org.gcube.portlets.user.newsfeed.shared.MoreFeedsBean;
import org.gcube.portlets.user.newsfeed.shared.OperationResult;
import org.gcube.portlets.user.newsfeed.shared.UserSettings;
import org.gcube.portlets.widgets.pickitem.shared.ItemBean;
import org.gcube.social_networking.socialutillibrary.Utils;
import org.gcube.socialnetworking.social_data_search_client.ElasticSearchClient;
import org.gcube.socialnetworking.social_data_search_client.ElasticSearchClientImpl;
import org.gcube.vomanagement.usermanagement.UserManager;
import org.gcube.vomanagement.usermanagement.exception.GroupRetrievalFault;
import org.gcube.vomanagement.usermanagement.exception.TeamRetrievalFault;
import org.gcube.vomanagement.usermanagement.exception.UserManagementSystemException;
import org.gcube.vomanagement.usermanagement.exception.UserRetrievalFault;
import org.gcube.vomanagement.usermanagement.exception.VirtualGroupNotExistingException;
import org.gcube.vomanagement.usermanagement.impl.LiferayGroupManager;
import org.gcube.vomanagement.usermanagement.impl.LiferayRoleManager;
import org.gcube.vomanagement.usermanagement.impl.LiferayUserManager;
import org.gcube.vomanagement.usermanagement.model.GCubeGroup;
import org.gcube.vomanagement.usermanagement.model.GCubeTeam;
import org.gcube.vomanagement.usermanagement.model.GCubeUser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NewsServiceImpl
extends RemoteServiceServlet
implements NewsService {
    private static final Logger _log = LoggerFactory.getLogger(NewsServiceImpl.class);
    private static final String VRE_LABEL = "VRE_LABEL";
    private static final String SHOW_TIMELINE_SOURCE = "SHOW_TIMELINE_SOURCE";
    private static final String REFRESH_TIME = "REFRESH_TIME";
    private static final String SESSION_ADMIN_ATTR = "SESSION_ADMIN_ATTR";
    public static final String NF_ORGANIZATIONUSERS_CACHE = "NF_ORGANIZATIONUSERS_CACHE";
    public static final String LAST_RETRIEVED_TIME = "NF_LAST_RETRIEVED_TIME";
    private String APP_ID;
    private DatabookStore store;
    private ElasticSearchClient escl;
    private static final int MAX_FEEDS_NO = 30;

    public void init() {
        this.store = new DBCassandraAstyanaxImpl();
        try {
            this.escl = new ElasticSearchClientImpl(null);
            _log.info("Elasticsearch connection created");
        }
        catch (Exception e) {
            this.escl = null;
            _log.error("Unable to create elasticsearch client connection!!!", (Throwable)e);
        }
        this.APP_ID = this.getClass().getName();
    }

    public void destroy() {
        this.store.closeConnection();
    }

    private boolean isWithinPortal() {
        try {
            UserLocalServiceUtil.getService();
            return true;
        }
        catch (BeanLocatorException ex) {
            _log.trace("Development Mode ON");
            return false;
        }
    }

    public UserSettings getUserSettings() {
        try {
            String profilePageURL;
            PortalContext context = PortalContext.getConfiguration();
            GCubeUser currUser = context.getCurrentUser(this.getThreadLocalRequest());
            String username = currUser.getUsername();
            String email = currUser.getEmail();
            String fullName = currUser.getFullname();
            String thumbnailURL = currUser.getUserAvatarURL();
            String groupName = context.getCurrentGroupName(this.getThreadLocalRequest());
            String accountURL = profilePageURL = "/group" + PortalContext.getConfiguration().getSiteLandingPagePath(this.getThreadLocalRequest()) + "/profile";
            UserInfo userInfo = new UserInfo(username, fullName, thumbnailURL, email, accountURL, true, this.isAdmin(), null);
            CustomConfiguration config = this.getUserConfiguration();
            UserSettings toReturn = new UserSettings(userInfo, config.getRefreshTime(), groupName, config.getVreLabel(), this.isInfrastructureScope(), config.isShowTimelineSource());
            return toReturn;
        }
        catch (Exception e) {
            e.printStackTrace();
            return new UserSettings();
        }
    }

    private boolean isInfrastructureScope() throws UserManagementSystemException, GroupRetrievalFault {
        PortalContext context = PortalContext.getConfiguration();
        String scope = context.getCurrentScope(this.getThreadLocalRequest());
        long groupId = context.getCurrentGroupId(this.getThreadLocalRequest());
        boolean isInfrastructureScope = new LiferayGroupManager().isRootVO(groupId);
        _log.debug("isInfrastructureScope? " + scope + " groupId=" + groupId + " ? i say " + isInfrastructureScope);
        return isInfrastructureScope;
    }

    public ArrayList<EnhancedFeed> getAllUpdateUserFeeds(int feedsNoPerCategory) {
        ArrayList toMerge = new ArrayList();
        HashMap<String, Feed> feedsMap = new HashMap<String, Feed>();
        try {
            GCubeUser currUser = PortalContext.getConfiguration().getCurrentUser(this.getThreadLocalRequest());
            _log.info("****** retrieving posts for user: " + currUser.getUsername());
            if (this.isInfrastructureScope()) {
                _log.debug("****** risInfrastructureScope() = true");
                LiferayGroupManager gm = new LiferayGroupManager();
                for (Object group : gm.listGroupsByUserAndSite(currUser.getUserId(), this.getThreadLocalRequest().getServerName())) {
                    if (!gm.isVRE(group.getGroupId()).booleanValue()) continue;
                    String vreid = gm.getInfrastructureScope(group.getGroupId());
                    _log.debug("Reading feeds for VRE: " + vreid);
                    ArrayList OrganizationFeeds = (ArrayList)this.store.getRecentFeedsByVRE(vreid, feedsNoPerCategory);
                    for (Feed feed : OrganizationFeeds) {
                        feedsMap.put(feed.getKey(), feed);
                    }
                }
                ArrayList portalFeeds = (ArrayList)this.store.getAllPortalPrivacyLevelFeeds();
                for (Feed feed : portalFeeds) {
                    feedsMap.put(feed.getKey(), feed);
                }
            } else {
                PortalContext context = PortalContext.getConfiguration();
                String vreid = context.getCurrentScope(this.getThreadLocalRequest());
                _log.trace("News Feed in VRE, Reading feeds for VRE: " + vreid);
                ArrayList OrganizationFeeds = (ArrayList)this.store.getRecentFeedsByVRE(vreid, 30);
                for (Feed feed : OrganizationFeeds) {
                    feedsMap.put(feed.getKey(), feed);
                }
            }
            for (String key : feedsMap.keySet()) {
                toMerge.add(feedsMap.get(key));
            }
            Collections.sort(toMerge, Collections.reverseOrder());
            ArrayList toReturn = new ArrayList();
            if (toMerge.size() > 30) {
                for (int i = 0; i < 30; ++i) {
                    toReturn.add(toMerge.get(i));
                }
            } else {
                return this.enhanceFeeds(toMerge, 2);
            }
            return this.enhanceFeeds(toReturn, 2);
        }
        catch (PrivacyLevelTypeNotFoundException e) {
            _log.error("Privacy Level not Found " + e.getMessage());
            e.printStackTrace();
        }
        catch (FeedTypeNotFoundException e) {
            _log.error("Feed Type not Found " + e.getMessage());
            e.printStackTrace();
        }
        catch (ColumnNameNotFoundException e) {
            _log.error("Column name not Found " + e.getMessage());
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public ArrayList<EnhancedFeed> getFeedsByHashtag(String hashtag) {
        PortalContext pContext = PortalContext.getConfiguration();
        String userName = pContext.getCurrentUser(this.getThreadLocalRequest()).getUsername();
        String currentScope = pContext.getCurrentScope(this.getThreadLocalRequest());
        if (userName.compareTo("test.user") == 0) {
            _log.debug("Found " + userName + " returning nothing");
            return null;
        }
        try {
            ArrayList toMerge = new ArrayList();
            HashMap<String, Feed> feedsMap = new HashMap<String, Feed>();
            String lowerCaseHashtag = hashtag.toLowerCase();
            ArrayList<String> contexts = new ArrayList<String>();
            if (this.isInfrastructureScope()) {
                LiferayGroupManager gm = new LiferayGroupManager();
                LiferayUserManager um = new LiferayUserManager();
                GCubeUser user = um.getUserByUsername(userName);
                Set vresInPortal = gm.listGroupsByUserAndSite(user.getUserId(), this.getThreadLocalRequest().getServerName());
                _log.debug("Contexts in this site are per user " + vresInPortal);
                for (GCubeGroup gCubeGroup : vresInPortal) {
                    contexts.add(gm.getInfrastructureScope(gCubeGroup.getGroupId()));
                }
            } else {
                contexts.add(currentScope);
            }
            _log.debug("Contexts for hashtags is " + contexts);
            for (String context : contexts) {
                ArrayList feeds = (ArrayList)this.store.getVREFeedsByHashtag(context, lowerCaseHashtag);
                for (Feed feed : feeds) {
                    feedsMap.put(feed.getKey(), feed);
                }
            }
            for (String key : feedsMap.keySet()) {
                toMerge.add(feedsMap.get(key));
            }
            Collections.sort(toMerge, Collections.reverseOrder());
            ArrayList toReturn = new ArrayList();
            if (toMerge.size() > 30) {
                for (int i = 0; i < 30; ++i) {
                    toReturn.add(toMerge.get(i));
                }
            } else {
                return this.enhanceFeeds(toMerge, 2);
            }
            return this.enhanceFeeds(toReturn, 2);
        }
        catch (PrivacyLevelTypeNotFoundException e) {
            _log.error("Privacy Level not Found ", (Throwable)e);
        }
        catch (FeedTypeNotFoundException e) {
            _log.error("Feed Type not Found ", (Throwable)e);
        }
        catch (ColumnNameNotFoundException e) {
            _log.error("Column name not Found ", (Throwable)e);
        }
        catch (Exception e) {
            _log.error("Error while retrieving feeds for hashtag ", (Throwable)e);
        }
        return null;
    }

    public ArrayList<EnhancedFeed> getFeedsByQuery(String query, int from, int quantity) {
        if (this.escl == null) {
            _log.warn("There is no connection to elasticsearch, sorry.");
            return null;
        }
        PortalContext pContext = PortalContext.getConfiguration();
        String userName = pContext.getCurrentUser(this.getThreadLocalRequest()).getUsername();
        String currentScope = pContext.getCurrentScope(this.getThreadLocalRequest());
        try {
            if (userName.compareTo("test.user") == 0) {
                _log.debug("Found " + userName + " returning nothing");
                return null;
            }
            HashSet<String> vres = new HashSet<String>();
            if (this.isInfrastructureScope()) {
                LiferayUserManager um = new LiferayUserManager();
                GCubeUser currUser = um.getUserByUsername(userName);
                LiferayGroupManager gm = new LiferayGroupManager();
                for (GCubeGroup group : gm.listGroupsByUser(currUser.getUserId())) {
                    if (!gm.isVRE(group.getGroupId()).booleanValue()) continue;
                    String vreid = gm.getInfrastructureScope(group.getGroupId());
                    vres.add(vreid);
                }
            } else {
                vres.add(currentScope);
            }
            List enhancedFeeds = this.escl.search(query, vres, from, quantity);
            List likedFeeds = this.store.getAllLikedFeedIdsByUser(userName);
            for (EnhancedFeed enhancedFeed : enhancedFeeds) {
                if (this.isUsers(enhancedFeed.getFeed(), userName)) {
                    enhancedFeed.setUsers(true);
                }
                if (!likedFeeds.contains(enhancedFeed.getFeed().getKey())) continue;
                enhancedFeed.setLiked(true);
            }
            return (ArrayList)enhancedFeeds;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public ArrayList<EnhancedFeed> getOnlyConnectionsUserFeeds() {
        block10: {
            ArrayList toMerge = new ArrayList();
            HashMap<String, Feed> feedsMap = new HashMap<String, Feed>();
            PortalContext pContext = PortalContext.getConfiguration();
            String userName = pContext.getCurrentUser(this.getThreadLocalRequest()).getUsername();
            try {
                ArrayList userFriendsIds = (ArrayList)this.store.getFriends(userName);
                for (String userid : userFriendsIds) {
                    for (Feed feed : this.store.getRecentFeedsByUser(userid, 6)) {
                        feedsMap.put(feed.getKey(), feed);
                    }
                }
                for (String key : feedsMap.keySet()) {
                    toMerge.add(feedsMap.get(key));
                }
                Collections.sort(toMerge, Collections.reverseOrder());
                ArrayList toReturn = new ArrayList();
                if (toMerge.size() > 30) {
                    for (int i = 0; i < 30; ++i) {
                        toReturn.add(toMerge.get(i));
                    }
                    break block10;
                }
                return this.enhanceFeeds(toMerge, 2);
            }
            catch (PrivacyLevelTypeNotFoundException e) {
                _log.error("Privacy Level not Found " + e.getMessage());
                e.printStackTrace();
            }
            catch (FeedTypeNotFoundException e) {
                _log.error("Feed Type not Found " + e.getMessage());
                e.printStackTrace();
            }
            catch (ColumnNameNotFoundException e) {
                _log.error("Column name not Found " + e.getMessage());
                e.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public EnhancedFeed getSingleFeed(String feedKey) {
        Feed feed = null;
        try {
            if (feedKey != null && (feed = this.store.readFeed(feedKey)) != null) {
                ArrayList<Feed> toEnhance = new ArrayList<Feed>();
                toEnhance.add(feed);
                return (EnhancedFeed)this.enhanceFeeds(toEnhance, -1).get(0);
            }
        }
        catch (Exception e) {
            _log.debug("Error while trying to fetch feed with key " + feedKey + " returning nothing");
            return new EnhancedFeed();
        }
        return new EnhancedFeed();
    }

    public MoreFeedsBean getMoreFeeds(int start, int quantity) {
        ArrayList toMerge = new ArrayList();
        HashMap<String, Feed> feedsMap = new HashMap<String, Feed>();
        PortalContext pContext = PortalContext.getConfiguration();
        String vreid = pContext.getCurrentScope(this.getThreadLocalRequest());
        _log.debug("\n\nAsking more feed for Timeline " + vreid + " from " + start + " get other " + quantity);
        RangeFeeds rangeFeeds = null;
        try {
            rangeFeeds = this.store.getRecentFeedsByVREAndRange(vreid, start, quantity);
            ArrayList organizationFeeds = rangeFeeds.getFeeds();
            for (Feed feed : organizationFeeds) {
                feedsMap.put(feed.getKey(), feed);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        for (String key : feedsMap.keySet()) {
            toMerge.add(feedsMap.get(key));
        }
        Collections.sort(toMerge, Collections.reverseOrder());
        ArrayList toReturn = this.enhanceFeeds(toMerge, 2);
        return new MoreFeedsBean(rangeFeeds.getLastReturnedFeedTimelineIndex(), toReturn);
    }

    public ArrayList<EnhancedFeed> getOnlyMyUserFeeds() {
        PortalContext pContext = PortalContext.getConfiguration();
        String userName = pContext.getCurrentUser(this.getThreadLocalRequest()).getUsername();
        _log.trace("getOnly UserFeeds for " + userName);
        ArrayList userFeeds = null;
        try {
            userFeeds = (ArrayList)this.store.getRecentFeedsByUser(userName, 15);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Collections.sort(userFeeds, Collections.reverseOrder());
        return this.enhanceFeeds(userFeeds, 2);
    }

    public ArrayList<EnhancedFeed> getOnlyLikedFeeds() {
        PortalContext pContext = PortalContext.getConfiguration();
        String userName = pContext.getCurrentUser(this.getThreadLocalRequest()).getUsername();
        _log.trace("getLiked Feeds for " + userName);
        ArrayList userFeeds = null;
        try {
            userFeeds = (ArrayList)this.store.getAllLikedFeedsByUser(userName, 25);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Collections.sort(userFeeds, Collections.reverseOrder());
        return this.enhanceFeeds(userFeeds, 2);
    }

    public boolean like(String feedid, String feedText, String feedOwnerId) {
        boolean likeCommitResult = false;
        UserInfo user = this.getUserSettings().getUserInfo();
        String username = user.getUsername();
        if (username.compareTo("test.user") == 0) {
            return false;
        }
        Like toLike = new Like(UUID.randomUUID().toString(), user.getUsername(), new Date(), feedid, user.getFullName(), user.getAvatarId());
        try {
            likeCommitResult = this.store.like(toLike);
        }
        catch (FeedIDNotFoundException e) {
            _log.error("Feed not Found for this like " + e.getMessage());
            e.printStackTrace();
            return false;
        }
        if (likeCommitResult) {
            PortalContext pContext = PortalContext.getConfiguration();
            String currScope = pContext.getCurrentScope(this.getThreadLocalRequest());
            if (!user.getUsername().equals(feedOwnerId)) {
                ApplicationNotificationsManager nm = new ApplicationNotificationsManager(new SocialNetworkingSite(this.getThreadLocalRequest()), currScope, new SocialNetworkingUser(username, user.getEmailaddress(), user.getFullName(), user.getAvatarId()), this.APP_ID);
                boolean nResult = nm.notifyLikedFeed(feedOwnerId, feedid, Utils.escapeHtml((String)feedText));
                _log.trace("Like Notification added? " + nResult);
            }
        }
        return likeCommitResult;
    }

    public boolean unlike(String feedid, String feedText, String feedOwnerId) {
        UserInfo user = this.getUserSettings().getUserInfo();
        try {
            for (Like like : this.store.getAllLikesByFeed(feedid)) {
                if (like.getUserid().compareTo(user.getUsername()) != 0) continue;
                _log.trace("Trying unlike of " + feedText + " for " + user.getFullName());
                this.store.unlike(user.getUsername(), like.getKey(), feedid);
                return true;
            }
        }
        catch (ColumnNameNotFoundException | FeedIDNotFoundException | FeedTypeNotFoundException | LikeIDNotFoundException | PrivacyLevelTypeNotFoundException e) {
            _log.error("Either Feed or Like not Found " + e.getMessage());
            e.printStackTrace();
            return false;
        }
        return false;
    }

    public OperationResult comment(String feedid, String commentText, HashSet<String> mentionedUserFullNames, String feedOwnerId, boolean isAppFeed) {
        boolean commentCommitResult = false;
        _log.trace("Trying to add this comment " + commentText);
        UserInfo user = this.getUserSettings().getUserInfo();
        if (user.getUsername().compareTo("test.user") == 0) {
            return new OperationResult(Boolean.valueOf(false), "Session Expired", null);
        }
        String escapedCommentText = Utils.escapeHtmlAndTransformUrl((String)commentText);
        ArrayList<String> mentionedUserFullNamesList = new ArrayList<String>();
        mentionedUserFullNamesList.addAll(mentionedUserFullNames);
        ArrayList mentionedUsers = null;
        if (mentionedUserFullNames != null && !mentionedUserFullNames.isEmpty()) {
            mentionedUsers = this.getSelectedUserIds(mentionedUserFullNamesList);
            escapedCommentText = Utils.convertMentionPeopleAnchorHTML((String)escapedCommentText, (ArrayList)mentionedUsers, (HttpServletRequest)this.getThreadLocalRequest());
        }
        Comment comment = new Comment(UUID.randomUUID().toString(), user.getUsername(), new Date(), feedid, escapedCommentText, user.getFullName(), user.getAvatarId());
        try {
            if (this.store.addComment(comment)) {
                commentCommitResult = true;
            }
        }
        catch (FeedIDNotFoundException e) {
            _log.error("Related post not found for this comment " + e.getMessage());
            e.printStackTrace();
            return new OperationResult(Boolean.valueOf(false), "Related post not found for this comment", (Serializable)comment);
        }
        if (commentCommitResult && this.isWithinPortal()) {
            PortalContext pContext = PortalContext.getConfiguration();
            String currScope = pContext.getCurrentScope(this.getThreadLocalRequest());
            ApplicationNotificationsManager nm = new ApplicationNotificationsManager(new SocialNetworkingSite(this.getThreadLocalRequest()), currScope, new SocialNetworkingUser(user.getUsername(), user.getEmailaddress(), user.getFullName(), user.getAvatarId()), this.APP_ID);
            if (!user.getUsername().equals(feedOwnerId) && !isAppFeed) {
                boolean result = nm.notifyOwnCommentReply(feedOwnerId, feedid, escapedCommentText, comment.getKey());
                _log.trace("Comment Notification to post owner added? " + result);
            }
            ArrayList favorites = this.getAllLikesByFeed(feedid);
            Thread likesThread = new Thread((Runnable)new LikeNotificationsThread(commentText, (NotificationsManager)nm, favorites, feedOwnerId, comment.getKey()));
            likesThread.start();
            Thread commentsNotificationthread = new Thread((Runnable)new CommentNotificationsThread(this.store, (UserManager)new LiferayUserManager(), user.getUsername(), comment.getFeedid(), escapedCommentText, (NotificationsManager)nm, feedOwnerId, comment.getKey(), favorites));
            commentsNotificationthread.start();
            if (mentionedUsers != null && mentionedUsers.size() > 0) {
                ArrayList<GenericItemBean> toPass = new ArrayList<GenericItemBean>();
                HashMap<String, ItemBean> uniqueUsersToNotify = new HashMap<String, ItemBean>();
                LiferayUserManager um = new LiferayUserManager();
                for (ItemBean bean : mentionedUsers) {
                    if (bean.isItemGroup()) {
                        try {
                            List teamUsers = um.listUsersByTeam(Long.parseLong(bean.getId()));
                            for (GCubeUser userTeam : teamUsers) {
                                if (uniqueUsersToNotify.containsKey(userTeam.getUsername())) continue;
                                uniqueUsersToNotify.put(userTeam.getUsername(), new ItemBean(userTeam.getUserId() + "", userTeam.getUsername(), userTeam.getFullname(), userTeam.getUserAvatarURL()));
                            }
                            continue;
                        }
                        catch (NumberFormatException | TeamRetrievalFault | UserManagementSystemException | UserRetrievalFault e) {
                            _log.error("Unable to retrieve team information", e);
                            continue;
                        }
                    }
                    if (uniqueUsersToNotify.containsKey(bean.getName())) continue;
                    uniqueUsersToNotify.put(bean.getName(), bean);
                }
                for (Map.Entry userEntry : uniqueUsersToNotify.entrySet()) {
                    ItemBean userBean = (ItemBean)userEntry.getValue();
                    toPass.add(new GenericItemBean(userBean.getId(), userBean.getName(), userBean.getAlternativeName(), userBean.getThumbnailURL()));
                }
                Thread thread = new Thread((Runnable)new MentionNotificationsThread(comment.getFeedid(), commentText, (NotificationsManager)nm, null, toPass));
                thread.start();
            }
        }
        return new OperationResult(Boolean.valueOf(true), "OK", (Serializable)comment);
    }

    public OperationResult editComment(Comment toEdit) {
        UserInfo user = this.getUserSettings().getUserInfo();
        if (user.getUsername().compareTo("test.user") == 0) {
            return new OperationResult(Boolean.valueOf(false), "Session Expired", null);
        }
        String escapedCommentText = Utils.escapeHtmlAndTransformUrl((String)toEdit.getText());
        Comment edited = new Comment(toEdit.getKey(), toEdit.getUserid(), toEdit.getTime(), toEdit.getFeedid(), escapedCommentText, user.getFullName(), user.getAvatarId(), true, new Date());
        try {
            this.store.editComment(edited);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new OperationResult(Boolean.valueOf(false), "Exception on the server: " + e.getMessage(), null);
        }
        return new OperationResult(Boolean.valueOf(true), "OK", (Serializable)edited);
    }

    private ArrayList<EnhancedFeed> enhanceFeeds(ArrayList<Feed> toEnhance, int commentsNumberPerFeed) {
        ArrayList<EnhancedFeed> toReturn = new ArrayList<EnhancedFeed>();
        PortalContext pContext = PortalContext.getConfiguration();
        String userName = pContext.getCurrentUser(this.getThreadLocalRequest()).getUsername();
        String LINK_TO_REPLACE = "data-e-infrastructure-gateway";
        String siteLandinPagePath = PortalContext.getConfiguration().getSiteLandingPagePath(this.getThreadLocalRequest());
        String tokenTosubstitute = siteLandinPagePath.replace("/group/", "");
        ArrayList likedFeeds = (ArrayList)this.store.getAllLikedFeedIdsByUser(userName);
        boolean skip = false;
        for (Feed feed : toEnhance) {
            String currPostText = feed.getDescription().replace("data-e-infrastructure-gateway", tokenTosubstitute);
            feed.setDescription(currPostText);
            boolean isMultiFileUpload = feed.isMultiFileUpload();
            ArrayList attachments = new ArrayList();
            if (isMultiFileUpload) {
                try {
                    attachments = (ArrayList)this.store.getAttachmentsByFeedId(feed.getKey());
                }
                catch (FeedIDNotFoundException e) {
                    _log.error("It looks like sth wrong with this feedid having attachments, could not find feedId = " + feed.getKey() + "\n" + e.getMessage());
                }
            }
            skip = false;
            if (!feed.isApplicationFeed()) {
                String thumb = this.getUserImagePortraitUrlLocal(feed.getEntityId());
                if (thumb == null) {
                    _log.warn(feed.getEntityId() + " is not avaialble on this portal, skipping this feed: " + feed.getKey());
                    skip = true;
                } else {
                    feed.setThumbnailURL(thumb);
                }
            }
            boolean liked = likedFeeds.contains(feed.getKey());
            int commentsNo = 0;
            try {
                commentsNo = Integer.parseInt(feed.getCommentsNo());
            }
            catch (NumberFormatException e) {
                commentsNo = 0;
                _log.error("NumberFormatException while reading comments number " + e.getMessage());
            }
            if (skip) continue;
            if (commentsNo == 0) {
                EnhancedFeed toAdd = null;
                toAdd = feed.isApplicationFeed() ? new EnhancedFeed(feed, liked, this.checkisAdminUser()) : new EnhancedFeed(feed, liked, this.isUsers(feed, userName));
                toAdd.setAttachments(attachments);
                toReturn.add(toAdd);
                continue;
            }
            ArrayList comments = this.getAllCommentsByFeed(feed.getKey());
            Collections.sort(comments);
            int currCommentsNumber = comments.size();
            if (currCommentsNumber < commentsNumberPerFeed || commentsNumberPerFeed == -1) {
                EnhancedFeed toAdd = new EnhancedFeed(feed, liked, this.isUsers(feed, userName), comments, attachments);
                toReturn.add(toAdd);
                continue;
            }
            ArrayList comments2Attach = new ArrayList();
            for (int i = currCommentsNumber - commentsNumberPerFeed; i < currCommentsNumber; ++i) {
                comments2Attach.add(comments.get(i));
            }
            EnhancedFeed toAdd = new EnhancedFeed(feed, liked, this.isUsers(feed, userName), comments2Attach, attachments);
            toReturn.add(toAdd);
        }
        _log.trace("ENHANCED FEEDS TOTAL= " + toReturn.size() + " for user: " + userName);
        return toReturn;
    }

    private String getUserImagePortraitUrlLocal(String screenName) {
        if (!this.isWithinPortal()) {
            return "";
        }
        String thumbnailURL = "";
        try {
            thumbnailURL = new LiferayUserManager().getUserByUsername(screenName).getUserAvatarURL();
        }
        catch (UserManagementSystemException | UserRetrievalFault e) {
            e.printStackTrace();
        }
        return thumbnailURL;
    }

    public ArrayList<Like> getAllLikesByFeed(String feedid) {
        ArrayList toReturn = (ArrayList)this.store.getAllLikesByFeed(feedid);
        _log.trace("Asking likes for " + feedid);
        Iterator iterator = toReturn.iterator();
        while (iterator.hasNext()) {
            Like like;
            String thumb = this.getUserImagePortraitUrlLocal((like = (Like)iterator.next()).getUserid());
            like.setThumbnailURL(thumb == null ? "" : thumb);
        }
        return toReturn;
    }

    public ArrayList<Comment> getAllCommentsByFeed(String feedid) {
        _log.trace("Asking comments for " + feedid);
        ArrayList toReturn = (ArrayList)this.store.getAllCommentByFeed(feedid);
        Iterator iterator = toReturn.iterator();
        while (iterator.hasNext()) {
            Comment comment;
            String thumb = this.getUserImagePortraitUrlLocal((comment = (Comment)iterator.next()).getUserid());
            comment.setThumbnailURL(thumb == null ? "" : thumb);
        }
        Collections.sort(toReturn);
        return toReturn;
    }

    public boolean deleteComment(String commentid, String feedid) {
        _log.trace("Attempting to delete comment " + commentid);
        try {
            return this.store.deleteComment(commentid, feedid);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean deleteFeed(String feedid) {
        _log.trace("Called delete feed " + feedid);
        try {
            Feed toDelete = this.store.readFeed(feedid);
            List hashtags = Utils.getHashTags((String)toDelete.getDescription());
            if (hashtags != null && !hashtags.isEmpty()) {
                _log.trace("The feed has hashtags, attempting to delete them ... " + hashtags.toString());
                boolean deletedHashtag = this.store.deleteHashTags(feedid, toDelete.getVreid(), hashtags);
                _log.trace("deletedHashtag? " + deletedHashtag);
            }
            _log.trace("Attempting to delete feed " + feedid);
            return this.store.deleteFeed(feedid);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public ArrayList<ItemBean> getOrganizationUsers() {
        ArrayList<ItemBean> portalBeans = new ArrayList<ItemBean>();
        PortalContext pContext = PortalContext.getConfiguration();
        GCubeUser currentUser = pContext.getCurrentUser(this.getThreadLocalRequest());
        String userName = currentUser.getUsername();
        LiferayUserManager um = new LiferayUserManager();
        LiferayGroupManager gm = new LiferayGroupManager();
        long currentGroupId = pContext.getCurrentGroupId(this.getThreadLocalRequest());
        HashSet users = new HashSet();
        List teams = new ArrayList();
        try {
            if (gm.isRootVO(currentGroupId).booleanValue()) {
                Set userGroups = gm.listGroupsByUserAndSite(currentUser.getUserId(), this.getThreadLocalRequest().getServerName());
                for (GCubeGroup userGroup : userGroups) {
                    if (!gm.isVRE(userGroup.getGroupId()).booleanValue()) continue;
                    users.addAll(um.listUsersByGroup(userGroup.getGroupId()));
                    _log.debug("getOrganizationUsers added users of group " + userGroup.getGroupId());
                }
            } else {
                users.addAll(um.listUsersByGroup(currentGroupId));
                teams = new LiferayRoleManager().listTeamsByGroup(currentGroupId);
            }
        }
        catch (GroupRetrievalFault | UserManagementSystemException | UserRetrievalFault | VirtualGroupNotExistingException e) {
            e.printStackTrace();
        }
        for (GCubeUser user : users) {
            if (user.getUsername().compareTo("test.user") == 0 || user.getUsername().compareTo(userName) == 0) continue;
            portalBeans.add(new ItemBean(user.getUserId() + "", user.getUsername(), user.getFullname(), user.getUserAvatarURL()));
        }
        for (GCubeTeam gCubeTeam : teams) {
            portalBeans.add(new ItemBean(gCubeTeam.getTeamId() + "", gCubeTeam.getTeamName()));
        }
        _log.trace("Returning " + portalBeans.size() + " users for scope groupid =  " + currentGroupId);
        return portalBeans;
    }

    private boolean isUsers(Feed tocheck, String username) {
        return tocheck.getEntityId().equals(username);
    }

    private boolean checkisAdminUser() {
        if (this.getThreadLocalRequest().getSession().getAttribute(SESSION_ADMIN_ATTR) == null) {
            boolean isAdmin = false;
            try {
                isAdmin = this.isAdmin();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.getThreadLocalRequest().getSession().setAttribute(SESSION_ADMIN_ATTR, (Object)isAdmin);
            return isAdmin;
        }
        return (Boolean)this.getThreadLocalRequest().getSession().getAttribute(SESSION_ADMIN_ATTR);
    }

    public ArrayList<ItemBean> getSelectedUserIds(ArrayList<String> fullNames) {
        if (fullNames == null) {
            return new ArrayList<ItemBean>();
        }
        PortalContext pContext = PortalContext.getConfiguration();
        String userName = pContext.getCurrentUser(this.getThreadLocalRequest()).getUsername();
        ArrayList allUsers = Utils.getDisplayableItemBeans((String)("/" + PortalContext.getConfiguration().getInfrastructureName()), (String)userName, (boolean)this.isWithinPortal());
        ArrayList<ItemBean> toReturn = new ArrayList<ItemBean>();
        block0: for (String fullName : fullNames) {
            for (ItemBean puser : allUsers) {
                if (puser.getAlternativeName().compareTo(fullName) != 0) continue;
                toReturn.add(puser);
                continue block0;
            }
        }
        return toReturn;
    }

    private boolean isAdmin() throws PortalException, SystemException {
        if (!this.isWithinPortal()) {
            return false;
        }
        try {
            PortalContext pContext = PortalContext.getConfiguration();
            GCubeUser curUser = pContext.getCurrentUser(this.getThreadLocalRequest());
            return new LiferayRoleManager().isAdmin(curUser.getUserId());
        }
        catch (Exception e) {
            _log.error("Could not check if the user is an Administrator, returning false");
            return false;
        }
    }

    private CustomConfiguration getUserConfiguration() {
        CustomConfiguration toReturn = null;
        _log.info("Trying to read custom config fr News Feed (REFRESH_TIME, VRE Label and show timeline source)");
        Properties props = new Properties();
        int minutes = 0;
        String label = "";
        boolean showTimelineSource = true;
        String propertyfile = "";
        try {
            ServletContext servletContext = this.getServletContext();
            String contextPath = servletContext.getRealPath(File.separator);
            propertyfile = contextPath + "conf" + File.separator + "settings.properties";
            File propsFile = new File(propertyfile);
            FileInputStream fis = new FileInputStream(propsFile);
            props.load(fis);
            try {
                minutes = Integer.parseInt(props.getProperty(REFRESH_TIME));
                minutes = minutes * 60 * 1000;
            }
            catch (ClassCastException ex) {
                minutes = 300000;
                _log.error("REFRESH_TIME must be a number (in minutes) returning 5 minutes");
            }
            label = props.getProperty(VRE_LABEL);
            try {
                showTimelineSource = Boolean.parseBoolean(props.getProperty(SHOW_TIMELINE_SOURCE));
            }
            catch (ClassCastException ex) {
                showTimelineSource = true;
                _log.error(showTimelineSource + " must be true or false, returning true");
            }
        }
        catch (IOException e) {
            minutes = 300000;
            _log.error("settings.properties file not found under " + propertyfile + ", returning 5 minutes");
        }
        toReturn = new CustomConfiguration(minutes, label, showTimelineSource);
        _log.debug("Read Configuration from property file: " + toReturn);
        return toReturn;
    }

    public ArrayList<EnhancedFeed> getFeedsRelatedToUserStatistics(ShowUserStatisticAction action, int from, int quantity) {
        PortalContext pContext = PortalContext.getConfiguration();
        String userid = pContext.getCurrentUser(this.getThreadLocalRequest()).getUsername();
        String scope = pContext.getCurrentScope(this.getThreadLocalRequest());
        if (userid == "test.user") {
            return null;
        }
        try {
            Calendar oneYearAgo = Calendar.getInstance();
            oneYearAgo.set(1, oneYearAgo.get(1) - 1);
            ArrayList feeds = null;
            switch (1.$SwitchMap$org$gcube$portal$databook$shared$ShowUserStatisticAction[action.ordinal()]) {
                case 1: {
                    feeds = (ArrayList)this.store.getRecentFeedsByUserAndDate(userid, oneYearAgo.getTimeInMillis());
                    break;
                }
                case 2: {
                    feeds = (ArrayList)this.store.getRecentLikedFeedsByUserAndDate(userid, oneYearAgo.getTimeInMillis());
                    break;
                }
                case 3: {
                    feeds = (ArrayList)this.store.getRecentCommentedFeedsByUserAndDate(userid, oneYearAgo.getTimeInMillis());
                    break;
                }
                case 4: {
                    feeds = (ArrayList)this.store.getRecentFeedsByUserAndDate(userid, oneYearAgo.getTimeInMillis());
                    Iterator feedsIteratorLikes = feeds.iterator();
                    while (feedsIteratorLikes.hasNext()) {
                        Feed feed = (Feed)feedsIteratorLikes.next();
                        if (Integer.parseInt(feed.getLikesNo()) != 0) continue;
                        feedsIteratorLikes.remove();
                    }
                    break;
                }
                case 5: {
                    feeds = (ArrayList)this.store.getRecentFeedsByUserAndDate(userid, oneYearAgo.getTimeInMillis());
                    Iterator feedsIteratorComments = feeds.iterator();
                    while (feedsIteratorComments.hasNext()) {
                        Feed feed = (Feed)feedsIteratorComments.next();
                        if (Integer.parseInt(feed.getCommentsNo()) != 0) continue;
                        feedsIteratorComments.remove();
                    }
                    break;
                }
                default: {
                    return new ArrayList<EnhancedFeed>();
                }
            }
            ArrayList<String> contexts = new ArrayList<String>();
            if (this.isInfrastructureScope()) {
                LiferayGroupManager groupManager = new LiferayGroupManager();
                long userIdLong = new LiferayUserManager().getUserId(userid);
                Set vresInPortal = groupManager.listGroupsByUserAndSite(userIdLong, this.getThreadLocalRequest().getServerName());
                _log.debug("Contexts in this site are " + vresInPortal);
                for (GCubeGroup gCubeGroup : vresInPortal) {
                    contexts.add(groupManager.getInfrastructureScope(gCubeGroup.getGroupId()));
                }
            } else {
                contexts.add(scope);
            }
            Iterator iteratorScope = feeds.iterator();
            while (iteratorScope.hasNext()) {
                Feed feed = (Feed)iteratorScope.next();
                if (contexts.contains(feed.getVreid())) continue;
                iteratorScope.remove();
            }
            Collections.sort(feeds, Collections.reverseOrder());
            int upperIndex = from + quantity >= feeds.size() ? feeds.size() : from + quantity;
            feeds = new ArrayList(feeds.subList(from, upperIndex));
            return this.enhanceFeeds(feeds, -1);
        }
        catch (Exception e) {
            _log.error("Error while retrieving feeds for user " + userid + " and action " + action.toString(), (Throwable)e);
            return null;
        }
    }
}

