/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.newsfeed.server;

import com.google.gwt.user.server.rpc.RemoteServiceServlet;
import com.liferay.portal.kernel.bean.BeanLocatorException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.service.UserLocalServiceUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.gcube.application.framework.core.session.ASLSession;
import org.gcube.application.framework.core.session.SessionManager;
import org.gcube.applicationsupportlayer.social.ApplicationNotificationsManager;
import org.gcube.applicationsupportlayer.social.NotificationsManager;
import org.gcube.applicationsupportlayer.social.shared.SocialNetworkingSite;
import org.gcube.applicationsupportlayer.social.shared.SocialNetworkingUser;
import org.gcube.common.portal.PortalContext;
import org.gcube.common.scope.impl.ScopeBean;
import org.gcube.portal.databook.server.DBCassandraAstyanaxImpl;
import org.gcube.portal.databook.server.DatabookStore;
import org.gcube.portal.databook.shared.Comment;
import org.gcube.portal.databook.shared.EnhancedFeed;
import org.gcube.portal.databook.shared.Feed;
import org.gcube.portal.databook.shared.Like;
import org.gcube.portal.databook.shared.RangeFeeds;
import org.gcube.portal.databook.shared.UserInfo;
import org.gcube.portal.databook.shared.ex.ColumnNameNotFoundException;
import org.gcube.portal.databook.shared.ex.FeedIDNotFoundException;
import org.gcube.portal.databook.shared.ex.FeedTypeNotFoundException;
import org.gcube.portal.databook.shared.ex.LikeIDNotFoundException;
import org.gcube.portal.databook.shared.ex.PrivacyLevelTypeNotFoundException;
import org.gcube.portal.notifications.bean.GenericItemBean;
import org.gcube.portal.notifications.thread.CommentNotificationsThread;
import org.gcube.portal.notifications.thread.LikeNotificationsThread;
import org.gcube.portal.notifications.thread.MentionNotificationsThread;
import org.gcube.portlets.user.newsfeed.client.NewsService;
import org.gcube.portlets.user.newsfeed.server.CustomConfiguration;
import org.gcube.portlets.user.newsfeed.shared.MoreFeedsBean;
import org.gcube.portlets.user.newsfeed.shared.OperationResult;
import org.gcube.portlets.user.newsfeed.shared.UserSettings;
import org.gcube.portlets.widgets.pickitem.shared.ItemBean;
import org.gcube.social_networking.socialutillibrary.Utils;
import org.gcube.socialnetworking.social_data_search_client.ElasticSearchClientImpl;
import org.gcube.vomanagement.usermanagement.exception.TeamRetrievalFault;
import org.gcube.vomanagement.usermanagement.exception.UserManagementSystemException;
import org.gcube.vomanagement.usermanagement.exception.UserRetrievalFault;
import org.gcube.vomanagement.usermanagement.impl.LiferayGroupManager;
import org.gcube.vomanagement.usermanagement.impl.LiferayRoleManager;
import org.gcube.vomanagement.usermanagement.impl.LiferayUserManager;
import org.gcube.vomanagement.usermanagement.model.GCubeGroup;
import org.gcube.vomanagement.usermanagement.model.GCubeUser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NewsServiceImpl
extends RemoteServiceServlet
implements NewsService {
    private static final Logger _log = LoggerFactory.getLogger(NewsServiceImpl.class);
    private static final String VRE_LABEL = "VRE_LABEL";
    private static final String SHOW_TIMELINE_SOURCE = "SHOW_TIMELINE_SOURCE";
    private static final String REFRESH_TIME = "REFRESH_TIME";
    private static final String SESSION_ADMIN_ATTR = "SESSION_ADMIN_ATTR";
    private static final String USER_SETTINGS_ATTR = "USER_SETTINGS_ATTR";
    public static final String TEST_SCOPE = "/gcube/devsec/devVRE";
    private String APP_ID;
    private DatabookStore store;
    private ElasticSearchClientImpl el;
    private static final int MAX_FEEDS_NO = 45;

    public void init() {
        this.store = new DBCassandraAstyanaxImpl();
        try {
            this.el = new ElasticSearchClientImpl(null);
            _log.info("Elasticsearch connection created");
        }
        catch (Exception e) {
            this.el = null;
            _log.error("Unable to create elasticsearch client connection!!!", (Throwable)e);
        }
        this.APP_ID = this.getClass().getName();
    }

    public void destroy() {
        this.store.closeConnection();
    }

    private ASLSession getASLSession() {
        String sessionID = this.getThreadLocalRequest().getSession().getId();
        String user = (String)this.getThreadLocalRequest().getSession().getAttribute("username");
        if (user == null) {
            _log.warn("USER IS NULL setting testing user and Running OUTSIDE PORTAL");
            user = this.getDevelopmentUser();
            SessionManager.getInstance().getASLSession(sessionID, user).setScope(TEST_SCOPE);
        }
        return SessionManager.getInstance().getASLSession(sessionID, user);
    }

    public String getDevelopmentUser() {
        String user = "test.user";
        return user;
    }

    private boolean isWithinPortal() {
        try {
            UserLocalServiceUtil.getService();
            return true;
        }
        catch (BeanLocatorException ex) {
            _log.trace("Development Mode ON");
            return false;
        }
    }

    public UserSettings getUserSettings() {
        if (this.getUserSettingsFromSession() != null) {
            return this.getUserSettingsFromSession();
        }
        try {
            ASLSession session = this.getASLSession();
            String username = session.getUsername();
            String email = String.valueOf(username) + "@isti.cnr.it";
            String fullName = String.valueOf(username) + " FULL";
            String thumbnailURL = "images/Avatar_default.png";
            boolean isDevelopment = false;
            try {
                UserLocalServiceUtil.getService();
            }
            catch (BeanLocatorException ex) {
                isDevelopment = true;
            }
            if (username.compareTo("test.user") != 0 && !isDevelopment) {
                String profilePageURL;
                LiferayUserManager um = new LiferayUserManager();
                GCubeUser user = um.getUserByUsername(username);
                thumbnailURL = user.getUserAvatarURL();
                fullName = user.getFullname();
                email = user.getEmail();
                String accountURL = profilePageURL = "/group" + PortalContext.getConfiguration().getSiteLandingPagePath(this.getThreadLocalRequest()) + "/profile";
                try {
                    accountURL = "";
                }
                catch (NullPointerException e) {
                    e.printStackTrace();
                }
                UserInfo userInfo = new UserInfo(username, fullName, thumbnailURL, user.getEmail(), accountURL, true, this.isAdmin(), null);
                CustomConfiguration config = this.getUserConfiguration();
                UserSettings toReturn = new UserSettings(userInfo, config.getRefreshTime(), session.getScopeName(), config.getVreLabel(), this.isInfrastructureScope(), config.isShowTimelineSource());
                this.setUserSettingsInSession(toReturn);
                return toReturn;
            }
            _log.info("Returning test USER");
            CustomConfiguration config = this.getUserConfiguration();
            UserInfo user = new UserInfo(session.getUsername(), fullName, thumbnailURL, email, "fakeAccountUrl", true, false, null);
            return new UserSettings(user, config.getRefreshTime(), session.getScopeName(), config.getVreLabel(), this.isInfrastructureScope(), config.isShowTimelineSource());
        }
        catch (Exception e) {
            e.printStackTrace();
            return new UserSettings();
        }
    }

    private boolean isInfrastructureScope() {
        boolean toReturn = false;
        try {
            ScopeBean scope = new ScopeBean(this.getASLSession().getScope());
            toReturn = scope.is(ScopeBean.Type.INFRASTRUCTURE);
            return toReturn;
        }
        catch (NullPointerException e) {
            _log.error("NullPointerException in isInfrastructureScope returning false");
            return false;
        }
    }

    public ArrayList<EnhancedFeed> getAllUpdateUserFeeds(int feedsNoPerCategory) {
        HashMap<String, Feed> feedsMap;
        ArrayList<Feed> toMerge;
        String userName;
        block17: {
            userName = this.getASLSession().getUsername();
            toMerge = new ArrayList<Feed>();
            feedsMap = new HashMap<String, Feed>();
            if (!this.isWithinPortal()) {
                return this.getEclipseResult(userName, feedsNoPerCategory, false);
            }
            if (userName.compareTo("test.user") != 0) break block17;
            _log.debug("Found " + userName + " returning nothing");
            return null;
        }
        try {
            _log.info("****** retrieving posts for user: " + userName);
            LiferayUserManager um = new LiferayUserManager();
            GCubeUser currUser = um.getUserByUsername(userName);
            if (this.isInfrastructureScope()) {
                _log.info("****** risInfrastructureScope() = true");
                LiferayGroupManager gm = new LiferayGroupManager();
                for (GCubeGroup group : gm.listGroupsByUser(currUser.getUserId())) {
                    if (!gm.isVRE(group.getGroupId()).booleanValue()) continue;
                    String vreid = gm.getInfrastructureScope(group.getGroupId());
                    _log.info("Reading feeds for VRE: " + vreid);
                    ArrayList OrganizationFeeds = (ArrayList)this.store.getRecentFeedsByVRE(vreid, feedsNoPerCategory);
                    for (Feed feed : OrganizationFeeds) {
                        feedsMap.put(feed.getKey(), feed);
                    }
                }
                ArrayList portalFeeds = (ArrayList)this.store.getAllPortalPrivacyLevelFeeds();
                for (Feed feed : portalFeeds) {
                    feedsMap.put(feed.getKey(), feed);
                }
            } else {
                String vreid = this.getASLSession().getScopeName();
                _log.trace("News Feed in VRE, Reading feeds for VRE: " + vreid);
                ArrayList OrganizationFeeds = (ArrayList)this.store.getRecentFeedsByVRE(vreid, 30);
                for (Feed feed : OrganizationFeeds) {
                    feedsMap.put(feed.getKey(), feed);
                }
            }
            for (String key : feedsMap.keySet()) {
                toMerge.add((Feed)feedsMap.get(key));
            }
            Collections.sort(toMerge, Collections.reverseOrder());
            ArrayList<Feed> toReturn = new ArrayList<Feed>();
            if (toMerge.size() > 45) {
                int i = 0;
                while (i < 45) {
                    toReturn.add((Feed)toMerge.get(i));
                    ++i;
                }
            } else {
                return this.enhanceFeeds(toMerge, 2);
            }
            return this.enhanceFeeds(toReturn, 2);
        }
        catch (PrivacyLevelTypeNotFoundException e) {
            _log.error("Privacy Level not Found " + e.getMessage());
            e.printStackTrace();
        }
        catch (FeedTypeNotFoundException e) {
            _log.error("Feed Type not Found " + e.getMessage());
            e.printStackTrace();
        }
        catch (ColumnNameNotFoundException e) {
            _log.error("Column name not Found " + e.getMessage());
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public ArrayList<EnhancedFeed> getFeedsByHashtag(String hashtag) {
        HashMap<String, Feed> feedsMap;
        ArrayList<Feed> toMerge;
        String userName;
        ASLSession session;
        block15: {
            session = this.getASLSession();
            userName = session.getUsername();
            toMerge = new ArrayList<Feed>();
            feedsMap = new HashMap<String, Feed>();
            if (userName.compareTo("test.user") != 0) break block15;
            _log.debug("Found " + userName + " returning nothing");
            return null;
        }
        try {
            String lowerCaseHashtag = hashtag.toLowerCase();
            if (this.isInfrastructureScope()) {
                LiferayUserManager um = new LiferayUserManager();
                GCubeUser currUser = um.getUserByUsername(userName);
                LiferayGroupManager gm = new LiferayGroupManager();
                for (GCubeGroup group : gm.listGroupsByUser(currUser.getUserId())) {
                    if (!gm.isVRE(group.getGroupId()).booleanValue()) continue;
                    String vreid = gm.getInfrastructureScope(group.getGroupId());
                    ArrayList feeds = (ArrayList)this.store.getVREFeedsByHashtag(vreid, lowerCaseHashtag);
                    for (Feed feed : feeds) {
                        feedsMap.put(feed.getKey(), feed);
                    }
                }
            } else {
                String vreid = session.getScopeName();
                ArrayList feeds = (ArrayList)this.store.getVREFeedsByHashtag(vreid, lowerCaseHashtag);
                Iterator iterator = feeds.iterator();
                while (iterator.hasNext()) {
                    Feed feed = (Feed)iterator.next();
                    feedsMap.put(feed.getKey(), feed);
                }
            }
            for (String key : feedsMap.keySet()) {
                toMerge.add((Feed)feedsMap.get(key));
            }
            Collections.sort(toMerge, Collections.reverseOrder());
            ArrayList<Feed> toReturn = new ArrayList<Feed>();
            if (toMerge.size() > 45) {
                int i = 0;
                while (i < 45) {
                    toReturn.add((Feed)toMerge.get(i));
                    ++i;
                }
            } else {
                return this.enhanceFeeds(toMerge, 2);
            }
            return this.enhanceFeeds(toReturn, 2);
        }
        catch (PrivacyLevelTypeNotFoundException e) {
            _log.error("Privacy Level not Found " + e.getMessage());
            e.printStackTrace();
        }
        catch (FeedTypeNotFoundException e) {
            _log.error("Feed Type not Found " + e.getMessage());
            e.printStackTrace();
        }
        catch (ColumnNameNotFoundException e) {
            _log.error("Column name not Found " + e.getMessage());
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public ArrayList<EnhancedFeed> getFeedsByQuery(String query, int from, int quantity) {
        String userName;
        ASLSession session;
        block9: {
            if (this.el == null) {
                _log.debug("There is no connection to elasticsearch, sorry.");
                return null;
            }
            session = this.getASLSession();
            userName = session.getUsername();
            if (userName.compareTo("test.user") != 0) break block9;
            _log.debug("Found " + userName + " returning nothing");
            return null;
        }
        try {
            HashSet<String> vres = new HashSet<String>();
            if (this.isInfrastructureScope()) {
                LiferayUserManager um = new LiferayUserManager();
                GCubeUser currUser = um.getUserByUsername(userName);
                LiferayGroupManager gm = new LiferayGroupManager();
                for (GCubeGroup group : gm.listGroupsByUser(currUser.getUserId())) {
                    if (!gm.isVRE(group.getGroupId()).booleanValue()) continue;
                    String vreid = gm.getInfrastructureScope(group.getGroupId());
                    vres.add(vreid);
                }
            } else {
                vres.add(session.getScopeName());
            }
            List enhancedFeeds = this.el.searchInEnhancedFeeds(query, vres, from, quantity);
            List likedFeeds = this.store.getAllLikedFeedIdsByUser(userName);
            for (EnhancedFeed enhancedFeed : enhancedFeeds) {
                if (this.isUsers(enhancedFeed.getFeed(), userName)) {
                    enhancedFeed.setUsers(true);
                }
                if (!likedFeeds.contains(enhancedFeed.getFeed().getKey())) continue;
                enhancedFeed.setLiked(true);
            }
            return (ArrayList)enhancedFeeds;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public ArrayList<EnhancedFeed> getOnlyConnectionsUserFeeds() {
        block11: {
            ArrayList<Feed> toMerge = new ArrayList<Feed>();
            HashMap<String, Feed> feedsMap = new HashMap<String, Feed>();
            String userName = this.getASLSession().getUsername();
            try {
                if (!this.isWithinPortal()) {
                    return this.getEclipseResult(userName, 10, true);
                }
                ArrayList userFriendsIds = (ArrayList)this.store.getFriends(userName);
                for (String userid : userFriendsIds) {
                    for (Feed feed : this.store.getRecentFeedsByUser(userid, 10)) {
                        feedsMap.put(feed.getKey(), feed);
                    }
                }
                for (String key : feedsMap.keySet()) {
                    toMerge.add((Feed)feedsMap.get(key));
                }
                Collections.sort(toMerge, Collections.reverseOrder());
                ArrayList<Feed> toReturn = new ArrayList<Feed>();
                if (toMerge.size() > 45) {
                    int i = 0;
                    while (i < 45) {
                        toReturn.add((Feed)toMerge.get(i));
                        ++i;
                    }
                    break block11;
                }
                return this.enhanceFeeds(toMerge, 2);
            }
            catch (PrivacyLevelTypeNotFoundException e) {
                _log.error("Privacy Level not Found " + e.getMessage());
                e.printStackTrace();
            }
            catch (FeedTypeNotFoundException e) {
                _log.error("Feed Type not Found " + e.getMessage());
                e.printStackTrace();
            }
            catch (ColumnNameNotFoundException e) {
                _log.error("Column name not Found " + e.getMessage());
                e.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public EnhancedFeed getSingleFeed(String feedKey) {
        Feed feed = null;
        try {
            if (feedKey != null && (feed = this.store.readFeed(feedKey)) != null) {
                ArrayList<Feed> toEnhance = new ArrayList<Feed>();
                toEnhance.add(feed);
                return (EnhancedFeed)this.enhanceFeeds(toEnhance, -1).get(0);
            }
        }
        catch (Exception e) {
            _log.debug("Error while trying to fetch feed with key " + feedKey + " returning nothing");
            return new EnhancedFeed();
        }
        return new EnhancedFeed();
    }

    public MoreFeedsBean getMoreFeeds(int start, int quantity) {
        ArrayList<Feed> toMerge = new ArrayList<Feed>();
        HashMap<String, Feed> feedsMap = new HashMap<String, Feed>();
        String vreid = this.getASLSession().getScope();
        _log.debug("\n\nAsking more feed for Timeline " + vreid + " from " + start + " get other " + quantity);
        RangeFeeds rangeFeeds = null;
        try {
            rangeFeeds = this.store.getRecentFeedsByVREAndRange(vreid, start, quantity);
            ArrayList organizationFeeds = rangeFeeds.getFeeds();
            for (Feed feed : organizationFeeds) {
                feedsMap.put(feed.getKey(), feed);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        for (String key : feedsMap.keySet()) {
            toMerge.add((Feed)feedsMap.get(key));
        }
        Collections.sort(toMerge, Collections.reverseOrder());
        ArrayList toReturn = this.enhanceFeeds(toMerge, 2);
        return new MoreFeedsBean(rangeFeeds.getLastReturnedFeedTimelineIndex(), toReturn);
    }

    private ArrayList<EnhancedFeed> getEclipseResult(String userName, int feedsNoPerCategory, boolean onlyConnections) throws PrivacyLevelTypeNotFoundException, FeedTypeNotFoundException, ColumnNameNotFoundException, FeedIDNotFoundException {
        ArrayList<Feed> toMerge = new ArrayList<Feed>();
        HashMap<String, Feed> feedsMap = new HashMap<String, Feed>();
        ArrayList OrganizationFeeds = (ArrayList)this.store.getRecentFeedsByVRE(TEST_SCOPE, feedsNoPerCategory * 3);
        for (Feed feed : OrganizationFeeds) {
            feedsMap.put(feed.getKey(), feed);
            _log.trace("Reading desc: " + feed.getDescription());
        }
        for (String key : feedsMap.keySet()) {
            toMerge.add((Feed)feedsMap.get(key));
        }
        for (Feed feed : toMerge) {
            feed.setThumbnailURL("http://127.0.0.1:8888/images/Avatar_default.png");
        }
        Collections.sort(toMerge, Collections.reverseOrder());
        return this.enhanceFeeds(toMerge, 2);
    }

    public ArrayList<EnhancedFeed> getOnlyMyUserFeeds() {
        String userName = this.getASLSession().getUsername();
        _log.trace("getOnly UserFeeds for " + userName);
        ArrayList userFeeds = null;
        try {
            userFeeds = (ArrayList)this.store.getRecentFeedsByUser(userName, 15);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Collections.sort(userFeeds, Collections.reverseOrder());
        return this.enhanceFeeds(userFeeds, 2);
    }

    public ArrayList<EnhancedFeed> getOnlyLikedFeeds() {
        String userName = this.getASLSession().getUsername();
        _log.trace("getLiked Feeds for " + userName);
        ArrayList userFeeds = null;
        try {
            userFeeds = (ArrayList)this.store.getAllLikedFeedsByUser(userName, 25);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Collections.sort(userFeeds, Collections.reverseOrder());
        return this.enhanceFeeds(userFeeds, 2);
    }

    public boolean like(String feedid, String feedText, String feedOwnerId) {
        boolean likeCommitResult = false;
        UserInfo user = this.getUserSettings().getUserInfo();
        String username = user.getUsername();
        if (username.compareTo("test.user") == 0) {
            return false;
        }
        Like toLike = new Like(UUID.randomUUID().toString(), user.getUsername(), new Date(), feedid, user.getFullName(), user.getAvatarId());
        try {
            likeCommitResult = this.store.like(toLike);
        }
        catch (FeedIDNotFoundException e) {
            _log.error("Feed not Found for this like " + e.getMessage());
            e.printStackTrace();
            return false;
        }
        if (likeCommitResult && !user.getUsername().equals(feedOwnerId)) {
            ApplicationNotificationsManager nm = new ApplicationNotificationsManager(new SocialNetworkingSite(this.getThreadLocalRequest()), this.getASLSession().getScopeName(), new SocialNetworkingUser(username, user.getEmailaddress(), user.getFullName(), user.getAvatarId()), this.APP_ID);
            boolean nResult = nm.notifyLikedFeed(feedOwnerId, feedid, Utils.escapeHtml((String)feedText));
            _log.trace("Like Notification added? " + nResult);
        }
        return likeCommitResult;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean unlike(String feedid, String feedText, String feedOwnerId) {
        UserInfo user = this.getUserSettings().getUserInfo();
        try {
            Like like;
            Iterator iterator = this.store.getAllLikesByFeed(feedid).iterator();
            do {
                if (iterator.hasNext()) continue;
                return false;
            } while ((like = (Like)iterator.next()).getUserid().compareTo(user.getUsername()) != 0);
            _log.trace("Trying unlike of " + feedText + " for " + user.getFullName());
            this.store.unlike(user.getUsername(), like.getKey(), feedid);
            return true;
        }
        catch (ColumnNameNotFoundException | FeedIDNotFoundException | FeedTypeNotFoundException | LikeIDNotFoundException | PrivacyLevelTypeNotFoundException e) {
            _log.error("Either Feed or Like not Found " + e.getMessage());
            e.printStackTrace();
            return false;
        }
    }

    public OperationResult comment(String feedid, String commentText, HashSet<String> mentionedUserFullNames, String feedOwnerId, boolean isAppFeed) {
        boolean commentCommitResult = false;
        _log.trace("Trying to add this comment " + commentText);
        UserInfo user = this.getUserSettings().getUserInfo();
        if (user.getUsername().compareTo("test.user") == 0) {
            return new OperationResult(Boolean.valueOf(false), "Session Expired", null);
        }
        String escapedCommentText = Utils.escapeHtmlAndTransformUrl((String)commentText);
        ArrayList<String> mentionedUserFullNamesList = new ArrayList<String>();
        mentionedUserFullNamesList.addAll(mentionedUserFullNames);
        ArrayList mentionedUsers = null;
        if (mentionedUserFullNames != null && !mentionedUserFullNames.isEmpty()) {
            mentionedUsers = this.getSelectedUserIds(mentionedUserFullNamesList);
            escapedCommentText = Utils.convertMentionPeopleAnchorHTML((String)escapedCommentText, (ArrayList)mentionedUsers, (HttpServletRequest)this.getThreadLocalRequest());
        }
        Comment comment = new Comment(UUID.randomUUID().toString(), user.getUsername(), new Date(), feedid, escapedCommentText, user.getFullName(), user.getAvatarId());
        try {
            if (this.store.addComment(comment)) {
                commentCommitResult = true;
            }
        }
        catch (FeedIDNotFoundException e) {
            _log.error("Related post not found for this comment " + e.getMessage());
            e.printStackTrace();
            return new OperationResult(Boolean.valueOf(false), "Related post not found for this comment", (Serializable)comment);
        }
        if (commentCommitResult && this.isWithinPortal()) {
            ApplicationNotificationsManager nm = new ApplicationNotificationsManager(new SocialNetworkingSite(this.getThreadLocalRequest()), this.getASLSession().getScopeName(), new SocialNetworkingUser(user.getUsername(), user.getEmailaddress(), user.getFullName(), user.getAvatarId()), this.APP_ID);
            if (!user.getUsername().equals(feedOwnerId) && !isAppFeed) {
                boolean result = nm.notifyOwnCommentReply(feedOwnerId, feedid, escapedCommentText, comment.getKey());
                _log.trace("Comment Notification to post owner added? " + result);
            }
            ArrayList favorites = this.getAllLikesByFeed(feedid);
            Thread likesThread = new Thread((Runnable)new LikeNotificationsThread(commentText, (NotificationsManager)nm, favorites, feedOwnerId, comment.getKey()));
            likesThread.start();
            Thread commentsNotificationthread = new Thread((Runnable)new CommentNotificationsThread(this.store, user.getUsername(), comment.getFeedid(), escapedCommentText, (NotificationsManager)nm, feedOwnerId, comment.getKey(), favorites));
            commentsNotificationthread.start();
            if (mentionedUsers != null && mentionedUsers.size() > 0) {
                ArrayList<GenericItemBean> toPass = new ArrayList<GenericItemBean>();
                HashMap<String, ItemBean> uniqueUsersToNotify = new HashMap<String, ItemBean>();
                LiferayUserManager um = new LiferayUserManager();
                for (ItemBean bean : mentionedUsers) {
                    if (bean.isItemGroup()) {
                        try {
                            List teamUsers = um.listUsersByTeam(Long.parseLong(bean.getId()));
                            for (GCubeUser userTeam : teamUsers) {
                                if (uniqueUsersToNotify.containsKey(userTeam.getUsername())) continue;
                                uniqueUsersToNotify.put(userTeam.getUsername(), new ItemBean(String.valueOf(userTeam.getUserId()), userTeam.getUsername(), userTeam.getFullname(), userTeam.getUserAvatarURL()));
                            }
                        }
                        catch (NumberFormatException | TeamRetrievalFault | UserManagementSystemException | UserRetrievalFault e) {
                            _log.error("Unable to retrieve team information", e);
                        }
                        continue;
                    }
                    if (uniqueUsersToNotify.containsKey(bean.getName())) continue;
                    uniqueUsersToNotify.put(bean.getName(), bean);
                }
                for (Map.Entry userEntry : uniqueUsersToNotify.entrySet()) {
                    ItemBean userBean = (ItemBean)userEntry.getValue();
                    toPass.add(new GenericItemBean(userBean.getId(), userBean.getName(), userBean.getAlternativeName(), userBean.getThumbnailURL()));
                }
                Thread thread = new Thread((Runnable)new MentionNotificationsThread(comment.getFeedid(), commentText, (NotificationsManager)nm, null, toPass));
                thread.start();
            }
        }
        return new OperationResult(Boolean.valueOf(true), "OK", (Serializable)comment);
    }

    public OperationResult editComment(Comment toEdit) {
        UserInfo user = this.getUserSettings().getUserInfo();
        if (user.getUsername().compareTo("test.user") == 0) {
            return new OperationResult(Boolean.valueOf(false), "Session Expired", null);
        }
        String escapedCommentText = Utils.escapeHtmlAndTransformUrl((String)toEdit.getText());
        Comment edited = new Comment(toEdit.getKey(), toEdit.getUserid(), toEdit.getTime(), toEdit.getFeedid(), escapedCommentText, user.getFullName(), user.getAvatarId(), true, new Date());
        try {
            this.store.editComment(edited);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new OperationResult(Boolean.valueOf(false), "Exception on the server: " + e.getMessage(), null);
        }
        return new OperationResult(Boolean.valueOf(true), "OK", (Serializable)edited);
    }

    private ArrayList<EnhancedFeed> enhanceFeeds(ArrayList<Feed> toEnhance, int commentsNumberPerFeed) {
        ArrayList<EnhancedFeed> toReturn = new ArrayList<EnhancedFeed>();
        ASLSession session = this.getASLSession();
        String username = session.getUsername();
        ArrayList likedFeeds = (ArrayList)this.store.getAllLikedFeedIdsByUser(this.getASLSession().getUsername());
        boolean skip = false;
        for (Feed feed : toEnhance) {
            boolean isMultiFileUpload = feed.isMultiFileUpload();
            ArrayList attachments = new ArrayList();
            if (isMultiFileUpload) {
                try {
                    attachments = (ArrayList)this.store.getAttachmentsByFeedId(feed.getKey());
                }
                catch (FeedIDNotFoundException e) {
                    _log.error("It looks like sth wrong with this feedid having attachments, could not find feedId = " + feed.getKey() + "\n" + e.getMessage());
                }
            }
            skip = false;
            if (!feed.isApplicationFeed()) {
                String thumb = this.getUserImagePortraitUrlLocal(feed.getEntityId());
                if (thumb == null) {
                    _log.warn(String.valueOf(feed.getEntityId()) + " is not avaialble on this portal, skipping this feed: " + feed.getKey());
                    skip = true;
                } else {
                    feed.setThumbnailURL(thumb);
                }
            }
            boolean liked = likedFeeds.contains(feed.getKey());
            int commentsNo = 0;
            try {
                commentsNo = Integer.parseInt(feed.getCommentsNo());
            }
            catch (NumberFormatException e) {
                commentsNo = 0;
                _log.error("NumberFormatException while reading comments number " + e.getMessage());
            }
            if (skip) continue;
            if (commentsNo == 0) {
                EnhancedFeed toAdd = null;
                toAdd = feed.isApplicationFeed() ? new EnhancedFeed(feed, liked, this.checkisAdminUser()) : new EnhancedFeed(feed, liked, this.isUsers(feed, username));
                toAdd.setAttachments(attachments);
                toReturn.add(toAdd);
                continue;
            }
            ArrayList comments = this.getAllCommentsByFeed(feed.getKey());
            Collections.sort(comments);
            int currCommentsNumber = comments.size();
            if (currCommentsNumber < commentsNumberPerFeed || commentsNumberPerFeed == -1) {
                EnhancedFeed toAdd = new EnhancedFeed(feed, liked, this.isUsers(feed, username), comments, attachments);
                toReturn.add(toAdd);
                continue;
            }
            ArrayList<Comment> comments2Attach = new ArrayList<Comment>();
            int i = currCommentsNumber - commentsNumberPerFeed;
            while (i < currCommentsNumber) {
                comments2Attach.add((Comment)comments.get(i));
                ++i;
            }
            EnhancedFeed toAdd = new EnhancedFeed(feed, liked, this.isUsers(feed, username), comments2Attach, attachments);
            toReturn.add(toAdd);
        }
        _log.trace("ENHANCED FEEDS TOTAL= " + toReturn.size() + " for user: " + username);
        return toReturn;
    }

    private String getUserImagePortraitUrlLocal(String screenName) {
        if (!this.isWithinPortal()) {
            return "";
        }
        String thumbnailURL = "";
        try {
            thumbnailURL = new LiferayUserManager().getUserByUsername(screenName).getUserAvatarURL();
        }
        catch (UserManagementSystemException | UserRetrievalFault e) {
            e.printStackTrace();
        }
        return thumbnailURL;
    }

    public ArrayList<Like> getAllLikesByFeed(String feedid) {
        ArrayList toReturn = (ArrayList)this.store.getAllLikesByFeed(feedid);
        _log.trace("Asking likes for " + feedid);
        Iterator iterator = toReturn.iterator();
        while (iterator.hasNext()) {
            Like like;
            String thumb = this.getUserImagePortraitUrlLocal((like = (Like)iterator.next()).getUserid());
            like.setThumbnailURL(thumb == null ? "" : thumb);
        }
        return toReturn;
    }

    public ArrayList<Comment> getAllCommentsByFeed(String feedid) {
        _log.trace("Asking comments for " + feedid);
        ArrayList toReturn = (ArrayList)this.store.getAllCommentByFeed(feedid);
        Iterator iterator = toReturn.iterator();
        while (iterator.hasNext()) {
            Comment comment;
            String thumb = this.getUserImagePortraitUrlLocal((comment = (Comment)iterator.next()).getUserid());
            comment.setThumbnailURL(thumb == null ? "" : thumb);
        }
        Collections.sort(toReturn);
        return toReturn;
    }

    public boolean deleteComment(String commentid, String feedid) {
        _log.trace("Attempting to delete comment " + commentid);
        try {
            return this.store.deleteComment(commentid, feedid);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean deleteFeed(String feedid) {
        _log.trace("Called delete feed " + feedid);
        try {
            Feed toDelete = this.store.readFeed(feedid);
            List hashtags = Utils.getHashTags((String)toDelete.getDescription());
            if (hashtags != null && !hashtags.isEmpty()) {
                _log.trace("The feed has hashtags, attempting to delete them ... " + hashtags.toString());
                boolean deletedHashtag = this.store.deleteHashTags(feedid, toDelete.getVreid(), hashtags);
                _log.trace("deletedHashtag? " + deletedHashtag);
            }
            _log.trace("Attempting to delete feed " + feedid);
            return this.store.deleteFeed(feedid);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public ArrayList<ItemBean> getOrganizationUsers(String currentScope) {
        ArrayList toReturn = Utils.getDisplayableItemBeans((String)currentScope, (String)this.getASLSession().getUsername(), (boolean)this.isWithinPortal());
        _log.trace("Returning " + toReturn.size() + " users for scope " + currentScope);
        return toReturn;
    }

    private UserSettings getUserSettingsFromSession() {
        try {
            return (UserSettings)this.getASLSession().getAttribute(USER_SETTINGS_ATTR);
        }
        catch (ClassCastException e) {
            return null;
        }
    }

    private void setUserSettingsInSession(UserSettings user) {
        this.getASLSession().setAttribute(USER_SETTINGS_ATTR, (Object)user);
    }

    private boolean isUsers(Feed tocheck, String username) {
        return tocheck.getEntityId().equals(username);
    }

    private boolean checkisAdminUser() {
        if (this.getASLSession().getAttribute(SESSION_ADMIN_ATTR) == null) {
            boolean isAdmin = false;
            try {
                isAdmin = this.isAdmin();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.getASLSession().setAttribute(SESSION_ADMIN_ATTR, (Object)isAdmin);
            return isAdmin;
        }
        return (Boolean)this.getASLSession().getAttribute(SESSION_ADMIN_ATTR);
    }

    public ArrayList<ItemBean> getSelectedUserIds(ArrayList<String> fullNames) {
        if (fullNames == null) {
            return new ArrayList<ItemBean>();
        }
        ArrayList allUsers = Utils.getDisplayableItemBeans((String)("/" + PortalContext.getConfiguration().getInfrastructureName()), (String)this.getASLSession().getUsername(), (boolean)this.isWithinPortal());
        ArrayList<ItemBean> toReturn = new ArrayList<ItemBean>();
        block0: for (String fullName : fullNames) {
            for (ItemBean puser : allUsers) {
                if (puser.getAlternativeName().compareTo(fullName) != 0) continue;
                toReturn.add(puser);
                continue block0;
            }
        }
        return toReturn;
    }

    private boolean isAdmin() throws PortalException, SystemException {
        if (!this.isWithinPortal()) {
            return false;
        }
        try {
            GCubeUser curUser = new LiferayUserManager().getUserByUsername(this.getASLSession().getUsername());
            return new LiferayRoleManager().isAdmin(curUser.getUserId());
        }
        catch (Exception e) {
            _log.error("Could not check if the user is an Administrator, returning false");
            return false;
        }
    }

    private CustomConfiguration getUserConfiguration() {
        CustomConfiguration toReturn = null;
        _log.info("Trying to read custom config fr News Feed (REFRESH_TIME, VRE Label and show timeline source)");
        Properties props = new Properties();
        int minutes = 0;
        String label = "";
        boolean showTimelineSource = true;
        String propertyfile = "";
        try {
            ServletContext servletContext = this.getServletContext();
            String contextPath = servletContext.getRealPath(File.separator);
            propertyfile = String.valueOf(contextPath) + "conf" + File.separator + "settings.properties";
            File propsFile = new File(propertyfile);
            FileInputStream fis = new FileInputStream(propsFile);
            props.load(fis);
            try {
                minutes = Integer.parseInt(props.getProperty(REFRESH_TIME));
                minutes = minutes * 60 * 1000;
            }
            catch (ClassCastException ex) {
                minutes = 300000;
                _log.error("REFRESH_TIME must be a number (in minutes) returning 5 minutes");
            }
            label = props.getProperty(VRE_LABEL);
            try {
                showTimelineSource = Boolean.parseBoolean(props.getProperty(SHOW_TIMELINE_SOURCE));
            }
            catch (ClassCastException ex) {
                showTimelineSource = true;
                _log.error(String.valueOf(showTimelineSource) + " must be true or false, returning true");
            }
        }
        catch (IOException e) {
            minutes = 300000;
            _log.error("settings.properties file not found under " + propertyfile + ", returning 5 minutes");
        }
        toReturn = new CustomConfiguration(minutes, label, showTimelineSource);
        _log.debug("Read Configuration from property file: " + toReturn);
        return toReturn;
    }
}

