/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.newsfeed.server;

import java.util.ArrayList;
import org.gcube.applicationsupportlayer.social.NotificationsManager;
import org.gcube.portal.databook.shared.Like;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LikeNotificationsThread
implements Runnable {
    private static final Logger _log = LoggerFactory.getLogger(LikeNotificationsThread.class);
    private String commentText;
    private NotificationsManager nm;
    private ArrayList<Like> likes;
    private String feedOwnerId;

    public LikeNotificationsThread(String commentText, NotificationsManager nm, ArrayList<Like> likes, String feedOwnerId) {
        this.feedOwnerId = feedOwnerId;
        this.commentText = commentText;
        this.nm = nm;
        this.likes = likes;
    }

    @Override
    public void run() {
        for (Like fav : this.likes) {
            if (fav.getUserid().compareTo(this.feedOwnerId) == 0) continue;
            boolean result = this.nm.notifyCommentOnFavorite(fav.getUserid(), fav.getFeedid(), this.commentText);
            _log.trace("Sending Notification for favorited post comment added to: " + fav.getFullName() + " result?" + result);
        }
    }
}

