package org.gcube.portlets.user.newsfeed.client.ui;



import com.google.gwt.core.client.GWT;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Widget;

public class LinkPreviewer extends Composite {
	private static LinkPreviewUiBinder uiBinder = GWT
			.create(LinkPreviewUiBinder.class);

	interface LinkPreviewUiBinder extends UiBinder<Widget, LinkPreviewer> {
	}
	
	public LinkPreviewer(String title, String titleDesc, String host, String linkThumbUrl, String url) {
		initWidget(uiBinder.createAndBindUi(this));
		if (linkThumbUrl == null || linkThumbUrl.equals("null"))
			image.removeFromParent();
		else {
			image.setUrl(linkThumbUrl);
			image.setWidth("80px");
		}
		titleArea.setHTML("<a class=\"link\" target=\"_blank\" href=\"" + url + "\">"+title+"</a> <span style=\"color: #333;\"> - " + host+ "</span>");
		urlText.setHTML((url.length() > 70) ? url.substring(0, 70)+"..." : url);
		String desc = titleDesc;
		descText.setHTML((desc.length() > 256) ? desc.substring(0, 256)+"..." : desc);		
		
	}
	@UiField
	HTML titleArea;
	@UiField
	HTML urlText;
	@UiField
	HTML descText;	
	@UiField
	Image image;	
}
