package org.gcube.portlets.user.newsfeed.client.templates;

import org.gcube.portal.databook.shared.Comment;
import org.gcube.portal.databook.shared.UserInfo;
import org.gcube.portlets.user.newsfeed.client.event.AddCommentEvent;
import org.gcube.portlets.user.newsfeed.client.event.EditCommentEvent;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.KeyPressEvent;
import com.google.gwt.event.shared.HandlerManager;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HTMLPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.TextArea;
import com.google.gwt.user.client.ui.Widget;

public class AddCommentTemplate extends Composite{

	private static CommentTemplateUiBinder uiBinder = GWT
			.create(CommentTemplateUiBinder.class);

	private final static String COMMENT_TEXT = "Add a comment ...";
	private final static String ERROR_UPDATE_TEXT = "Looks like empty to me!";
	public static final String avatar_default = GWT.getModuleBaseURL() + "../images/Avatar_default.png";
	private TweetTemplate owner;
	private HandlerManager eventBus;
	private boolean isEditing = false;
	private HTMLPanel commentPanel;
	private Comment toEdit;

	interface CommentTemplateUiBinder extends UiBinder<Widget, AddCommentTemplate> {
	}
	/**
	 * called on add comment
	 * @param caller
	 * @param myUserInfo
	 * @param eventBus
	 */
	public AddCommentTemplate(TweetTemplate caller, UserInfo myUserInfo, HandlerManager eventBus) {
		initWidget(uiBinder.createAndBindUi(this));
		this.eventBus = eventBus;
		owner = caller;
		avatarImage.setPixelSize(30, 30);
		avatarImage.setUrl(myUserInfo.getAvatarId());	
		commentTextArea.setPixelSize(450, 26);
		commentTextArea.setText(COMMENT_TEXT);
	}
	/**
	 * called on edit comment
	 * @param caller
	 * @param editText
	 */
	public AddCommentTemplate(TweetTemplate caller, Comment toEdit, HTMLPanel commentPanel) {
		initWidget(uiBinder.createAndBindUi(this));
		this.eventBus = caller.getEventBus();
		this.commentPanel = commentPanel;
		isEditing = true;
		this.toEdit = toEdit;
		owner = caller;
		avatarImage.setPixelSize(30, 30);
		avatarImage.setUrl(caller.getMyUserInfo().getAvatarId());	
		commentTextArea.setPixelSize(450, 26);
		commentTextArea.setText(new HTML(toEdit.getText()).getText());
		mainPanel.removeStyleName("comment-hidden");
		mainPanel.setStyleName("single-comment");
		commentTextArea.addStyleName("dark-color");
	}

	@UiField HTMLPanel mainPanel;
	@UiField Image avatarImage;
	@UiField TextArea commentTextArea;
	@UiField Button submitButton;
	@UiField Button cancelButton;

	public void setFocus() {
		commentTextArea.setFocus(true);
	}

	/**
	 * paste event overridden
	 */
	public void onBrowserEvent(Event event) {
		super.onBrowserEvent(event);
		switch (event.getTypeInt()) {
		case Event.ONPASTE: 
			if (commentTextArea.getText().equals(COMMENT_TEXT) || commentTextArea.getText().equals(ERROR_UPDATE_TEXT) ) {
				commentTextArea.setText("");
				commentTextArea.addStyleName("dark-color");
				commentTextArea.removeStyleName("error");
			}
		}
	}

	@UiHandler("submitButton")
	void onSubmitClick(ClickEvent e) {
		String userComment = commentTextArea.getText().trim();
		if (! checkTextLength(userComment)) {
			Window.alert("We found a single word containing more than 50 chars and it's not a link, is it meaningful?");
			return;
		}		
		if (userComment.equals(COMMENT_TEXT) || userComment.equals(ERROR_UPDATE_TEXT) || userComment.equals("")) {
			commentTextArea.addStyleName("error");
			commentTextArea.setText(ERROR_UPDATE_TEXT);
			return;
		}
		if (isEditing) {
			toEdit.setText(escapeHtml(commentTextArea.getText()));
			eventBus.fireEvent(new EditCommentEvent(owner, toEdit));
		}
		else
			eventBus.fireEvent(new AddCommentEvent(owner, escapeHtml(commentTextArea.getText())));
		this.getWidget().setVisible(false);
		owner.setCommentingDisabled(false);
	}

	/**
	 * called when pasting. it tries to avoid pasting long non spaced strings
	 * @param linkToCheck
	 */
	private boolean checkTextLength(String textToCheck) {

		String [] parts = textToCheck.split("\\s");
		// check the length of tokens   
		for( String item : parts ) {
			if (! item.startsWith("http")) { //url are accepted as they can be trunked
				if (item.length() > 50) {
					return false;
				}
			}
		}
		return true;
	}

	@UiHandler("cancelButton")
	void onCancelClick(ClickEvent e) {
		this.getWidget().setVisible(false);
		owner.setCommentingDisabled(false);
		if (isEditing) {
			commentPanel.clear();
			SingleComment sc = new SingleComment(toEdit, owner, true);
			commentPanel.add(sc);
		}
	}


	@UiHandler("commentTextArea")
	void onCommentClick(ClickEvent e) {
		if (commentTextArea.getText().equals(COMMENT_TEXT) || commentTextArea.getText().equals(ERROR_UPDATE_TEXT) ) {
			commentTextArea.setText("");
			commentTextArea.addStyleName("dark-color");
			commentTextArea.removeStyleName("error");
		}
	}

	@UiHandler("commentTextArea")
	void onCommentKeyPress(KeyPressEvent e) {
		if (commentTextArea.getText().equals(COMMENT_TEXT) || commentTextArea.getText().equals(ERROR_UPDATE_TEXT) ) {
			commentTextArea.setText("");
			commentTextArea.addStyleName("dark-color");
			commentTextArea.removeStyleName("error");
		}
	}
	/**
	 * Escape an html string. Escaping data received from the client helps to
	 * prevent cross-site script vulnerabilities.
	 * 
	 * @param html the html string to escape
	 * @return the escaped string
	 */
	private String escapeHtml(String html) {
		if (html == null) {
			return null;
		}
		return html.replaceAll("&", "&amp;").replaceAll("<", "&lt;")
				.replaceAll(">", "&gt;");
	}
}
