/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.newsfeed.client.templates;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.MouseOutEvent;
import com.google.gwt.event.dom.client.MouseOverEvent;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HTMLPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Widget;
import org.gcube.portal.databook.client.util.Encoder;
import org.gcube.portal.databook.shared.Comment;
import org.gcube.portlets.user.newsfeed.client.event.DeleteCommentEvent;
import org.gcube.portlets.user.newsfeed.client.templates.AddCommentTemplate;
import org.gcube.portlets.user.newsfeed.client.templates.SingleComment;
import org.gcube.portlets.user.newsfeed.client.templates.TweetTemplate;

public class SingleComment
extends Composite {
    private static SingleCommentUiBinder uiBinder = (SingleCommentUiBinder)GWT.create(SingleCommentUiBinder.class);
    private static final int MAX_SHOWTEXT_LENGTH = 256;
    private boolean isUsers = false;
    private TweetTemplate owner;
    private String myCommentid;
    private Comment myComment;
    @UiField
    HTMLPanel mainPanel;
    @UiField
    Image avatarImage;
    @UiField
    HTML commentText;
    @UiField
    HTML timeArea;
    @UiField
    HTML closeImage;
    @UiField
    HTML editImage;
    @UiField
    HTML seeMore;

    public SingleComment(Comment toShow, TweetTemplate owner, boolean isUsers) {
        this.initWidget((Widget)uiBinder.createAndBindUi((Object)this));
        this.owner = owner;
        this.isUsers = isUsers;
        this.myComment = toShow;
        this.myCommentid = toShow.getKey();
        this.avatarImage.setPixelSize(30, 30);
        this.avatarImage.setUrl(toShow.getThumbnailURL());
        String commentToShow = toShow.getText();
        if (commentToShow.length() > 256) {
            commentToShow = commentToShow.substring(0, 256) + "...";
            this.seeMore.setHTML("<a class=\"seemore\"> See More </a>");
        }
        this.commentText.setHTML("<a class=\"link\" href=\"/group/data-e-infrastructure-gateway/profile?" + Encoder.encode((String)"userIdentificationParameter") + "=" + Encoder.encode((String)toShow.getUserid()) + "\">" + toShow.getFullName() + "</a> " + commentToShow);
        this.timeArea.setHTML(DateTimeFormat.getFormat((String)"MMMM dd, h:mm a").format(toShow.getTime()));
        if (isUsers) {
            this.closeImage.setStyleName("closeImage");
            this.closeImage.setTitle("Delete");
            this.editImage.setStyleName("editImage");
            this.editImage.setTitle("Edit");
        }
    }

    @UiHandler(value={"seeMore"})
    void onSeeMoreClick(ClickEvent e) {
        this.commentText.setHTML("<a class=\"link\" href=\"/group/data-e-infrastructure-gateway/profile?" + Encoder.encode((String)"userIdentificationParameter") + "=" + Encoder.encode((String)this.myComment.getUserid()) + "\">" + this.myComment.getFullName() + "</a> " + this.myComment.getText());
        this.seeMore.setHTML("");
    }

    @UiHandler(value={"closeImage"})
    void onDeleteCommentClick(ClickEvent e) {
        if (this.isUsers) {
            this.owner.getEventBus().fireEvent((GwtEvent)new DeleteCommentEvent(this.owner, this.myCommentid));
        }
    }

    @UiHandler(value={"editImage"})
    void onEditCommentClick(ClickEvent e) {
        if (this.isUsers) {
            AddCommentTemplate addComm = new AddCommentTemplate(this.owner, this.myComment, this.mainPanel);
            this.mainPanel.getElement().setInnerHTML("");
            this.mainPanel.add((Widget)addComm);
        }
    }

    @UiHandler(value={"commentText"})
    public void onHover(MouseOverEvent event) {
        if (this.isUsers) {
            this.closeImage.addStyleName("uiCloseButton");
            this.editImage.addStyleName("uiEditButton");
        }
    }

    @UiHandler(value={"commentText"})
    public void onHover(MouseOutEvent event) {
        if (this.isUsers) {
            this.closeImage.removeStyleName("uiCloseButton");
            this.editImage.removeStyleName("uiEditButton");
        }
    }
}

