package org.gcube.portlets.user.newsfeed.client.panels.dialog;


import java.util.ArrayList;

import org.gcube.portal.databook.shared.Like;
import org.gcube.portlets.user.gcubewidgets.client.popup.GCubeDialog;
import org.gcube.portlets.user.newsfeed.client.panels.NewsFeedPanel;
import org.gcube.portlets.user.newsfeed.client.templates.LikedTemplate;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.CellPanel;
import com.google.gwt.user.client.ui.HasAlignment;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.VerticalPanel;

public class LikesDialog extends GCubeDialog {
	
	private static final int WIDTH = 420;
	private CellPanel mainPanel = new VerticalPanel();
	private VerticalPanel topPanel = new VerticalPanel();
	private HorizontalPanel bottomPanel = new HorizontalPanel();
	private Image loadingImage;
	
	public LikesDialog() {
		super(true);
		setText("People who set this " + NewsFeedPanel.LIKE_LABEL);
		loadingImage = new Image(NewsFeedPanel.loading);
		setSize(""+WIDTH, "100");
		topPanel.setPixelSize(WIDTH, 100);
		bottomPanel.setPixelSize(WIDTH, 25);
		
		topPanel.setHorizontalAlignment(HasAlignment.ALIGN_CENTER);
		topPanel.setVerticalAlignment(HasVerticalAlignment.ALIGN_MIDDLE);
		topPanel.add(loadingImage);
		ScrollPanel scroller = new ScrollPanel();
		scroller.setPixelSize(WIDTH+40, 300);
		
		scroller.add(topPanel);
		mainPanel.add(scroller);
		mainPanel.add(bottomPanel);
		
		bottomPanel.setHorizontalAlignment(HasAlignment.ALIGN_RIGHT);
		Button close = new Button("Close");
		bottomPanel.add(close);
		close.addClickHandler(new ClickHandler() {
			@Override
			public void onClick(ClickEvent event) {
				hide();				
			}
		});
		
		mainPanel.setCellHeight(bottomPanel, "25px");

		setWidget(mainPanel);
	}
	/**
	 * 
	 * @param likes
	 */
	public void showLikes(ArrayList<Like> likes) {
		topPanel.remove(loadingImage);
		bottomPanel.setHorizontalAlignment(HasAlignment.ALIGN_RIGHT);
		for (Like like : likes) {
			topPanel.add(new LikedTemplate(like));
		}
	}
}
