package org.gcube.portlet.user.my_vres.client;

import org.gcube.portlet.user.my_vres.shared.AuthorizationBean;

import com.google.gwt.core.client.EntryPoint;
import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.Window.Location;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.RootPanel;

/**
 * 
 * @author massi
 *
 */
public class MyVREs implements EntryPoint {
	public static final String GET_REDIRECTURI_PARAMETER = "redirect_uri";
	public static final String GET_STATE_PARAMETER = "state";
	public static final String GET_CONTEXT_PARAMETER = "context";
	
	public static final String GET_AUTH_TOKEN_PARAMETER = "gcube-token";

	private final MyVREsServiceAsync myVREsService = GWT.create(MyVREsService.class);

	public void onModuleLoad() {
		//if no redirectUri is present acts normally
		if (Window.Location.getParameter(GET_REDIRECTURI_PARAMETER) == null)
			RootPanel.get("myVREsDIV").add(new VresPanel());
		else {
			handleAuthorisation();
		}


	}
	/**
	 * if the context is present proceed with the call and redirect otherwise display the VREs for scope selection
	 */
	private void handleAuthorisation() {
		final GetParameters params = getParameters();
		if (params.context == null) {
			//TODO:
		}
		else {
			myVREsService.getUserToken(params.context, params.state, new AsyncCallback<AuthorizationBean>() {				
				@Override
				public void onSuccess(AuthorizationBean result) {
					if (result.isSuccess()) {						
						Location.assign(params.redirectURI+"?"+GET_AUTH_TOKEN_PARAMETER+"="+result.getToken()+"&"+GET_STATE_PARAMETER+"="+result.getState());
					} else {
						RootPanel.get("myVREsDIV").add(new HTML("There were issues in managing this request: " + result.getErrorDescription()));
					}
				}

				@Override
				public void onFailure(Throwable caught) {
					RootPanel.get("myVREsDIV").add(new HTML("An error occurred in the server: " + caught.getMessage()));

				}
			});
		}

	}
	/**
	 * check if it has to show just one feed
	 * @return
	 */
	private GetParameters getParameters() {
		String redirectURI = Window.Location.getParameter(GET_REDIRECTURI_PARAMETER);
		String state = Window.Location.getParameter(GET_STATE_PARAMETER);
		String context = Window.Location.getParameter(GET_CONTEXT_PARAMETER);
		return new GetParameters(redirectURI, state, context);
	}
}
