/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.messages.server;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import org.gcube.common.core.utils.logging.GCUBEClientLog;
import org.gcube.portlets.user.homelibrary.home.User;
import org.gcube.portlets.user.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.portlets.user.homelibrary.home.workspace.WorkspaceItem;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.FolderItem;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.ExternalFile;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.ExternalImage;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.ExternalPDFFile;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.gcube.Document;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.gcube.ImageDocument;
import org.gcube.portlets.user.homelibrary.home.workspace.search.SearchFolderItem;
import org.gcube.portlets.user.homelibrary.home.workspace.sharing.WorkspaceMessage;
import org.gcube.portlets.user.messages.server.GWTWorkspaceBuilder;
import org.gcube.portlets.user.messages.server.MessagesServiceImpl;
import org.gcube.portlets.user.messages.server.util.UserUtil;
import org.gcube.portlets.user.messages.shared.FileModel;
import org.gcube.portlets.user.messages.shared.FolderModel;
import org.gcube.portlets.user.messages.shared.GXTFolderItemTypeEnum;
import org.gcube.portlets.user.messages.shared.InfoContactModel;
import org.gcube.portlets.user.messages.shared.MessageModel;

public class GWTWorkspaceBuilder {
    protected static final String IMAGE_SERVICE_URL = "ImageService";
    private static GCUBEClientLog logger = new GCUBEClientLog(MessagesServiceImpl.class, new Properties[0]);

    protected Date toDate(Calendar calendar) {
        if (calendar == null) {
            return new Date(0L);
        }
        return calendar.getTime();
    }

    protected String toDateFormatToString(Calendar calendar) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("dd-MM, yyyy HH:mm:ss z");
        Date resultdate = this.getDate(calendar);
        return dateFormat.format(resultdate);
    }

    protected Date toDateFormat(Calendar calendar) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("dd-MM, yyyy HH:mm:ss z");
        Date resultdate = this.getDate(calendar);
        try {
            resultdate = dateFormat.parse(dateFormat.format(resultdate));
        }
        catch (ParseException e) {
            e.printStackTrace();
            resultdate = new Date(0L);
        }
        return resultdate;
    }

    private Date getDate(Calendar calendar) {
        Date resultdate = null;
        resultdate = calendar == null ? new Date(0L) : new Date(calendar.getTimeInMillis());
        return resultdate;
    }

    protected FileModel setFolderItemType(FileModel fileModel, FolderItem worspaceFolderItem) {
        switch (1.$SwitchMap$org$gcube$portlets$user$homelibrary$home$workspace$folder$FolderItemType[worspaceFolderItem.getFolderItemType().ordinal()]) {
            case 1: {
                fileModel.setFolderItemType(GXTFolderItemTypeEnum.EXTERNAL_IMAGE);
                fileModel.setShortcutCategory("Images");
                ExternalImage extImage = (ExternalImage)worspaceFolderItem;
                fileModel.setType(extImage.getMimeType());
                break;
            }
            case 2: {
                fileModel.setFolderItemType(GXTFolderItemTypeEnum.EXTERNAL_FILE);
                fileModel.setShortcutCategory("Documents");
                ExternalFile extFile = (ExternalFile)worspaceFolderItem;
                fileModel.setType(extFile.getMimeType());
                break;
            }
            case 3: {
                fileModel.setFolderItemType(GXTFolderItemTypeEnum.EXTERNAL_PDF_FILE);
                fileModel.setShortcutCategory("Documents");
                ExternalPDFFile pdfExt = (ExternalPDFFile)worspaceFolderItem;
                fileModel.setType(pdfExt.getMimeType());
                break;
            }
            case 4: {
                fileModel.setFolderItemType(GXTFolderItemTypeEnum.EXTERNAL_URL);
                fileModel.setShortcutCategory("Links");
                break;
            }
            case 5: {
                fileModel.setFolderItemType(GXTFolderItemTypeEnum.REPORT_TEMPLATE);
                fileModel.setShortcutCategory("Reports");
                break;
            }
            case 6: {
                fileModel.setFolderItemType(GXTFolderItemTypeEnum.REPORT);
                fileModel.setShortcutCategory("Reports");
                break;
            }
            case 7: {
                fileModel.setFolderItemType(GXTFolderItemTypeEnum.QUERY);
                fileModel.setShortcutCategory("Documents");
                break;
            }
            case 8: {
                fileModel.setFolderItemType(GXTFolderItemTypeEnum.TIME_SERIES);
                fileModel.setShortcutCategory("Time Series");
                break;
            }
            case 9: {
                fileModel.setFolderItemType(GXTFolderItemTypeEnum.PDF_DOCUMENT);
                fileModel.setShortcutCategory("Documents");
                break;
            }
            case 10: {
                fileModel.setFolderItemType(GXTFolderItemTypeEnum.IMAGE_DOCUMENT);
                fileModel.setShortcutCategory("Images");
                ImageDocument imgDoc = (ImageDocument)worspaceFolderItem;
                fileModel.setType(imgDoc.getMimeType());
                break;
            }
            case 11: {
                fileModel.setFolderItemType(GXTFolderItemTypeEnum.DOCUMENT);
                fileModel.setShortcutCategory("Documents");
                Document doc = (Document)worspaceFolderItem;
                fileModel.setType(doc.getMimeType());
                break;
            }
            case 12: {
                fileModel.setFolderItemType(GXTFolderItemTypeEnum.URL_DOCUMENT);
                fileModel.setShortcutCategory("Documents");
                break;
            }
            case 13: {
                fileModel.setFolderItemType(GXTFolderItemTypeEnum.METADATA);
                fileModel.setShortcutCategory("Documents");
                break;
            }
            case 14: {
                fileModel.setFolderItemType(GXTFolderItemTypeEnum.WORKFLOW_REPORT);
                fileModel.setShortcutCategory("Documents");
                break;
            }
            case 15: {
                fileModel.setFolderItemType(GXTFolderItemTypeEnum.WORKFLOW_TEMPLATE);
                fileModel.setShortcutCategory("Documents");
                break;
            }
            case 16: {
                fileModel.setFolderItemType(GXTFolderItemTypeEnum.EXTERNAL_RESOURCE_LINK);
                fileModel.setShortcutCategory("Links");
                break;
            }
            default: {
                fileModel.setFolderItemType(GXTFolderItemTypeEnum.UNKNOWN_TYPE);
                fileModel.setShortcutCategory("Unknown");
                fileModel.setType(GXTFolderItemTypeEnum.UNKNOWN_TYPE.toString());
            }
        }
        return fileModel;
    }

    protected List<FileModel> buildGXTListFileModelItemForAttachs(List<WorkspaceItem> listWorspaceItems) throws InternalErrorException {
        ArrayList<FileModel> listFileModel = new ArrayList<FileModel>();
        for (WorkspaceItem item : listWorspaceItems) {
            FolderModel fileModel = null;
            switch (1.$SwitchMap$org$gcube$portlets$user$homelibrary$home$workspace$WorkspaceItemType[item.getType().ordinal()]) {
                case 1: {
                    fileModel = new FolderModel(item.getId(), item.getName(), true);
                    fileModel.setType(GXTFolderItemTypeEnum.FOLDER.toString());
                    break;
                }
                case 2: {
                    fileModel = new FileModel(item.getId(), item.getName(), false);
                    FolderItem folderItem = (FolderItem)item;
                    fileModel = this.setFolderItemType((FileModel)fileModel, folderItem);
                    break;
                }
                default: {
                    logger.error((Object)("gxt conversion return null for item " + item.getName()));
                }
            }
            listFileModel.add((FileModel)fileModel);
        }
        return listFileModel;
    }

    protected FileModel buildGXTFileModelItem(WorkspaceItem item, FileModel parentFolderModel) throws InternalErrorException {
        FolderModel fileModel = null;
        switch (1.$SwitchMap$org$gcube$portlets$user$homelibrary$home$workspace$WorkspaceItemType[item.getType().ordinal()]) {
            case 1: {
                fileModel = new FolderModel(item.getId(), item.getName(), (FileModel)((FolderModel)parentFolderModel), true);
                fileModel.setType(GXTFolderItemTypeEnum.FOLDER.toString());
                break;
            }
            case 2: {
                fileModel = new FileModel(item.getId(), item.getName(), (FileModel)((FolderModel)parentFolderModel), false);
                FolderItem folderItem = (FolderItem)item;
                fileModel = this.setFolderItemType((FileModel)fileModel, folderItem);
                break;
            }
            default: {
                logger.error((Object)("gxt conversion return null for item " + item.getName()));
            }
        }
        return fileModel;
    }

    protected FileModel setFolderItemTypeForSearch(FileModel fileModel, SearchFolderItem searchFolderItem) {
        switch (1.$SwitchMap$org$gcube$portlets$user$homelibrary$home$workspace$folder$FolderItemType[searchFolderItem.getFolderItemType().ordinal()]) {
            case 1: {
                fileModel.setFolderItemType(GXTFolderItemTypeEnum.EXTERNAL_IMAGE);
                fileModel.setShortcutCategory("Images");
                fileModel.setType(searchFolderItem.getMimeType());
                break;
            }
            case 2: {
                fileModel.setFolderItemType(GXTFolderItemTypeEnum.EXTERNAL_FILE);
                fileModel.setShortcutCategory("Documents");
                fileModel.setType(searchFolderItem.getMimeType());
                break;
            }
            case 3: {
                fileModel.setFolderItemType(GXTFolderItemTypeEnum.EXTERNAL_PDF_FILE);
                fileModel.setShortcutCategory("Documents");
                fileModel.setType(searchFolderItem.getMimeType());
                break;
            }
            case 4: {
                fileModel.setFolderItemType(GXTFolderItemTypeEnum.EXTERNAL_URL);
                fileModel.setShortcutCategory("Links");
                break;
            }
            case 5: {
                fileModel.setFolderItemType(GXTFolderItemTypeEnum.REPORT_TEMPLATE);
                fileModel.setShortcutCategory("Reports");
                break;
            }
            case 6: {
                fileModel.setFolderItemType(GXTFolderItemTypeEnum.REPORT);
                fileModel.setShortcutCategory("Reports");
                break;
            }
            case 7: {
                fileModel.setFolderItemType(GXTFolderItemTypeEnum.QUERY);
                fileModel.setShortcutCategory("Documents");
                break;
            }
            case 8: {
                fileModel.setFolderItemType(GXTFolderItemTypeEnum.TIME_SERIES);
                fileModel.setShortcutCategory("Time Series");
                break;
            }
            case 9: {
                fileModel.setFolderItemType(GXTFolderItemTypeEnum.PDF_DOCUMENT);
                fileModel.setShortcutCategory("Documents");
                break;
            }
            case 10: {
                fileModel.setFolderItemType(GXTFolderItemTypeEnum.IMAGE_DOCUMENT);
                fileModel.setShortcutCategory("Images");
                fileModel.setType(searchFolderItem.getMimeType());
                break;
            }
            case 11: {
                fileModel.setFolderItemType(GXTFolderItemTypeEnum.DOCUMENT);
                fileModel.setShortcutCategory("Documents");
                fileModel.setType(searchFolderItem.getMimeType());
                break;
            }
            case 12: {
                fileModel.setFolderItemType(GXTFolderItemTypeEnum.URL_DOCUMENT);
                fileModel.setShortcutCategory("Documents");
                break;
            }
            case 13: {
                fileModel.setFolderItemType(GXTFolderItemTypeEnum.METADATA);
                fileModel.setShortcutCategory("Documents");
                break;
            }
            case 14: {
                fileModel.setFolderItemType(GXTFolderItemTypeEnum.WORKFLOW_REPORT);
                fileModel.setShortcutCategory("Documents");
                break;
            }
            case 15: {
                fileModel.setFolderItemType(GXTFolderItemTypeEnum.WORKFLOW_TEMPLATE);
                fileModel.setShortcutCategory("Documents");
                break;
            }
            case 16: {
                fileModel.setFolderItemType(GXTFolderItemTypeEnum.EXTERNAL_RESOURCE_LINK);
                fileModel.setShortcutCategory("Links");
                break;
            }
            default: {
                fileModel.setFolderItemType(GXTFolderItemTypeEnum.UNKNOWN_TYPE);
                fileModel.setShortcutCategory("Unknown");
                fileModel.setType(GXTFolderItemTypeEnum.UNKNOWN_TYPE.toString());
            }
        }
        return fileModel;
    }

    public List<InfoContactModel> buildGXTListContactsModel(List<User> listUsers) throws InternalErrorException {
        ArrayList<InfoContactModel> listContactsModel = new ArrayList<InfoContactModel>();
        for (User user : listUsers) {
            String fullName = UserUtil.getUserFullName((User)user);
            listContactsModel.add(new InfoContactModel(user.getId(), user.getPortalLogin(), fullName));
        }
        return listContactsModel;
    }

    public List<MessageModel> buildGXTListMessageModelForGrid(List<WorkspaceMessage> listMessages, String typeMessages) throws InternalErrorException {
        ArrayList<MessageModel> listMessageModel = new ArrayList<MessageModel>();
        for (WorkspaceMessage mess : listMessages) {
            List listAttachs = mess.getAttachments();
            ArrayList<String> listAttachsNames = new ArrayList<String>();
            logger.trace((Object)("IN SERVER MESSAGE TYPE: " + typeMessages));
            logger.trace((Object)("subject " + mess.getSubject()));
            if (listAttachs != null) {
                for (WorkspaceItem attach : listAttachs) {
                    listAttachsNames.add(attach.getName());
                    logger.trace((Object)("Received attach: " + attach.getName() + " " + attach.getId()));
                }
            }
            listMessageModel.add(new MessageModel(mess.getId(), mess.getSubject(), this.buildGXTInfoContactModel(mess.getSender()), this.toDate(mess.getSendTime()), listAttachsNames, typeMessages, mess.isRead()));
        }
        return listMessageModel;
    }

    public MessageModel buildGXTMessageModel(WorkspaceMessage mess, List<WorkspaceItem> listWorkspaceItems, String messageType) throws InternalErrorException {
        List listAttachs = this.buildGXTListFileModelItemForAttachs(listWorkspaceItems);
        return new MessageModel(mess.getId(), mess.getSubject(), this.buildGXTInfoContactModel(mess.getSender()), this.toDate(mess.getSendTime()), mess.getBody(), listAttachs, mess.getAddresses(), messageType, mess.isRead());
    }

    private InfoContactModel buildGXTInfoContactModel(User user) throws InternalErrorException {
        String fullName = UserUtil.getUserFullName((User)user);
        return new InfoContactModel(user.getId(), user.getPortalLogin(), fullName);
    }
}

