/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.messages.shared;

import com.extjs.gxt.ui.client.data.BaseModelData;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import org.gcube.portlets.user.messages.shared.FileModel;
import org.gcube.portlets.user.messages.shared.InfoContactModel;

public class MessageModel
extends BaseModelData
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected InfoContactModel contact;
    protected FileModel fileModel;

    public MessageModel() {
    }

    public MessageModel(String id, String subject, InfoContactModel sender, Date date, String text, List<FileModel> attachs, List<String> listContactsToString, String messageType, boolean isRead) {
        this(id, subject, sender, date, attachs.size(), isRead, messageType);
        this.setListContactsToString(listContactsToString);
        this.setListAttachments(attachs);
        this.setText(text);
    }

    public MessageModel(String id, String subject, InfoContactModel sender, Date date, int numAttachs, boolean isRead, String messageType) {
        this.setId(id);
        this.setSubject(subject);
        this.setFromContact(sender);
        this.setDate(date);
        this.setFromLogin(sender.getLogin());
        this.setFullName(sender.getFullName());
        this.setNumAttachments(numAttachs);
        this.setRead("" + isRead);
        this.setMessageType(messageType);
    }

    public MessageModel(String id, String subject, InfoContactModel sender, Date date, List<String> attachsNames, String messageType, boolean isRead) {
        this.setId(id);
        this.setSubject(subject);
        this.setFromContact(sender);
        this.setDate(date);
        this.setFromLogin(sender.getLogin());
        this.setFullName(sender.getFullName());
        this.setNumAttachments(attachsNames.size());
        this.setMessageType(messageType);
        this.setRead("" + isRead);
        this.setAttachmentsNames(attachsNames);
        this.setAttachmentsNamesView(attachsNames);
    }

    private void setFullName(String fullName) {
        this.set("From", (Object)fullName);
    }

    public String getFullName() {
        return (String)this.get("From");
    }

    private void setAttachmentsNamesView(List<String> attachsNames) {
        if (attachsNames.size() == 0) {
            this.set("Attachs", (Object)"");
        } else if (attachsNames.size() == 1) {
            this.set("Attachs", (Object)attachsNames.get(0));
        } else if (attachsNames.size() > 1) {
            int attachSize = attachsNames.size() - 1;
            this.set("Attachs", (Object)(String.valueOf(attachsNames.get(0)) + " [+" + attachSize + "]"));
        }
    }

    private void setMessageType(String messageType) {
        this.set("Message Type", (Object)messageType);
    }

    private void setAttachmentsNames(List<String> attachsNames) {
        this.set("Attachments Names", attachsNames);
    }

    private void setListContactsToString(List<String> listContactsToString) {
        this.set("ListContactToString", listContactsToString);
    }

    private void setRead(String isRead) {
        this.set("IsRead", (Object)isRead);
    }

    public String getIsRead() {
        return (String)this.get("IsRead");
    }

    public void setListContactsTo(List<InfoContactModel> listContactsTo) {
        this.set("ListContactsTo", listContactsTo);
    }

    private void setListAttachments(List<FileModel> listAttachs) {
        this.set("ListAttachs", listAttachs);
    }

    private void setDate(Date date) {
        this.set("Date", (Object)date);
    }

    private void setNumAttachments(int num) {
        this.set("Num Attachs", (Object)num);
    }

    public void setId(String id) {
        this.set("id", (Object)id);
    }

    private void setText(String text) {
        this.set("TextMess", (Object)text);
    }

    private void setFromContact(InfoContactModel contact) {
        this.set("From", (Object)contact);
    }

    private void setSubject(String subject) {
        this.set("Subject", (Object)subject);
    }

    private void setFromLogin(String login) {
        this.set("From Contact", (Object)login);
    }

    public String getId() {
        return (String)this.get("id");
    }

    public String getSubject() {
        return (String)this.get("Subject");
    }

    public Date getDate() {
        return (Date)this.get("Date");
    }

    public int getNumAttchments() {
        return (Integer)this.get("Num Attachs");
    }

    public InfoContactModel getFromContact() {
        return (InfoContactModel)this.get("From");
    }

    public String getFromLogin() {
        return (String)this.get("From Contact");
    }

    public String getTextMessage() {
        return (String)this.get("TextMess");
    }

    public String getAttachmentsNamesView() {
        return (String)this.get("Attachs");
    }

    public List<InfoContactModel> getListContactsTo() {
        return (List)this.get("ListContactsTo");
    }

    public List<String> getListContactsToString() {
        return (List)this.get("ListContactToString");
    }

    public List<FileModel> getListAttachments() {
        return (List)this.get("ListAttachs");
    }

    public String getMessageType() {
        return (String)this.get("Message Type");
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("MessageModel [getIsRead()=");
        builder.append(this.getIsRead());
        builder.append(", getId()=");
        builder.append(this.getId());
        builder.append(", getSubject()=");
        builder.append(this.getSubject());
        builder.append(", getDate()=");
        builder.append(this.getDate());
        builder.append(", getNumAttchments()=");
        builder.append(this.getNumAttchments());
        builder.append(", getFromContact()=");
        builder.append(this.getFromContact());
        builder.append(", getFromLogin()=");
        builder.append(this.getFromLogin());
        builder.append(", getTextMessage()=");
        builder.append(this.getTextMessage());
        builder.append(", getAttachmentsNamesView()=");
        builder.append(this.getAttachmentsNamesView());
        builder.append(", getListContactsTo()=");
        builder.append(this.getListContactsTo());
        builder.append(", getListContactsToString()=");
        builder.append(this.getListContactsToString());
        builder.append(", getListAttachments()=");
        builder.append(this.getListAttachments());
        builder.append(", getMessageType()=");
        builder.append(this.getMessageType());
        builder.append("]");
        return builder.toString();
    }
}

