/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.messages.client.view.message;

import com.extjs.gxt.ui.client.event.SelectionListener;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.grid.Grid;
import com.extjs.gxt.ui.client.widget.menu.Menu;
import com.extjs.gxt.ui.client.widget.menu.MenuItem;
import com.extjs.gxt.ui.client.widget.menu.SeparatorMenuItem;
import com.google.gwt.event.shared.HandlerManager;
import java.util.List;
import org.gcube.portlets.user.messages.client.MessagesApplicationController;
import org.gcube.portlets.user.messages.client.resources.Resources;
import org.gcube.portlets.user.messages.shared.MessageModel;

public class ContextMenuMessages {
    private Menu contextMenu = new Menu();
    private HandlerManager eventBus = MessagesApplicationController.getEventBus();
    private Grid<MessageModel> gridMessages;

    public ContextMenuMessages(Grid<MessageModel> gridMessages) {
        this.contextMenu.setWidth(140);
        this.gridMessages = gridMessages;
        this.createContextMenu();
        gridMessages.setContextMenu(this.contextMenu);
    }

    public List<MessageModel> getMessagesSelected() {
        return this.gridMessages.getSelectionModel().getSelectedItems();
    }

    private void createContextMenu() {
        MenuItem openMessage = new MenuItem();
        openMessage.setId("OPM");
        openMessage.setText("Reply");
        openMessage.setIcon(Resources.getIconOpenEmail());
        openMessage.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.contextMenu.add((Component)openMessage);
        MenuItem saveAttachs = new MenuItem();
        saveAttachs.setId("SVA");
        saveAttachs.setText("Save Attachments");
        saveAttachs.setIcon(Resources.getIconSaveAttachments());
        saveAttachs.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.contextMenu.add((Component)saveAttachs);
        MenuItem forwardMessage = new MenuItem();
        forwardMessage.setId("FWM");
        forwardMessage.setText("Forward Message");
        forwardMessage.setIcon(Resources.getIconEmailForward());
        forwardMessage.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.contextMenu.add((Component)forwardMessage);
        MenuItem deleteMessage = new MenuItem();
        deleteMessage.setId("DLM");
        deleteMessage.setText("Delete Message");
        deleteMessage.setIcon(Resources.getIconDeleteMessage());
        deleteMessage.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.contextMenu.add((Component)deleteMessage);
        this.contextMenu.add((Component)new SeparatorMenuItem());
        MenuItem markRead = new MenuItem();
        markRead.setId("MKR");
        markRead.setText("Mark as Read");
        markRead.setIcon(Resources.getIconEmailRead());
        markRead.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.contextMenu.add((Component)markRead);
        MenuItem markeNotRead = new MenuItem();
        markeNotRead.setId("MKNR");
        markeNotRead.setText("Mark as Not Read");
        markeNotRead.setIcon(Resources.getIconEmailNotRead());
        markeNotRead.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.contextMenu.add((Component)markeNotRead);
    }

    public Menu getContextMenu() {
        return this.contextMenu;
    }

    public void contextMenuSwitch(MessageModel selectedItem) {
        this.contextMenu.getItemByItemId("MKR").setVisible(false);
        this.contextMenu.getItemByItemId("MKNR").setVisible(false);
        if (selectedItem.getIsRead().equals("true")) {
            this.contextMenu.getItemByItemId("MKNR").setVisible(true);
        } else {
            this.contextMenu.getItemByItemId("MKR").setVisible(true);
        }
        if (selectedItem.getNumAttchments() > 0) {
            this.contextMenu.getItemByItemId("SVA").setVisible(true);
        } else {
            this.contextMenu.getItemByItemId("SVA").setVisible(false);
        }
    }

    static /* synthetic */ HandlerManager access$000(ContextMenuMessages x0) {
        return x0.eventBus;
    }
}

