package org.gcube.portlets.user.messages.shared;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

import org.gcube.portlets.user.messages.client.ConstantsPortletMessages;

import com.extjs.gxt.ui.client.data.BaseModelData;

/**
 * @author Francesco Mangiacrapa francesco.mangiacrapa@isti.cnr.it
 *
 */
public class MessageModel extends BaseModelData implements Serializable {


	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	protected InfoContactModel contact; //TODO remove?
	protected FileModel fileModel; //TODO remove?
	
	public MessageModel() {}

	/**
	 *  USED IN OPEN MESSAGE
	 * @param id
	 * @param subject
	 * @param sender
	 * @param date
	 * @param text
	 * @param attachs
	 * @param listContactsToString
	 * @param messageType
	 * @param isRead
	 */
	public MessageModel(String id, String subject, InfoContactModel sender, Date date, String text, List<FileModel> attachs, List<String> listContactsToString, String messageType, boolean isRead) {
		this(id,subject,sender,date,attachs.size(),isRead, messageType);
		setListContactsToString(listContactsToString);
		setListAttachments(attachs);
		setText(text);
	
	}
	
	
	/**
	 * BASIC CONSTRUCTOR
	 */
	public MessageModel(String id, String subject, InfoContactModel sender, Date date, int numAttachs, boolean isRead, String messageType) {
		setId(id);
		setSubject(subject);
		setFromContact(sender);
		setDate(date);
		setFromLogin(sender.getLogin());
		setFullName(sender.getFullName());
		setNumAttachments(numAttachs);
		setRead(""+isRead);
		setMessageType(messageType);
	}

	
	/**
	 * USED TO VIEW MESSAGE IN GRID
	 * @param id
	 * @param subject
	 * @param sender
	 * @param date
	 * @param attachsNames
	 * @param messageType
	 * @param isRead
	 */
	public MessageModel(String id, String subject, InfoContactModel sender, Date date, List<String> attachsNames, String messageType, boolean isRead) {
		setId(id);
		setSubject(subject);
		setFromContact(sender);
		setDate(date);
		setFromLogin(sender.getLogin());
		setFullName(sender.getFullName());
		setNumAttachments(attachsNames.size());
		setMessageType(messageType);
		setRead(""+isRead);
//		System.out.println("##################IN CONSTRUCTROR Attach size: " + attachsNames.size());
		setAttachmentsNames(attachsNames);		
//		System.out.println("##########START MESSAGE: " + id);
//		
//		for(String mess: attachsNames){
//			System.out.println("##################IN CONSTRUCTROR Attach: " + mess);
//		}
//		
//		System.out.println("##########END MESSAGE: " + id);
		setAttachmentsNamesView(attachsNames);
	}

	private void setFullName(String fullName) {
		set(ConstantsPortletMessages.FULLNAME, fullName);		
		
	}
	
	public String getFullName(){
		return get(ConstantsPortletMessages.FULLNAME);
	}

	/**
	 * Set string with first attach name and the numbers of attachs
	 * @param attachsNames
	 */
	private void setAttachmentsNamesView(List<String> attachsNames) {
		if(attachsNames.size()==0){
			set(ConstantsPortletMessages.ATTACHS, "");	
		}else if(attachsNames.size() == 1){
			set(ConstantsPortletMessages.ATTACHS, attachsNames.get(0));	
		}else if(attachsNames.size() > 1){
			int attachSize = attachsNames.size() - 1;
			set(ConstantsPortletMessages.ATTACHS, attachsNames.get(0) + " [+"+attachSize + "]");
		}
	}
	
	
	private void setMessageType(String messageType) {
		set(ConstantsPortletMessages.MESSAGETYPE, messageType);	
	}

	private void setAttachmentsNames(List<String> attachsNames) {
		set(ConstantsPortletMessages.LISTATTACHMENTSNAMES, attachsNames);	
	}
	
	private void setListContactsToString(List<String> listContactsToString) {
		set(ConstantsPortletMessages.LISTCONTACTSTOSTRING, listContactsToString);		
	}
	
	
	private void setRead(String isRead) {
		set(ConstantsPortletMessages.ISREAD, isRead);	
		
	}
	
	public String getIsRead() {
		return get(ConstantsPortletMessages.ISREAD);
	}

	public void setListContactsTo(List<InfoContactModel> listContactsTo) {
		set(ConstantsPortletMessages.LISTCONTACTSTO, listContactsTo);	
	}
	
	private void setListAttachments(List<FileModel> listAttachs) {
		set(ConstantsPortletMessages.LISTATTACHS, listAttachs);	
	}
	
	private void setDate(Date date) {
		set(ConstantsPortletMessages.DATE, date);
	}

	private void setNumAttachments(int num) {
		set(ConstantsPortletMessages.NUMATTACHS, num);
	}

	public void setId(String id) {
		set(ConstantsPortletMessages.ID, id);
	}
	
	private void setText(String text) {
		set(ConstantsPortletMessages.TEXTMESS, text);		
	}


	private void setFromContact(InfoContactModel contact) {
		set(ConstantsPortletMessages.FROM, contact);	
	}

	private void setSubject(String subject) {
		set(ConstantsPortletMessages.SUBJECT, subject);
	}
	
	private void setFromLogin(String login){
		set(ConstantsPortletMessages.FROMLOGIN, login);
	}

	public String getId() {
		return get(ConstantsPortletMessages.ID);
	}

	public String getSubject() {
		return get(ConstantsPortletMessages.SUBJECT);
	}
	
	public Date getDate() {
		return (Date) get(ConstantsPortletMessages.DATE);
	}
	
	public int getNumAttchments() {
		return (Integer) get(ConstantsPortletMessages.NUMATTACHS);
	}
	
	public InfoContactModel getFromContact() {
		return (InfoContactModel) get(ConstantsPortletMessages.FROM);
	}
	
	public String getFromLogin() {
		return get(ConstantsPortletMessages.FROMLOGIN);
	}
	
	public String getTextMessage() {
		return get(ConstantsPortletMessages.TEXTMESS);
	}
	
	
	/**
	 * used in grid
	 * @return
	 */
	public String getAttachmentsNamesView() {
		return get(ConstantsPortletMessages.ATTACHS);
	}
	
	public List<InfoContactModel> getListContactsTo() {
		return get(ConstantsPortletMessages.LISTCONTACTSTO);
	}
	
	public List<String> getListContactsToString() {
		return get(ConstantsPortletMessages.LISTCONTACTSTOSTRING);
	}
	
	public List<FileModel> getListAttachments() {
		return get(ConstantsPortletMessages.LISTATTACHS);
	}
	
	public String getMessageType(){
		return get(ConstantsPortletMessages.MESSAGETYPE);
	}

	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("MessageModel [getIsRead()=");
		builder.append(getIsRead());
		builder.append(", getId()=");
		builder.append(getId());
		builder.append(", getSubject()=");
		builder.append(getSubject());
		builder.append(", getDate()=");
		builder.append(getDate());
		builder.append(", getNumAttchments()=");
		builder.append(getNumAttchments());
		builder.append(", getFromContact()=");
		builder.append(getFromContact());
		builder.append(", getFromLogin()=");
		builder.append(getFromLogin());
		builder.append(", getTextMessage()=");
		builder.append(getTextMessage());
		builder.append(", getAttachmentsNamesView()=");
		builder.append(getAttachmentsNamesView());
		builder.append(", getListContactsTo()=");
		builder.append(getListContactsTo());
		builder.append(", getListContactsToString()=");
		builder.append(getListContactsToString());
		builder.append(", getListAttachments()=");
		builder.append(getListAttachments());
		builder.append(", getMessageType()=");
		builder.append(getMessageType());
		builder.append("]");
		return builder.toString();
	}
	
}