/**
 * 
 */
package org.gcube.portlets.user.messages.server.util;

import javax.servlet.http.HttpSession;

import org.apache.log4j.Logger;
import org.gcube.application.framework.core.session.ASLSession;
import org.gcube.application.framework.core.session.SessionManager;
import org.gcube.portlets.user.homelibrary.home.HomeLibrary;
import org.gcube.portlets.user.homelibrary.home.exceptions.HomeNotFoundException;
import org.gcube.portlets.user.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.portlets.user.homelibrary.home.workspace.Workspace;
import org.gcube.portlets.user.homelibrary.home.workspace.exceptions.WorkspaceFolderNotFoundException;
import org.gcube.portlets.user.messages.server.GWTMessagesBuilder;


/**
 * @author Federico De Faveri defaveri@isti.cnr.it
 *
 */
public class SessionUtil {

	public static final String USERNAME_ATTRIBUTE = "username";
	public static final String MESSAGESBUILDER_ATTRIBUTE = "MESSAGESBUILDERS";
	
	public static Logger logger = Logger.getLogger(SessionUtil.class);
	
//	public static final String TEST_SCOPE = "/gcube/devsec";
//	public static final String TEST_USER = "pasquale.pagano";
	
	public static final String TEST_SCOPE = "/gcube/devNext";
//	public static final String TEST_USER = "federico.defaveri";
//	public static final String TEST_USER = "test.user";
	public static final String TEST_USER = "francesco.mangiacrapa";
	
//	public static final String TEST_USER = "pasquale.pagano";

	public static ASLSession getAslSession(HttpSession httpSession)
	{
		String sessionID = httpSession.getId();
		String user = (String) httpSession.getAttribute(USERNAME_ATTRIBUTE);

		if (user == null) {

			logger.error("WORKSPACE PORTLET STARTING IN TEST MODE - NO USER FOUND");

			//for test only
			httpSession.setAttribute(USERNAME_ATTRIBUTE, TEST_USER);
			ASLSession session = SessionManager.getInstance().getASLSession(sessionID, TEST_USER);
			session.setScope(TEST_SCOPE);
			//session.setScope("/d4science.research-infrastructures.eu/Ecosystem/TryIt");

			return session;
		}

		return SessionManager.getInstance().getASLSession(sessionID, user);
	}

	public static Workspace getWorkspace(final HttpSession httpSession) throws WorkspaceFolderNotFoundException, InternalErrorException, HomeNotFoundException 
	{
		Workspace workspace = null;
		
		ASLSession session = getAslSession(httpSession);

		workspace = HomeLibrary.getUserWorkspace(session);
			
		return workspace;

	}
	
	public static GWTMessagesBuilder getGWTWorkspaceBuilder(HttpSession httpSession)
	{
		ASLSession session = getAslSession(httpSession);
		GWTMessagesBuilder builder = (GWTMessagesBuilder) session.getAttribute(MESSAGESBUILDER_ATTRIBUTE);
		
		if (builder == null)
		{
			logger.trace("Initializing the workspace area builder");
			
			builder = new GWTMessagesBuilder();
			session.setAttribute(MESSAGESBUILDER_ATTRIBUTE, builder);
		}
		
		return builder;
	}
}
