package org.gcube.portlets.user.joinvre.model;

import java.io.Serializable;

/**
 * UserBelonging Model - Migrated from 6.2 to 7.4
 * 
 * @author Massimiliano Assante, ISTI-CNR (original)
 * @author netfarm-m2 (migration to 7.4)
 */
public class UserBelonging implements Serializable {
	
	private static final long serialVersionUID = 1L;
	
	public enum MembershipType {
		MEMBER,
		PENDING,
		NOT_MEMBER,
		ADMIN,
		OWNER
	}
	
	private long userId;
	private long vreId;
	private MembershipType membershipType;
	private boolean canJoin;
	private boolean canRequest;
	private String requestComments;
	
	public UserBelonging() {
		super();
	}
	
	public UserBelonging(long userId, long vreId, MembershipType membershipType, 
			boolean canJoin, boolean canRequest) {
		this.userId = userId;
		this.vreId = vreId;
		this.membershipType = membershipType;
		this.canJoin = canJoin;
		this.canRequest = canRequest;
	}
	
	public long getUserId() {
		return userId;
	}
	
	public void setUserId(long userId) {
		this.userId = userId;
	}
	
	public long getVreId() {
		return vreId;
	}
	
	public void setVreId(long vreId) {
		this.vreId = vreId;
	}
	
	public MembershipType getMembershipType() {
		return membershipType;
	}
	
	public void setMembershipType(MembershipType membershipType) {
		this.membershipType = membershipType;
	}
	
	public boolean isCanJoin() {
		return canJoin;
	}
	
	public void setCanJoin(boolean canJoin) {
		this.canJoin = canJoin;
	}
	
	public boolean isCanRequest() {
		return canRequest;
	}
	
	public void setCanRequest(boolean canRequest) {
		this.canRequest = canRequest;
	}
	
	public String getRequestComments() {
		return requestComments;
	}
	
	public void setRequestComments(String requestComments) {
		this.requestComments = requestComments;
	}
	
	@Override
	public String toString() {
		return "UserBelonging [userId=" + userId + ", vreId=" + vreId + 
				", membershipType=" + membershipType + ", canJoin=" + canJoin + 
				", canRequest=" + canRequest + "]";
	}
}