/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.joinvre.portlet;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCPortlet;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.servlet.SessionMessages;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ParamUtil;
import java.io.IOException;
import java.util.List;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.Portlet;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.ProcessAction;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import org.gcube.portlets.user.joinvre.model.VRE;
import org.gcube.portlets.user.joinvre.service.JoinVREService;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"com.liferay.portlet.display-category=category.gcube", "com.liferay.portlet.header-portlet-css=/css/main.css", "com.liferay.portlet.instanceable=true", "com.liferay.portlet.preferences-owned-by-group=true", "com.liferay.portlet.private-request-attributes=false", "com.liferay.portlet.private-session-attributes=false", "com.liferay.portlet.render-weight=50", "com.liferay.portlet.use-default-template=true", "javax.portlet.display-name=Join VRE", "javax.portlet.expiration-cache=0", "javax.portlet.init-param.template-path=/", "javax.portlet.init-param.view-template=/view.jsp", "javax.portlet.init-param.config-template=/config.jsp", "javax.portlet.name=org_gcube_portlets_user_joinvre_JoinVREPortlet", "javax.portlet.resource-bundle=content.Language", "javax.portlet.security-role-ref=power-user,user", "javax.portlet.version=3.0"}, service={Portlet.class})
public class JoinVREPortlet
extends MVCPortlet {
    private static final Log _log = LogFactoryUtil.getLog(JoinVREPortlet.class);
    @Reference
    private JoinVREService joinVREService;

    public void doView(RenderRequest renderRequest, RenderResponse renderResponse) throws IOException, PortletException {
        try {
            ThemeDisplay themeDisplay = (ThemeDisplay)renderRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
            List<VRE> availableVREs = null;
            if (this.joinVREService != null) {
                availableVREs = this.joinVREService.getAvailableVREs();
                _log.debug((Object)("Retrieved " + (availableVREs != null ? availableVREs.size() : 0) + " VREs"));
            } else {
                _log.warn((Object)"JoinVREService is not available");
            }
            renderRequest.setAttribute("themeDisplay", (Object)themeDisplay);
            renderRequest.setAttribute("user", (Object)themeDisplay.getUser());
            renderRequest.setAttribute("scopeGroupId", (Object)themeDisplay.getScopeGroupId());
            renderRequest.setAttribute("availableVREs", availableVREs);
            _log.debug((Object)("JoinVRE portlet rendering for user: " + themeDisplay.getUser().getScreenName()));
        }
        catch (Exception e) {
            _log.error((Object)"Error in JoinVRE portlet doView", (Throwable)e);
        }
        super.doView(renderRequest, renderResponse);
    }

    @ProcessAction(name="requestMembership")
    public void requestMembership(ActionRequest actionRequest, ActionResponse actionResponse) throws IOException, PortletException {
        try {
            boolean ok;
            long vreId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"vreId");
            ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
            User user = themeDisplay.getUser();
            _log.info((Object)("Processing membership request for VRE ID: " + vreId + " by user " + user.getScreenName()));
            boolean bl = ok = this.joinVREService != null && this.joinVREService.requestMembership(user, vreId, null);
            if (ok) {
                SessionMessages.add((PortletRequest)actionRequest, (String)"membership-request-sent");
            } else {
                SessionErrors.add((PortletRequest)actionRequest, (String)"membership-request-error");
            }
        }
        catch (Exception e) {
            _log.error((Object)"Error processing membership request", (Throwable)e);
            SessionErrors.add((PortletRequest)actionRequest, (String)"membership-request-error");
        }
    }

    public void serveResource(ResourceRequest resourceRequest, ResourceResponse resourceResponse) throws IOException, PortletException {
        super.serveResource(resourceRequest, resourceResponse);
    }
}

