/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.joinnew.server;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Date;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.gcube.portal.custom.communitymanager.OrganizationsUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class EmailNotification {
    private static final String SENDER_EMAIL = "notificationSenderEmail";
    private static final String GATEWAY_NAME = "portalinstancename";
    private String emailSender = EmailNotification.getNotificationSenderEmail();
    private String[] emailrecipients;
    private String emailSubject;
    private String emailBody;
    private String portalName;
    private static Logger _log = LoggerFactory.getLogger(EmailNotification.class);

    public EmailNotification(String sender, String[] recipients, String subject, String body) {
        this.emailrecipients = recipients;
        this.emailSubject = subject;
        this.emailBody = body;
        this.portalName = EmailNotification.getPortalInstanceName();
    }

    public void sendEmail() {
        Properties props = System.getProperties();
        String mailServiceHost = "localhost";
        props.put("mail.smtp.host", mailServiceHost);
        String mailServicePort = "25";
        props.put("mail.smtp.port", mailServicePort);
        Session session = Session.getDefaultInstance((Properties)props, null);
        session.setDebug(true);
        MimeMessage mimeMessage = new MimeMessage(session);
        try {
            InternetAddress from = new InternetAddress(this.emailSender, this.portalName);
            mimeMessage.setHeader("Content-Type", "text/html; charset=UTF-8");
            mimeMessage.setFrom((Address)from);
            for (int i = 0; i < this.emailrecipients.length; ++i) {
                InternetAddress address = new InternetAddress(this.emailrecipients[i]);
                mimeMessage.addRecipient(Message.RecipientType.TO, (Address)address);
            }
            mimeMessage.setSubject(this.emailSubject);
            mimeMessage.setContent((Object)this.emailBody, "text/html; charset=UTF-8");
            mimeMessage.setSentDate(new Date());
            Transport.send((Message)mimeMessage);
        }
        catch (Exception e) {
            e.printStackTrace();
            _log.error("Failed to send the email message.", (Throwable)e);
        }
    }

    protected static String getPortalInstanceName() {
        Properties props = new Properties();
        String toReturn = "";
        try {
            String propertyfile = OrganizationsUtil.getTomcatFolder() + "conf/gcube-data.properties";
            File propsFile = new File(propertyfile);
            FileInputStream fis = new FileInputStream(propsFile);
            props.load(fis);
            toReturn = props.getProperty("portalinstancename");
        }
        catch (IOException e) {
            toReturn = "Gateway support";
            _log.error("gcube-data.properties file not found under $CATALINA_HOME/conf dir, returning default Portal Name " + toReturn);
            return toReturn;
        }
        _log.debug("Returning Gateway Name: " + toReturn);
        return toReturn;
    }

    private static String getNotificationSenderEmail() {
        Properties props = new Properties();
        String toReturn = "";
        try {
            String propertyfile = OrganizationsUtil.getTomcatFolder() + "conf/gcube-data.properties";
            File propsFile = new File(propertyfile);
            FileInputStream fis = new FileInputStream(propsFile);
            props.load(fis);
            toReturn = props.getProperty("notificationSenderEmail");
        }
        catch (IOException e) {
            toReturn = "do-not-reply@d4science.org";
            _log.error("gcube-data.properties file not found under $CATALINA_HOME/conf dir, returning default Email" + toReturn);
            return toReturn;
        }
        _log.debug("Returning SENDER_EMAIL: " + toReturn);
        return toReturn;
    }
}

