/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.joinvre.server;

import com.google.gwt.user.server.rpc.RemoteServiceServlet;
import com.liferay.portal.kernel.bean.BeanLocatorException;
import com.liferay.portal.kernel.cache.CacheRegistryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.VirtualHost;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portal.service.LayoutSetLocalServiceUtil;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.service.VirtualHostLocalServiceUtil;
import com.liferay.portal.util.PortalUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.gcube.common.portal.PortalContext;
import org.gcube.portal.databook.server.DBCassandraAstyanaxImpl;
import org.gcube.portal.databook.server.DatabookStore;
import org.gcube.portal.databook.shared.Invite;
import org.gcube.portal.databook.shared.InviteStatus;
import org.gcube.portal.databook.shared.UserInfo;
import org.gcube.portal.tou.TermsOfUseImpl;
import org.gcube.portal.tou.exceptions.ToUNotFoundException;
import org.gcube.portal.tou.model.ToU;
import org.gcube.portlets.user.joinvre.client.JoinService;
import org.gcube.portlets.user.joinvre.server.JoinServiceImpl;
import org.gcube.portlets.user.joinvre.server.LoginServiceUtil;
import org.gcube.portlets.user.joinvre.shared.TabbedPage;
import org.gcube.portlets.user.joinvre.shared.UserBelonging;
import org.gcube.portlets.user.joinvre.shared.VRE;
import org.gcube.portlets.user.joinvre.shared.VRECategory;
import org.gcube.portlets.user.joinvre.shared.VreMembershipType;
import org.gcube.vomanagement.usermanagement.GroupManager;
import org.gcube.vomanagement.usermanagement.exception.GroupRetrievalFault;
import org.gcube.vomanagement.usermanagement.exception.UserManagementSystemException;
import org.gcube.vomanagement.usermanagement.exception.UserRetrievalFault;
import org.gcube.vomanagement.usermanagement.impl.LiferayGroupManager;
import org.gcube.vomanagement.usermanagement.impl.LiferayUserManager;
import org.gcube.vomanagement.usermanagement.model.GCubeGroup;
import org.gcube.vomanagement.usermanagement.model.GCubeMembershipRequest;
import org.gcube.vomanagement.usermanagement.model.GCubeUser;
import org.gcube.vomanagement.usermanagement.model.GroupMembershipType;
import org.gcube.vomanagement.usermanagement.model.MembershipRequestStatus;
import org.gcube.vomanagement.usermanagement.model.VirtualGroup;

/*
 * Exception performing whole class analysis ignored.
 */
public class JoinServiceImpl
extends RemoteServiceServlet
implements JoinService {
    private static Log _log = LogFactoryUtil.getLog(JoinServiceImpl.class);
    private static DatabookStore store;
    public static final String PREFIX_PUBLIC_URL = "/web";
    public static final String TABBED_LAYOUT_ATTRIBUTE = "TabbedLayout";
    public static final String TAB_NAMES_ATTRIBUTE = "TabName";
    public static final String ORGANIZATION_NAMES_ATTRIBUTE = "OrganisationName";
    public static final String ALLVRES_SESSION_ATTRIBUTE = "ALLVRES_SESSION";
    private static GroupManager groupsManager;

    public void init() {
        groupsManager = new LiferayGroupManager();
    }

    private boolean isWithinPortal() {
        try {
            UserLocalServiceUtil.getService();
            return true;
        }
        catch (BeanLocatorException ex) {
            _log.trace((Object)"Development Mode ON");
            return false;
        }
    }

    public String joinVRE(Long vreID) {
        try {
            return PortalContext.getConfiguration().getSiteLandingPagePath(this.getThreadLocalRequest());
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public UserInfo readInvite(String inviteId, long siteId) {
        JoinServiceImpl.initStore();
        try {
            Invite invite = store.readInvite(inviteId);
            GCubeUser inviter = new LiferayUserManager().getUserByUsername(invite.getSenderUserId());
            return new UserInfo(inviter.getUsername(), inviter.getFullname(), inviter.getUserAvatarURL(), "", this.getTermsOfUse(siteId), true, false, null);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public String getTermsOfUse(long siteId) {
        TermsOfUseImpl tou = new TermsOfUseImpl();
        try {
            long groupId = groupsManager.getGroup(siteId).getGroupId();
            ToU terms = tou.getToUGroup(groupId);
            return terms.getContent();
        }
        catch (ToUNotFoundException ex) {
            _log.debug((Object)("Terms of Use not found for this VRE id " + siteId));
            return null;
        }
        catch (Exception e) {
            _log.error((Object)("An error occurred while trying to fetch the ToU for VRE id " + siteId));
            return null;
        }
    }

    public List<TabbedPage> isTabbedPanel() {
        if (this.isWithinPortal()) {
            _log.info((Object)"check if isTabbedPanel ");
            Serializable tabbedLayoutObj = null;
            try {
                long currentSiteGroupId = this.getSiteFromServletRequest(this.getThreadLocalRequest()).getGroupId();
                tabbedLayoutObj = groupsManager.readCustomAttr(currentSiteGroupId, "TabbedLayout");
                Boolean isTabbedLayout = false;
                if (tabbedLayoutObj != null && (isTabbedLayout = (Boolean)tabbedLayoutObj).booleanValue()) {
                    return this.getTabNames();
                }
            }
            catch (Exception e1) {
                e1.printStackTrace();
                return null;
            }
            return null;
        }
        return Arrays.asList(new TabbedPage("Products", "designed to apply Data Mining techniques to biological data. "), new TabbedPage("Portfolio", "Portfolio description The algorithms are executed in .."));
    }

    private List<TabbedPage> getTabNames() throws Exception {
        ArrayList<TabbedPage> toReturn = new ArrayList<TabbedPage>();
        long currentSiteGroupId = this.getSiteFromServletRequest(this.getThreadLocalRequest()).getGroupId();
        String[] values = (String[])groupsManager.readCustomAttr(currentSiteGroupId, "TabName");
        TabbedPage toAdd = new TabbedPage();
        if (values != null && values.length > 0) {
            for (int i = 0; i < values.length; ++i) {
                toAdd = new TabbedPage();
                String[] splits = values[i].split("\\|");
                if (splits.length > 1) {
                    toAdd.setName(splits[0]);
                    toAdd.setDescription(splits[1]);
                } else {
                    _log.warn((Object)"I could not find the Tab Description in the Custom field, is it separated by the pipe? getting all the value ...");
                    toAdd.setName(values[i]);
                    toAdd.setDescription("");
                }
                toReturn.add(toAdd);
            }
        } else {
            toAdd.setName("NoTabbedPageAssigned");
            toAdd.setDescription("NoTabbedPageDescription");
        }
        return toReturn;
    }

    public LinkedHashMap<VRECategory, ArrayList<VRE>> getVREs() {
        LinkedHashMap toReturn = new LinkedHashMap();
        try {
            if (this.isWithinPortal()) {
                if (this.isTabbedPanel() != null) {
                    String firstTabName = ((TabbedPage)this.getTabNames().get(0)).getName();
                    return this.getPortalSitesMappedToVRE(firstTabName);
                }
                toReturn = this.getPortalSitesMappedToVRE();
                this.setVREsInSession(toReturn);
            } else {
                toReturn = this.getFakePortalVREs();
            }
        }
        catch (Exception e) {
            _log.error((Object)"Error getting VREs", (Throwable)e);
        }
        return toReturn;
    }

    public LinkedHashMap<VRECategory, ArrayList<VRE>> getPortalSitesMappedToVRE(String tabName) {
        tabName = tabName.trim();
        _log.debug((Object)("Asked for vres of Tab " + tabName));
        LinkedHashMap<VRECategory, ArrayList<VRE>> tabVREs = new LinkedHashMap<VRECategory, ArrayList<VRE>>();
        try {
            LinkedHashMap allVREs = this.getPortalSitesMappedToVRE();
            this.setVREsInSession(allVREs);
            for (VRECategory cat : allVREs.keySet()) {
                ArrayList<VRE> toAdd = new ArrayList<VRE>();
                tabVREs.put(cat, toAdd);
                for (VRE vre : (ArrayList)allVREs.get(cat)) {
                    _log.debug((Object)("getting selected tab for " + vre.getName()));
                    String[] vreTabNames = (String[])groupsManager.readCustomAttr(vre.getId(), "TabName");
                    if (vreTabNames != null && vreTabNames.length > 0) {
                        String vreTabName = vreTabNames[0];
                        if (!tabName.equals(vreTabName)) continue;
                        toAdd.add(vre);
                        _log.debug((Object)("Added " + vre.getName() + " as it belongs to " + vreTabName));
                        continue;
                    }
                    _log.warn((Object)("Spotted vre without tab assigned: " + vre.getName() + " skipping it ..."));
                }
            }
        }
        catch (Exception e) {
            _log.error((Object)"Error getting VREs by Category", (Throwable)e);
        }
        return tabVREs;
    }

    public LinkedHashMap<VRECategory, ArrayList<VRE>> getVREsByOrganisation(String organisationName) {
        LinkedHashMap<VRECategory, ArrayList<VRE>> organizationVREs = new LinkedHashMap<VRECategory, ArrayList<VRE>>();
        try {
            LinkedHashMap allVREs = this.getPortalSitesMappedToVRE();
            for (VRECategory cat : allVREs.keySet()) {
                ArrayList<VRE> toAdd = new ArrayList<VRE>();
                organizationVREs.put(cat, toAdd);
                for (VRE vre : (ArrayList)allVREs.get(cat)) {
                    String[] vreOrgNames = (String[])groupsManager.readCustomAttr(vre.getId(), "OrganisationName");
                    String vreOrgName = vreOrgNames[0];
                    if (!organisationName.equals(vreOrgName)) continue;
                    toAdd.add(vre);
                    _log.debug((Object)("Added " + vre.getName() + " as it belongs to organisation " + organisationName));
                }
            }
        }
        catch (Exception e) {
            _log.error((Object)"Error getting VREs by Organization", (Throwable)e);
        }
        return organizationVREs;
    }

    public LinkedHashMap<VRECategory, ArrayList<VRE>> getVREsByCategory(String categoryName) {
        _log.debug((Object)("getVREsByCategory: " + categoryName));
        LinkedHashMap<VRECategory, ArrayList<VRE>> toReturn = new LinkedHashMap<VRECategory, ArrayList<VRE>>();
        try {
            LinkedHashMap temp = null;
            if (this.getVREsFromSession() == null) {
                temp = this.getPortalSitesMappedToVRE();
                this.setVREsInSession(temp);
                _log.debug((Object)("getVREsByCategory looking in session not successful, asking to DB ... " + categoryName));
            } else {
                temp = this.getVREsFromSession();
                _log.debug((Object)("getVREsByCategory looking in session " + categoryName));
            }
            for (VRECategory cat : temp.keySet()) {
                if (!cat.getName().equals(categoryName)) continue;
                toReturn.put(cat, (ArrayList<VRE>)temp.get(cat));
                _log.debug((Object)("getVREsByCategory foudn match, returning " + cat.getName()));
                return toReturn;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return toReturn;
    }

    public List<String> getAllOrganisations() {
        ArrayList<String> toReturn = new ArrayList<String>();
        if (this.isWithinPortal()) {
            try {
                long currentSiteGroupId = this.getSiteFromServletRequest(this.getThreadLocalRequest()).getGroupId();
                Group site = GroupLocalServiceUtil.getGroup((long)currentSiteGroupId);
                String[] values = (String[])site.getExpandoBridge().getAttributeDefault("OrganisationName");
                for (int i = 0; i < values.length; ++i) {
                    toReturn.add(values[i]);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            return Arrays.asList("BlueBRIDGE", "iMarine");
        }
        return toReturn;
    }

    public ArrayList<String> getAllCategories() {
        ArrayList<String> toReturn = new ArrayList<String>();
        if (this.isWithinPortal()) {
            try {
                long currentSiteGroupId = this.getSiteFromServletRequest(this.getThreadLocalRequest()).getGroupId();
                List currentSiteVGroups = groupsManager.getVirtualGroups(currentSiteGroupId);
                for (VirtualGroup vg : currentSiteVGroups) {
                    toReturn.add(vg.getName());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            LinkedHashMap fakes = this.getFakePortalVREs();
            for (VRECategory cat : fakes.keySet()) {
                toReturn.add(cat.getName());
            }
        }
        return toReturn;
    }

    public LinkedHashMap<VRECategory, ArrayList<VRE>> getPortalSitesMappedToVRE() throws Exception {
        LinkedHashMap<VRECategory, ArrayList<VRE>> toReturn = new LinkedHashMap<VRECategory, ArrayList<VRE>>();
        long currentSiteGroupId = this.getSiteFromServletRequest(this.getThreadLocalRequest()).getGroupId();
        List currentSiteVGroups = groupsManager.getVirtualGroups(currentSiteGroupId);
        for (VirtualGroup vg : currentSiteVGroups) {
            ArrayList toCreate = new ArrayList();
            VRECategory cat = new VRECategory(1L, vg.getName(), vg.getDescription());
            toReturn.put(cat, toCreate);
        }
        GCubeGroup rootGroupVO = groupsManager.getRootVO();
        try {
            _log.debug((Object)("root: " + rootGroupVO.getGroupName()));
        }
        catch (NullPointerException e) {
            _log.error((Object)"Cannot find root organziation, please check gcube-data.properties file in $CATALINA_HOME/conf folder, unless your installing the Bundle");
            return toReturn;
        }
        PortalContext pContext = PortalContext.getConfiguration();
        List currUserGroups = new ArrayList();
        GCubeUser currUser = pContext.getCurrentUser(this.getThreadLocalRequest());
        _log.debug((Object)"before currUserGroups");
        if (currUser != null) {
            currUserGroups = groupsManager.listGroupsByUser(currUser.getUserId());
            _log.debug((Object)("currUserGroups size= " + currUserGroups.size()));
        }
        _log.debug((Object)"for each root sub organizations (VO): ");
        for (GCubeGroup vOrg : rootGroupVO.getChildren()) {
            _log.debug((Object)("vOrg: " + vOrg.getGroupName()));
            for (GCubeGroup vreSite : vOrg.getChildren()) {
                long vreID = vreSite.getGroupId();
                String vreName = vreSite.getGroupName();
                String vreDescription = vreSite.getDescription();
                long logoId = vreSite.getLogoId();
                String vreLogoURL = groupsManager.getGroupLogoURL(logoId);
                String groupName = groupsManager.getInfrastructureScope(vreSite.getGroupId());
                String friendlyURL = "/group" + vreSite.getFriendlyURL();
                _log.debug((Object)("vreName: " + vreName));
                List vreGroups = groupsManager.getVirtualGroups(vreID);
                for (VirtualGroup vreGroup : vreGroups) {
                    for (VRECategory vre : toReturn.keySet()) {
                        if (vre.getName().compareTo(vreGroup.getName()) != 0) continue;
                        ArrayList<VRE> toUpdate = toReturn.get(vre);
                        UserBelonging belongs = UserBelonging.NOT_BELONGING;
                        VRE toAdd = new VRE(vreID, vreName, vreDescription, vreLogoURL, groupName, friendlyURL, belongs, this.getVREMembershipType(vreSite.getMembershipType()));
                        if (GroupLocalServiceUtil.getGroup((long)vreID).getPublicLayoutsPageCount() > 0) {
                            String publicURL = "/web" + vreSite.getFriendlyURL();
                            toAdd.setPublicURL(publicURL);
                        }
                        if (currUser != null) {
                            _log.debug((Object)("//check if the user belongs to = " + vreSite.getGroupName()));
                            if (currUserGroups.contains(vreSite)) {
                                toAdd.setUserBelonging(UserBelonging.BELONGING);
                            } else if (JoinServiceImpl.checkPending((String)currUser.getUsername(), (long)vreSite.getGroupId())) {
                                toAdd.setUserBelonging(UserBelonging.PENDING);
                            }
                        }
                        toUpdate.add(toAdd);
                    }
                }
            }
        }
        for (VRECategory cat : toReturn.keySet()) {
            ArrayList<VRE> toSort = toReturn.get(cat);
            Collections.sort(toSort);
        }
        return toReturn;
    }

    private LinkedHashMap<VRECategory, ArrayList<VRE>> getFakePortalVREs() {
        LinkedHashMap<VRECategory, ArrayList<VRE>> toReturn = new LinkedHashMap<VRECategory, ArrayList<VRE>>();
        VRECategory devsecCategory = new VRECategory(1L, "Z_Development", "designed to apply Data Mining techniques to biological data. The algorithms are executed in a distributed fashion on the e-Infrastructure nodes or on local multi-core machines.");
        ArrayList<VRE> vres = new ArrayList<VRE>();
        vres.add(new VRE(0L, "BiodiversityLab", "<h2>BiodiversityLab</h2>The BiodiversityLab is a VRE designed to provide a collection of applications that allow scholars to perform complete experiments about single individuals or groups of marine species. The VRE allows to: <ul> <li> inspect species maps;<li> produce a species distribution map by means of either an expert system (AquaMaps) or a machine learning model (e.g. Neural Networks);<li> analyse species observation trends;<li> inspect species occurrence data;<li> inspect species descriptions and characteristics;<li> perform analysis of climatic changes and of their effects on species distribution;<li> produce GIS maps for geo-spatial datasets;<li> discover Taxa names;<li> cluster occurrence data;<li> estimate similarities among habitats.</ul>", "", "http://placehold.it/200x200", "/group/devsec", UserBelonging.NOT_BELONGING));
        vres.add(new VRE(0L, "Scalable Data", "<h2>Scalable Data Mining</h2>The Scalable Data Mining  is a VRE designed to apply Data Mining techniques to biological data. The algorithms are executed in a distributed fashion on the e-Infrastructure nodes or on local multi-core machines. Scalability is thus meant as distributed data processing but even as services dynamically provided to the users. The system is scalable in the number of users and in the size of the data to process. Statistical data processing can be applied to perform Niche Modelling or Ecological Modelling experiments. Other applications can use general purpose techniques like Bayesian models. Time series of observations can be managed as well, in order to classify trends, catch anomaly patterns and perform simulations. The idea under the distributed computation for data mining techniques is to overcome common limitations that can happen when using statistical algorithms: single individuals or groups of marine species. The VRE allows to: <ul> <li> inspect species maps;<li> produce a species distribution map by means of either an expert system (AquaMaps) or a machine learning model (e.g. Neural Networks);<li> analyse species observation trends;<li> inspect species occurrence data;<li> inspect species descriptions and characteristics;<li> perform analysis of climatic changes and of their effects on species distribution;<li> produce GIS maps for geo-spatial datasets;<li> discover Taxa names;<li> cluster occurrence data;<li> estimate similarities among habitats.</ul>", "", "http://placehold.it/200x200", "/group/devsec", UserBelonging.NOT_BELONGING));
        toReturn.put(devsecCategory, vres);
        devsecCategory = new VRECategory(2L, "Sailing", "Sailing prod desc");
        vres = new ArrayList();
        vres.add(new VRE(2L, "devmode", "devmode VRE description", "http://placehold.it/200x100", "https://placeholdit.imgix.net/~text?txtsize=19&txt=200%C3%97100&w=200&h=100", "/group/devmode", UserBelonging.NOT_BELONGING, VreMembershipType.PRIVATE));
        vres.add(new VRE(1L, "StrategicInvestmentAnalysis", "devVRE VRE description", "", "https://placeholdit.imgix.net/~text?txtsize=19&txt=200%C3%97100&w=200&h=100", "/group/devVRE", UserBelonging.NOT_BELONGING, VreMembershipType.OPEN));
        vres.add(new VRE(2L, "devmode2", "devmode VRE description", "http://placehold.it/200x100", "", "/group/devmode", UserBelonging.NOT_BELONGING, VreMembershipType.OPEN));
        vres.add(new VRE(1L, "devVR3E", "devVRE VRE description", "http://placehold.it/200x200", "aaaa", "/group/devVRE", UserBelonging.NOT_BELONGING, VreMembershipType.PRIVATE));
        vres.add(new VRE(2L, "devmode3", "devmode VRE description", "http://placehold.it/200x200", "", "/group/devmode", UserBelonging.NOT_BELONGING, VreMembershipType.PRIVATE));
        vres.add(new VRE(1L, "devVRE4", "devVRE VRE description", "", "http://placehold.it/200x200", "/group/devVRE", UserBelonging.NOT_BELONGING, VreMembershipType.PRIVATE));
        vres.add(new VRE(2L, "devmode4", "devmode VRE description", "", "http://placehold.it/200x200", "/group/devmode", UserBelonging.NOT_BELONGING, VreMembershipType.PRIVATE));
        vres.add(new VRE(1L, "devVRE5", "devVRE VRE description", "", "http://placehold.it/200x200", "/group/devVRE", UserBelonging.NOT_BELONGING, VreMembershipType.PRIVATE));
        vres.add(new VRE(2L, "devmode5", "devmode VRE description", "", "http://placehold.it/200x200", "/group/devmode", UserBelonging.NOT_BELONGING, VreMembershipType.PRIVATE));
        vres.add(new VRE(1L, "devVRE6", "devVRE VRE description", "", "http://placehold.it/200x200", "/group/devVRE", UserBelonging.NOT_BELONGING, VreMembershipType.PRIVATE));
        vres.add(new VRE(2L, "devmode6", "devmode VRE description", "", "http://placehold.it/200x200", "/group/devmode", UserBelonging.NOT_BELONGING, VreMembershipType.PRIVATE));
        vres.add(new VRE(1L, "devVRE7", "devVRE VRE description", "", "http://placehold.it/200x200", "/group/devVRE", UserBelonging.NOT_BELONGING, VreMembershipType.PRIVATE));
        vres.add(new VRE(2L, "devmod76", "devmode VRE description", "", "http://placehold.it/200x200", "/group/devmode", UserBelonging.NOT_BELONGING));
        toReturn.put(devsecCategory, vres);
        this.setVREsInSession(toReturn);
        return toReturn;
    }

    public VRE getSelectedVRE(Long groupId) {
        _log.debug((Object)("*getting Selected Research Environment from referral, site id = " + groupId));
        VRE toReturn = null;
        try {
            LiferayGroupManager gm = new LiferayGroupManager();
            GCubeGroup selectedVRE = gm.getGroup(groupId.longValue());
            String vreName = selectedVRE.getGroupName();
            String vreDescription = selectedVRE.getDescription();
            long logoId = selectedVRE.getLogoId();
            String vreLogoURL = gm.getGroupLogoURL(logoId);
            String infraScope = gm.getInfrastructureScope(selectedVRE.getGroupId());
            String friendlyURL = "/group" + selectedVRE.getFriendlyURL();
            GCubeUser currUser = PortalContext.getConfiguration().getCurrentUser(this.getThreadLocalRequest());
            UserBelonging belongEnum = UserBelonging.NOT_BELONGING;
            if (gm.listGroupsByUser(currUser.getUserId()).contains(selectedVRE)) {
                belongEnum = UserBelonging.BELONGING;
            } else if (JoinServiceImpl.checkPending((String)currUser.getUsername(), (long)selectedVRE.getGroupId())) {
                belongEnum = UserBelonging.PENDING;
            }
            toReturn = new VRE(groupId.longValue(), vreName, vreDescription, vreLogoURL, infraScope, friendlyURL, belongEnum, this.getVREMembershipType(selectedVRE.getMembershipType()));
        }
        catch (Exception e) {
            _log.error((Object)("Something wrong happened while trying to getSite by id, probably the group id is wrong. " + e.getMessage()));
        }
        return toReturn;
    }

    private VreMembershipType getVREMembershipType(GroupMembershipType type) {
        switch (1.$SwitchMap$org$gcube$vomanagement$usermanagement$model$GroupMembershipType[type.ordinal()]) {
            case 1: {
                return VreMembershipType.RESTRICTED;
            }
            case 2: {
                return VreMembershipType.OPEN;
            }
        }
        return VreMembershipType.PRIVATE;
    }

    private static boolean checkPending(String screenName, long groupId) throws UserManagementSystemException, GroupRetrievalFault, UserRetrievalFault {
        _log.debug((Object)("checkPending of " + screenName + " to groupId=" + groupId));
        LiferayUserManager um = new LiferayUserManager();
        List requests = um.listMembershipRequestsByGroup(groupId);
        for (GCubeMembershipRequest r : requests) {
            if (r.getStatus() != MembershipRequestStatus.REQUEST || r.getRequestingUser().getUsername().compareTo(screenName) != 0) continue;
            _log.debug((Object)("checkPending found request" + screenName));
            return true;
        }
        _log.debug((Object)("checkPending did not find request" + screenName));
        return false;
    }

    public void addMembershipRequest(VRE theVRE, String optionalMessage) {
        String scope = theVRE.getinfraScope();
        String username = PortalContext.getConfiguration().getCurrentUser(this.getThreadLocalRequest()).getUsername();
        if (optionalMessage == null || optionalMessage.compareTo("") == 0) {
            optionalMessage = "none";
        }
        try {
            CacheRegistryUtil.clear();
            long groupId = theVRE.getId();
            _log.debug((Object)"Look if a request exists already");
            List userGroups = new LiferayGroupManager().listGroupsByUser(new LiferayUserManager().getUserId(username));
            for (GCubeGroup g : userGroups) {
                if (g.getGroupId() != groupId) continue;
                _log.warn((Object)("User already belongs to " + scope + " SKIP addMembershipRequest"));
                return;
            }
            CacheRegistryUtil.clear();
            if (JoinServiceImpl.checkPending((String)username, (long)groupId)) {
                _log.warn((Object)("User already asked for " + scope + " REQUEST IS IN PENDING - SKIP addMembershipRequest"));
                return;
            }
            _log.debug((Object)("Request does not exist, addMembershipRequest for user " + username));
            LoginServiceUtil.addMembershipRequest((String)username, (String)scope, (String)optionalMessage, (HttpServletRequest)this.getThreadLocalRequest());
            if (this.getTermsOfUse(groupId) != null) {
                new TermsOfUseImpl().setAcceptedToU(username, groupId);
                _log.info((Object)(username + "has requested and acceptedToU OK for " + scope));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getPortalUrl() throws PortalException, SystemException {
        return PortalUtil.getPortalURL((HttpServletRequest)this.getThreadLocalRequest());
    }

    public boolean registerUser(String scope, long groupId, boolean isInvitation) {
        LiferayUserManager um = new LiferayUserManager();
        try {
            GCubeUser currUser = PortalContext.getConfiguration().getCurrentUser(this.getThreadLocalRequest());
            _log.debug((Object)("registerUser " + currUser.getUsername() + " to " + scope));
            LiferayGroupManager gm = new LiferayGroupManager();
            um.requestMembership(currUser.getUserId(), gm.getGroupIdFromInfrastructureScope(scope), "Automatic Request at " + new Date());
            _log.debug((Object)"fakeRequest sent");
            String replierUsername = LiferayUserManager.getAdmin().getScreenName();
            _log.trace((Object)"Sleep 1 second ...");
            Thread.sleep(1000L);
            um.acceptMembershipRequest(currUser.getUserId(), groupId, true, replierUsername, "Automatic acceptance request at " + new Date());
            _log.info((Object)"fakeRequest accepted");
            if (isInvitation) {
                JoinServiceImpl.initStore();
                String inviteId = store.isExistingInvite(scope, currUser.getEmail());
                if (inviteId != null) {
                    Invite invite = store.readInvite(inviteId);
                    store.setInviteStatus(scope, currUser.getEmail(), InviteStatus.ACCEPTED);
                    LoginServiceUtil.notifyUserAcceptedInvite((String)currUser.getUsername(), (String)scope, (Invite)invite, (HttpServletRequest)this.getThreadLocalRequest());
                }
            } else {
                LoginServiceUtil.notifyUserSelfRegistration((String)currUser.getUsername(), (String)scope, (HttpServletRequest)this.getThreadLocalRequest());
                _log.info((Object)"notifyUserSelfRegistration sent");
            }
            if (this.getTermsOfUse(groupId) != null) {
                new TermsOfUseImpl().setAcceptedToU(currUser.getUsername(), groupId);
                _log.info((Object)("hasAcceptedToU OK for " + currUser.getUsername()));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public static synchronized DatabookStore initStore() {
        if (store == null) {
            store = new DBCassandraAstyanaxImpl();
        }
        return store;
    }

    public String isExistingInvite(long groupId) {
        _log.debug((Object)"initiating Store");
        JoinServiceImpl.initStore();
        _log.debug((Object)"initStore OK");
        String email = PortalContext.getConfiguration().getCurrentUser(this.getThreadLocalRequest()).getEmail();
        String infraScope = null;
        try {
            infraScope = new LiferayGroupManager().getInfrastructureScope(groupId);
        }
        catch (GroupRetrievalFault | UserManagementSystemException e) {
            e.printStackTrace();
        }
        _log.debug((Object)("checking if invite exists for " + email + " on " + infraScope));
        return store.isExistingInvite(infraScope, email);
    }

    private Group getSiteFromServletRequest(HttpServletRequest request) throws PortalException, SystemException {
        String serverName = request.getServerName();
        _log.debug((Object)("currentHost is " + serverName));
        Group site = null;
        List vHosts = VirtualHostLocalServiceUtil.getVirtualHosts((int)0, (int)VirtualHostLocalServiceUtil.getVirtualHostsCount());
        for (VirtualHost virtualHost : vHosts) {
            _log.debug((Object)("Found  " + virtualHost.getHostname()));
            if (virtualHost.getHostname().compareTo("localhost") == 0 || virtualHost.getLayoutSetId() == 0L || virtualHost.getHostname().compareTo(serverName) != 0) continue;
            long layoutSetId = virtualHost.getLayoutSetId();
            site = LayoutSetLocalServiceUtil.getLayoutSet((long)layoutSetId).getGroup();
            _log.debug((Object)("Found match! Your site is " + site.getName()));
            return site;
        }
        return null;
    }

    private LinkedHashMap<VRECategory, ArrayList<VRE>> getVREsFromSession() {
        if (this.getThreadLocalRequest().getSession().getAttribute("ALLVRES_SESSION") == null) {
            return null;
        }
        return (LinkedHashMap)this.getThreadLocalRequest().getSession().getAttribute("ALLVRES_SESSION");
    }

    private void setVREsInSession(LinkedHashMap<VRECategory, ArrayList<VRE>> allVREs) {
        this.getThreadLocalRequest().getSession().setAttribute("ALLVRES_SESSION", allVREs);
    }
}

