/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.joinvre.server;

import com.google.gwt.user.server.rpc.RemoteServiceServlet;
import com.liferay.portal.kernel.bean.BeanLocatorException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.service.UserLocalServiceUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.gcube.application.framework.core.session.ASLSession;
import org.gcube.application.framework.core.session.SessionManager;
import org.gcube.common.portal.CustomAttributeKeys;
import org.gcube.portal.custom.communitymanager.impl.GCubeSiteManagerImpl;
import org.gcube.portlets.user.joinvre.client.JoinService;
import org.gcube.portlets.user.joinvre.shared.UserBelonging;
import org.gcube.portlets.user.joinvre.shared.VRE;
import org.gcube.portlets.user.joinvre.shared.VRECategory;
import org.gcube.portlets.user.joinvre.shared.VRECustomAttributes;
import org.gcube.vomanagement.usermanagement.impl.LiferayGroupManager;
import org.gcube.vomanagement.usermanagement.model.GCubeGroup;

public class JoinServiceImpl
extends RemoteServiceServlet
implements JoinService {
    private static Log _log = LogFactoryUtil.getLog(JoinServiceImpl.class);
    private static final String REQUEST_BASED_GROUP = "Requestbasedgroup";
    private static final String IS_EXTERNAL = "Isexternal";
    private static final String URL_IF_EXTERNAL = "Url";

    private ASLSession getASLSession() {
        String sessionID = this.getThreadLocalRequest().getSession().getId();
        String user = (String)this.getThreadLocalRequest().getSession().getAttribute("username");
        if (user == null) {
            _log.warn((Object)"USER IS NULL setting test.user and Running OUTSIDE PORTAL");
            user = this.getDevelopmentUser();
            SessionManager.getInstance().getASLSession(sessionID, user).setScope("/gcube");
        }
        return SessionManager.getInstance().getASLSession(sessionID, user);
    }

    public String getDevelopmentUser() {
        String user = "test.user";
        return user;
    }

    private boolean isWithinPortal() {
        try {
            UserLocalServiceUtil.getService();
            return true;
        }
        catch (BeanLocatorException ex) {
            _log.trace((Object)"Development Mode ON");
            return false;
        }
    }

    public LinkedHashMap<VRECategory, ArrayList<VRE>> getVREs() {
        LinkedHashMap toReturn = new LinkedHashMap();
        try {
            if (this.isWithinPortal()) {
                toReturn = this.getPortalOrganizationMappedToVRE();
            } else {
                VRECategory devsecCategory = new VRECategory(1L, "Z_Development", "designed to apply Data Mining techniques to biological data. The algorithms are executed in a distributed fashion on the e-Infrastructure nodes or on local multi-core machines.");
                ArrayList<VRE> vres = new ArrayList<VRE>();
                vres.add(new VRE(0L, "BiodiversityLab", "<h2>BiodiversityLab</h2>The BiodiversityLab is a VRE designed to provide a collection of applications that allow scholars to perform complete experiments about single individuals or groups of marine species. The VRE allows to: <ul> <li> inspect species maps;<li> produce a species distribution map by means of either an expert system (AquaMaps) or a machine learning model (e.g. Neural Networks);<li> analyse species observation trends;<li> inspect species occurrence data;<li> inspect species descriptions and characteristics;<li> perform analysis of climatic changes and of their effects on species distribution;<li> produce GIS maps for geo-spatial datasets;<li> discover Taxa names;<li> cluster occurrence data;<li> estimate similarities among habitats.</ul>", "", "http://placehold.it/200x200", "/group/devsec", UserBelonging.NOT_BELONGING, false));
                vres.add(new VRE(0L, "Scalable Data", "<h2>Scalable Data Mining</h2>The Scalable Data Mining  is a VRE designed to apply Data Mining techniques to biological data. The algorithms are executed in a distributed fashion on the e-Infrastructure nodes or on local multi-core machines. Scalability is thus meant as distributed data processing but even as services dynamically provided to the users. The system is scalable in the number of users and in the size of the data to process. Statistical data processing can be applied to perform Niche Modelling or Ecological Modelling experiments. Other applications can use general purpose techniques like Bayesian models. Time series of observations can be managed as well, in order to classify trends, catch anomaly patterns and perform simulations. The idea under the distributed computation for data mining techniques is to overcome common limitations that can happen when using statistical algorithms: single individuals or groups of marine species. The VRE allows to: <ul> <li> inspect species maps;<li> produce a species distribution map by means of either an expert system (AquaMaps) or a machine learning model (e.g. Neural Networks);<li> analyse species observation trends;<li> inspect species occurrence data;<li> inspect species descriptions and characteristics;<li> perform analysis of climatic changes and of their effects on species distribution;<li> produce GIS maps for geo-spatial datasets;<li> discover Taxa names;<li> cluster occurrence data;<li> estimate similarities among habitats.</ul>", "", "http://placehold.it/200x200", "/group/devsec", UserBelonging.NOT_BELONGING, true));
                toReturn.put(devsecCategory, vres);
                devsecCategory = new VRECategory(2L, "Sailing", "Sailing prod desc");
                vres = new ArrayList();
                vres.add(new VRE(1L, "PerformanceEvaluationInAquaculture", "devVRE VRE description", "http://placehold.it/200x100", "http://placehold.it/200x100", "/group/devVRE", UserBelonging.NOT_BELONGING, false, true, "http://i-marine.d4science.org"));
                vres.add(new VRE(2L, "devmode", "devmode VRE description", "http://placehold.it/200x100", "https://placeholdit.imgix.net/~text?txtsize=19&txt=200%C3%97100&w=200&h=100", "/group/devmode", UserBelonging.NOT_BELONGING, true));
                vres.add(new VRE(1L, "StrategicInvestmentAnalysis", "devVRE VRE description", "", "https://placeholdit.imgix.net/~text?txtsize=19&txt=200%C3%97100&w=200&h=100", "/group/devVRE", UserBelonging.NOT_BELONGING, false));
                vres.add(new VRE(2L, "devmode2", "devmode VRE description", "http://placehold.it/200x100", "", "/group/devmode", UserBelonging.NOT_BELONGING, true));
                vres.add(new VRE(1L, "devVR3E", "devVRE VRE description", "http://placehold.it/200x200", "aaaa", "/group/devVRE", UserBelonging.NOT_BELONGING, false));
                vres.add(new VRE(2L, "devmode3", "devmode VRE description", "http://placehold.it/200x200", "", "/group/devmode", UserBelonging.NOT_BELONGING, true));
                vres.add(new VRE(1L, "devVRE4", "devVRE VRE description", "", "http://placehold.it/200x200", "/group/devVRE", UserBelonging.NOT_BELONGING, false));
                vres.add(new VRE(2L, "devmode4", "devmode VRE description", "", "http://placehold.it/200x200", "/group/devmode", UserBelonging.NOT_BELONGING, true));
                vres.add(new VRE(1L, "devVRE5", "devVRE VRE description", "", "http://placehold.it/200x200", "/group/devVRE", UserBelonging.NOT_BELONGING, false));
                vres.add(new VRE(2L, "devmode5", "devmode VRE description", "", "http://placehold.it/200x200", "/group/devmode", UserBelonging.NOT_BELONGING, true));
                vres.add(new VRE(1L, "devVRE6", "devVRE VRE description", "", "http://placehold.it/200x200", "/group/devVRE", UserBelonging.NOT_BELONGING, false));
                vres.add(new VRE(2L, "devmode6", "devmode VRE description", "", "http://placehold.it/200x200", "/group/devmode", UserBelonging.NOT_BELONGING, true));
                vres.add(new VRE(1L, "devVRE7", "devVRE VRE description", "", "http://placehold.it/200x200", "/group/devVRE", UserBelonging.NOT_BELONGING, false));
                vres.add(new VRE(2L, "devmod76", "devmode VRE description", "", "http://placehold.it/200x200", "/group/devmode", UserBelonging.NOT_BELONGING, true));
                toReturn.put(devsecCategory, vres);
            }
        }
        catch (Exception e) {
            _log.error((Object)"Error getting VREs", (Throwable)e);
        }
        return toReturn;
    }

    private String getPortalBasicUrl() {
        HttpServletRequest request = this.getThreadLocalRequest();
        String protocol = request.isSecure() ? "https://" : "http://";
        String port = request.getServerPort() == 80 ? "" : String.format(":%d", request.getServerPort());
        String portalBasicUrl = String.format("%s%s%s", protocol, request.getServerName(), port);
        _log.debug((Object)String.format("getPortalBasicUrl : %s", portalBasicUrl));
        return portalBasicUrl;
    }

    public VRECustomAttributes getVRECustomAttr(GCubeGroup group) throws PortalException, SystemException {
        VRECustomAttributes toReturn = new VRECustomAttributes();
        try {
            LiferayGroupManager gm = new LiferayGroupManager();
            toReturn.setUponRequest(group.isRequestBasedGroup());
            Boolean attributeValue = (Boolean)gm.readCustomAttr(group.getGroupId(), CustomAttributeKeys.IS_EXTERNAL.getKeyName());
            toReturn.setExternal(attributeValue.booleanValue());
            if (attributeValue.booleanValue()) {
                String url = (String)((Object)gm.readCustomAttr(group.getGroupId(), CustomAttributeKeys.URL.getKeyName()));
                toReturn.setUrlIfAny(url);
            }
        }
        catch (Exception e) {
            _log.error((Object)("Something went wrong when trying to read VRE Custom Attr, " + e));
            return toReturn;
        }
        _log.trace((Object)("RETURNING VRECustomAttributes:\n" + toReturn.toString()));
        return toReturn;
    }

    public LinkedHashMap<VRECategory, ArrayList<VRE>> getPortalOrganizationMappedToVRE() throws Exception {
        LinkedHashMap<VRECategory, ArrayList<VRE>> toReturn = new LinkedHashMap<VRECategory, ArrayList<VRE>>();
        List virtualGroups = GCubeSiteManagerImpl.getVirtualGroups();
        for (String vg : virtualGroups) {
            String[] splits = vg.split("\\|");
            String gName = splits[0];
            String gDescription = splits[1];
            ArrayList toCreate = new ArrayList();
            VRECategory cat = new VRECategory(1L, gName, gDescription);
            toReturn.put(cat, toCreate);
        }
        LiferayGroupManager gm = new LiferayGroupManager();
        GCubeGroup rootGroupVO = gm.getRootVO();
        try {
            _log.debug((Object)("root: " + rootGroupVO.getGroupName()));
        }
        catch (NullPointerException e) {
            _log.error((Object)"Cannot find root organziation, please check gcube-data.properties file in $CATALINA_HOME/conf folder, unless your installing the Bundle");
            return toReturn;
        }
        for (GCubeGroup vOrg : rootGroupVO.getChildren()) {
            for (GCubeGroup vreOrganization : vOrg.getChildren()) {
                long vreID = vreOrganization.getGroupId();
                String vreName = vreOrganization.getName();
                String vreDescription = vreOrganization.getDescription();
                long logoId = vreOrganization.getLogoId();
                String vreLogoURL = "/image/layout_set_logo?img_id=" + logoId;
                String groupName = gm.getInfrastructureScope(vreOrganization.getGroupId());
                String friendlyURL = "/group" + vreOrganization.getFriendlyURL();
                VRECustomAttributes attrs = this.getVRECustomAttr(vreOrganization);
                boolean requireAccessGrant = attrs.isUponRequest();
                boolean isExternal = attrs.isExternal();
                String urlIfAny = attrs.getUrlIfAny();
                String catName = (String)((Object)gm.readCustomAttr(vreOrganization.getGroupId(), CustomAttributeKeys.VIRTUAL_GROUP.getKeyName()));
                String[] splits = catName.split("\\|");
                catName = splits[0];
                VRECategory toLookFor = null;
                for (VRECategory vre : toReturn.keySet()) {
                    if (vre.getName().compareTo(catName) != 0) continue;
                    toLookFor = vre;
                }
                if (toLookFor == null) continue;
                ArrayList<VRE> toUpdate = toReturn.get(toLookFor);
                toUpdate.add(new VRE(vreID, vreName, vreDescription, vreLogoURL, groupName, friendlyURL, UserBelonging.NOT_BELONGING, requireAccessGrant, isExternal, urlIfAny));
            }
        }
        for (VRECategory cat : toReturn.keySet()) {
            ArrayList<VRE> toSort = toReturn.get(cat);
            Collections.sort(toSort);
        }
        return toReturn;
    }

    public Boolean joinVRE(Long vreID) {
        return new Boolean(true);
    }
}

