/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.joinvre.client.responsive;

import com.github.gwtbootstrap.client.ui.Button;
import com.github.gwtbootstrap.client.ui.Heading;
import com.github.gwtbootstrap.client.ui.Image;
import com.github.gwtbootstrap.client.ui.constants.ButtonType;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Widget;
import org.gcube.portlets.user.joinvre.client.JoinService;
import org.gcube.portlets.user.joinvre.client.JoinServiceAsync;
import org.gcube.portlets.user.joinvre.client.responsive.VreThumbnail;
import org.gcube.portlets.user.joinvre.client.ui.InfoPanel;
import org.gcube.portlets.user.joinvre.shared.VRE;

public class VreThumbnail
extends Composite {
    private static VreThumbnailUiBinder uiBinder = (VreThumbnailUiBinder)GWT.create(VreThumbnailUiBinder.class);
    private final JoinServiceAsync joinService = (JoinServiceAsync)GWT.create(JoinService.class);
    @UiField
    Heading vreName;
    @UiField
    Image vreImage;
    @UiField
    Button joinButton;
    @UiField
    Button vreInfoButton;
    private VRE myVre;

    public VreThumbnail(VRE vre) {
        this.initWidget((Widget)uiBinder.createAndBindUi((Object)this));
        this.myVre = vre;
        String name = vre.getName();
        if (name.length() > 22) {
            name = String.valueOf(name.substring(0, 17)) + "...";
        }
        this.vreName.setText(name);
        if (vre.isUponRequest()) {
            this.joinButton.setType(ButtonType.DEFAULT);
            this.joinButton.setText("Request access");
        } else {
            this.joinButton.setType(ButtonType.PRIMARY);
            this.joinButton.setText("Enter this VRE");
        }
        this.vreImage.setUrl(vre.getImageURL());
        this.vreImage.setWidth("180px");
    }

    @UiHandler(value={"joinButton"})
    void handleClick(ClickEvent e) {
        this.joinService.joinVRE(Long.valueOf(this.myVre.getId()), (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    @UiHandler(value={"vreInfoButton"})
    void infoClick(ClickEvent e) {
        InfoPanel modal = new InfoPanel(this.myVre);
        modal.show();
    }

    static /* synthetic */ VRE access$0(VreThumbnail vreThumbnail) {
        return vreThumbnail.myVre;
    }
}

