/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.homelibrary.unittest.workspace.test;

import org.gcube.portlets.user.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.portlets.user.homelibrary.home.workspace.WorkspaceFolder;
import org.gcube.portlets.user.homelibrary.home.workspace.WorkspaceItem;
import org.gcube.portlets.user.homelibrary.home.workspace.WorkspaceItemType;
import org.gcube.portlets.user.homelibrary.home.workspace.exceptions.InsufficientPrivilegesException;
import org.gcube.portlets.user.homelibrary.home.workspace.exceptions.ItemAlreadyExistException;
import org.gcube.portlets.user.homelibrary.home.workspace.exceptions.ItemNotFoundException;
import org.gcube.portlets.user.homelibrary.home.workspace.exceptions.WorkspaceFolderAlreadyExistException;
import org.gcube.portlets.user.homelibrary.home.workspace.exceptions.WorkspaceFolderNotFoundException;
import org.gcube.portlets.user.homelibrary.home.workspace.exceptions.WrongDestinationException;
import org.gcube.portlets.user.homelibrary.home.workspace.exceptions.WrongParentTypeException;
import org.gcube.portlets.user.homelibrary.unittest.workspace.AbstractWorkspaceTest;
import org.gcube.portlets.user.homelibrary.unittest.workspace.UnitTestUtil;
import org.gcube.portlets.user.homelibrary.unittest.workspace.WorkspaceFactory;
import org.junit.Assert;
import org.junit.Test;

public class WorkspaceTestFolderMethods
extends AbstractWorkspaceTest {
    public WorkspaceTestFolderMethods(WorkspaceFactory factory) {
        super(factory);
    }

    @Test
    public final void testCreateWorkspaceStringStringString() throws InternalErrorException, WorkspaceFolderAlreadyExistException, ItemNotFoundException, InsufficientPrivilegesException, ItemAlreadyExistException, WrongDestinationException, WorkspaceFolderNotFoundException {
        WorkspaceFolder root = this.ownerWorkspace.getRoot();
        String expectedName = "TestFolder100";
        String expectedDescription = "TestDescription";
        WorkspaceFolder folder = this.ownerWorkspace.createFolder(expectedName, expectedDescription, root.getId());
        UnitTestUtil.testItemCreation((WorkspaceItem)folder, (WorkspaceItem)root, expectedName, expectedDescription, WorkspaceItemType.FOLDER);
    }

    @Test(expected=IllegalArgumentException.class)
    public final void testCreateWorkspaceStringStringStringIllegalCharInNameArgument() throws InternalErrorException, WorkspaceFolderAlreadyExistException, ItemNotFoundException, InsufficientPrivilegesException, ItemAlreadyExistException, WrongDestinationException, WorkspaceFolderNotFoundException {
        WorkspaceFolder root = this.ownerWorkspace.getRoot();
        String expectedName = "Test" + this.ownerWorkspace.getPathSeparator() + "Workspace";
        String expectedDescription = "TestDescription";
        this.ownerWorkspace.createFolder(expectedName, expectedDescription, root.getId());
    }

    @Test(expected=IllegalArgumentException.class)
    public final void testCreateWorkspaceStringStringStringNullDescriptionArgument() throws InternalErrorException, WorkspaceFolderAlreadyExistException, ItemNotFoundException, InsufficientPrivilegesException, ItemAlreadyExistException, WrongDestinationException, WorkspaceFolderNotFoundException {
        WorkspaceFolder root = this.ownerWorkspace.getRoot();
        String expectedName = "TestFolder101";
        String expectedDescription = null;
        this.ownerWorkspace.createFolder(expectedName, expectedDescription, root.getId());
    }

    @Test(expected=IllegalArgumentException.class)
    public final void testCreateWorkspaceStringStringStringNullNameArgument() throws InternalErrorException, WorkspaceFolderAlreadyExistException, ItemNotFoundException, InsufficientPrivilegesException, ItemAlreadyExistException, WrongDestinationException, WorkspaceFolderNotFoundException {
        WorkspaceFolder root = this.ownerWorkspace.getRoot();
        String expectedName = null;
        String expectedDescription = "TestDescription";
        this.ownerWorkspace.createFolder(expectedName, expectedDescription, root.getId());
    }

    @Test(expected=WorkspaceFolderNotFoundException.class)
    public final void testCreateWorkspaceStringStringStringWrongDestinationFolderId() throws InternalErrorException, WorkspaceFolderAlreadyExistException, ItemNotFoundException, InsufficientPrivilegesException, ItemAlreadyExistException, WrongDestinationException, WorkspaceFolderNotFoundException {
        String expectedName = "TestFolder102";
        String expectedDescription = "TestDescription";
        this.ownerWorkspace.createFolder(expectedName, expectedDescription, "");
    }

    @Test
    public final void testRemoveChildSubTree() throws InternalErrorException, InsufficientPrivilegesException, ItemAlreadyExistException, ItemNotFoundException, WrongParentTypeException {
        WorkspaceFolder root = this.ownerWorkspace.getRoot();
        WorkspaceFolder subTree = UnitTestUtil.getFolderTree(root, "TestFolderTree6");
        this.ownerWorkspace.removeChild(subTree.getId(), root.getId());
        UnitTestUtil.checkSubTreeExistence(this.ownerWorkspace, (WorkspaceItem)subTree);
    }

    @Test(expected=IllegalArgumentException.class)
    public final void testRemoveChildNullFolderId() throws ItemNotFoundException, InternalErrorException, InsufficientPrivilegesException, WrongParentTypeException, ItemAlreadyExistException {
        WorkspaceFolder root = this.ownerWorkspace.getRoot();
        WorkspaceFolder folder = root.createFolder("TestFolder103", "A test Folder");
        this.ownerWorkspace.removeChild(folder.getId(), null);
    }

    @Test(expected=IllegalArgumentException.class)
    public final void testRemoveChildNullItemId() throws ItemNotFoundException, InternalErrorException, InsufficientPrivilegesException, WrongParentTypeException {
        WorkspaceFolder root = this.ownerWorkspace.getRoot();
        this.ownerWorkspace.removeChild(null, root.getId());
    }

    @Test
    public final void testRemoveChildWorkspace() throws InternalErrorException, InsufficientPrivilegesException, ItemAlreadyExistException, ItemNotFoundException, WrongParentTypeException {
        WorkspaceFolder root = this.ownerWorkspace.getRoot();
        WorkspaceFolder folder = root.createFolder("TestFolder104", "A test Folder");
        this.ownerWorkspace.removeChild(folder.getId(), root.getId());
        Assert.assertEquals((String)"Children list is not empty", (long)0L, (long)root.getChildren().size());
        Assert.assertFalse((String)"Found removed item", (boolean)this.ownerWorkspace.exists(folder.getId()));
    }

    @Test(expected=ItemNotFoundException.class)
    public final void testRemoveChildWrongFolderId() throws ItemNotFoundException, InternalErrorException, InsufficientPrivilegesException, WrongParentTypeException, ItemAlreadyExistException {
        WorkspaceFolder root = this.ownerWorkspace.getRoot();
        WorkspaceFolder folder = root.createFolder("TestFolder105", "A test Folder");
        this.ownerWorkspace.removeChild(folder.getId(), "");
    }

    @Test(expected=ItemNotFoundException.class)
    public final void testRemoveChildWrongItemId() throws ItemNotFoundException, InternalErrorException, InsufficientPrivilegesException, WrongParentTypeException {
        WorkspaceFolder root = this.ownerWorkspace.getRoot();
        this.ownerWorkspace.removeChild("", root.getId());
    }
}

