/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.homelibrary.examples;

import java.io.File;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.portlets.user.homelibrary.home.Home;
import org.gcube.portlets.user.homelibrary.home.HomeLibrary;
import org.gcube.portlets.user.homelibrary.home.HomeManager;
import org.gcube.portlets.user.homelibrary.home.HomeManagerFactory;
import org.gcube.portlets.user.homelibrary.home.User;
import org.gcube.portlets.user.homelibrary.home.exceptions.HomeNotFoundException;
import org.gcube.portlets.user.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.portlets.user.homelibrary.home.workspace.Workspace;
import org.gcube.portlets.user.homelibrary.home.workspace.exceptions.WorkspaceFolderNotFoundException;
import org.gcube.portlets.user.homelibrary.util.Util;

public class ExamplesUtil {
    public static final String EXAMPLES_PERSISTENCE_ROOT = String.valueOf(System.getProperty("java.io.tmpdir")) + File.separator + "home_library_examples";

    public static Workspace createWorkspace() throws GCUBEScope.MalformedScopeExpressionException, InternalErrorException, HomeNotFoundException, WorkspaceFolderNotFoundException {
        return ExamplesUtil.createWorkspace("/test/testscope");
    }

    public static Workspace createWorkspace(String scope) throws GCUBEScope.MalformedScopeExpressionException, InternalErrorException, HomeNotFoundException, WorkspaceFolderNotFoundException {
        return ExamplesUtil.createWorkspace(scope, "user.test");
    }

    public static Workspace createWorkspace(String scope, String user) throws GCUBEScope.MalformedScopeExpressionException, InternalErrorException, HomeNotFoundException, WorkspaceFolderNotFoundException {
        HomeManagerFactory factory = ExamplesUtil.getHomeManagerFactory();
        return ExamplesUtil.createWorkspace(factory, scope, user);
    }

    public static Home createHome(String scope, String user) throws GCUBEScope.MalformedScopeExpressionException, InternalErrorException, HomeNotFoundException, WorkspaceFolderNotFoundException {
        HomeManagerFactory factory = ExamplesUtil.getHomeManagerFactory();
        return ExamplesUtil.createHome(factory, scope, user);
    }

    public static Workspace createWorkspace(HomeManagerFactory factory, String scope, String user) throws GCUBEScope.MalformedScopeExpressionException, InternalErrorException, HomeNotFoundException, WorkspaceFolderNotFoundException {
        Home home = ExamplesUtil.createHome(factory, scope, user);
        return home.getWorkspace();
    }

    public static Home createHome(HomeManagerFactory factory, String scope, String user) throws GCUBEScope.MalformedScopeExpressionException, InternalErrorException, HomeNotFoundException, WorkspaceFolderNotFoundException {
        HomeManager manager = factory.getHomeManager();
        User testUser = manager.getUser(user);
        Home home = manager.getHome(testUser, GCUBEScope.getScope((String)scope));
        return home;
    }

    public static HomeManagerFactory getHomeManagerFactory(String persistenceRoot) throws InternalErrorException {
        return HomeLibrary.getHomeManagerFactory((String)persistenceRoot);
    }

    public static HomeManagerFactory getHomeManagerFactory() throws InternalErrorException {
        return ExamplesUtil.getHomeManagerFactory(false);
    }

    public static HomeManagerFactory getHomeManagerFactory(boolean clean) throws InternalErrorException {
        File homeLibraryExampleDir = new File(EXAMPLES_PERSISTENCE_ROOT);
        if (clean && homeLibraryExampleDir.exists()) {
            Util.cleanDir((File)homeLibraryExampleDir);
        }
        homeLibraryExampleDir.mkdir();
        return ExamplesUtil.getHomeManagerFactory(EXAMPLES_PERSISTENCE_ROOT);
    }
}

