/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.homelibrary.testdata.manager;

import com.thoughtworks.xstream.XStream;
import java.io.InputStream;
import java.util.LinkedList;
import org.gcube.portlets.user.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.portlets.user.homelibrary.home.workspace.WorkspaceFolder;
import org.gcube.portlets.user.homelibrary.home.workspace.exceptions.InsufficientPrivilegesException;
import org.gcube.portlets.user.homelibrary.home.workspace.exceptions.ItemAlreadyExistException;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.items.Report;
import org.gcube.portlets.user.homelibrary.testdata.AbstractDataManager;
import org.gcube.portlets.user.homelibrary.testdata.TestDataFactory;
import org.gcube.portlets.user.homelibrary.testdata.data.ReportData;
import org.gcube.portlets.user.homelibrary.util.WorkspaceUtil;

public class ReportDataManager
extends AbstractDataManager<ReportData, Report> {
    public ReportDataManager() {
        super("reports.xml");
    }

    @Override
    protected void configureXStream() {
        this.xstream = new XStream();
        this.xstream.alias("report", ReportData.class);
        this.xstream.alias("reports", LinkedList.class);
    }

    protected static InputStream getTestDataStream(ReportData testData) {
        String testDataPath = "/org/gcube/portlets/user/homelibrary/testdata/resources/" + testData.getFile();
        return TestDataFactory.class.getResourceAsStream(testDataPath);
    }

    @Override
    protected Report fillData(WorkspaceFolder destinationFolder, ReportData testData) throws InternalErrorException {
        InputStream reportData = ReportDataManager.getTestDataStream(testData);
        try {
            String name = WorkspaceUtil.getUniqueName((String)testData.getName(), (WorkspaceFolder)destinationFolder);
            return destinationFolder.createReportItem(name, testData.getDescription(), testData.getCreated(), testData.getLastEdit(), testData.getAuthor(), testData.getLastEditBy(), testData.getTemplateName(), testData.getNumberOfSections(), testData.getStatus(), reportData);
        }
        catch (InsufficientPrivilegesException e) {
            this.logger.error((Object)"Error creating the report", (Throwable)e);
            throw new InternalErrorException((Throwable)e);
        }
        catch (ItemAlreadyExistException e) {
            this.logger.error((Object)"Error creating the report", (Throwable)e);
            throw new InternalErrorException((Throwable)e);
        }
    }
}

