/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.homelibrary.util.accesslog;

import java.util.List;
import org.gcube.application.framework.accesslogger.library.impl.AccessLogger;
import org.gcube.application.framework.accesslogger.model.AccessLogEntry;
import org.gcube.portlets.user.homelibrary.home.User;
import org.gcube.portlets.user.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.portlets.user.homelibrary.home.workspace.WorkspaceItem;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.FolderItem;
import org.gcube.portlets.user.homelibrary.util.WorkspaceTypes;
import org.gcube.portlets.user.homelibrary.util.accesslog.HLAccessLogEntry;
import org.gcube.portlets.user.homelibrary.util.accesslog.HLAccessLogEntryType;

public class AccessLogUtil {
    private static final String USER_SCOPE_SEPARATOR = ":";
    protected static final String USERS_SEPARATOR = ";";
    public static final char ATTRIBUTE_SEPARATOR = '|';
    public static final String LABEL_SEPARATOR = " = ";
    public static final String ITEM_ID_LABEL = "ID";
    public static final String ITEM_NAME_LABEL = "NAME";
    public static final String ITEM_TYPE_LABEL = "TYPE";
    public static final String ADDRESSEES_LABEL = "ADDRESSEES";

    protected static void logAction(User user, HLAccessLogEntryType action, String message) {
        AccessLogger accessLogger = AccessLogger.getAccessLogger();
        accessLogger.logEntry(user.getPortalLogin(), user.getScope().toString(), (AccessLogEntry)new HLAccessLogEntry(action, message));
    }

    protected static void logItemAction(User user, FolderItem item, HLAccessLogEntryType type) throws InternalErrorException {
        StringBuilder message = new StringBuilder(ITEM_ID_LABEL);
        message.append(LABEL_SEPARATOR);
        message.append(item.getId());
        message.append('|');
        message.append(ITEM_NAME_LABEL);
        message.append(LABEL_SEPARATOR);
        message.append(AccessLogEntry.replaceReservedChars((String)item.getName()));
        message.append('|');
        message.append(ITEM_TYPE_LABEL);
        message.append(LABEL_SEPARATOR);
        message.append(WorkspaceTypes.getItemTypeAsString(item));
        AccessLogUtil.logAction(user, type, message.toString());
    }

    public static void logFolderItemCreated(User user, FolderItem item) throws InternalErrorException {
        AccessLogUtil.logItemAction(user, item, HLAccessLogEntryType.HL_FOLDER_ITEM_CREATED);
    }

    public static void logFolderItemRemoved(User user, FolderItem item) throws InternalErrorException {
        AccessLogUtil.logItemAction(user, item, HLAccessLogEntryType.HL_FOLDER_ITEM_REMOVED);
    }

    public static void logFolderItemImported(User user, FolderItem item) throws InternalErrorException {
        AccessLogUtil.logItemAction(user, item, HLAccessLogEntryType.HL_FOLDER_ITEM_IMPORTED);
    }

    public static void logItemSent(User user, WorkspaceItem item, List<User> addressees) throws InternalErrorException {
        StringBuilder message = new StringBuilder(ITEM_ID_LABEL);
        message.append(LABEL_SEPARATOR);
        message.append(item.getId());
        message.append('|');
        message.append(ITEM_NAME_LABEL);
        message.append(LABEL_SEPARATOR);
        message.append(item.getName());
        message.append('|');
        message.append(ITEM_TYPE_LABEL);
        message.append(LABEL_SEPARATOR);
        message.append(WorkspaceTypes.getItemTypeAsString(item));
        message.append('|');
        message.append(ADDRESSEES_LABEL);
        message.append(LABEL_SEPARATOR);
        for (int i = 0; i < addressees.size(); ++i) {
            User addressee = addressees.get(i);
            message.append(addressee.getPortalLogin());
            message.append(USER_SCOPE_SEPARATOR);
            message.append(addressee.getScope().toString());
            if (i >= addressees.size() - 1) continue;
            message.append(USERS_SEPARATOR);
        }
        AccessLogUtil.logAction(user, HLAccessLogEntryType.HL_ITEM_SENT, message.toString());
    }

    public static void logWorkspaceCreated(User user) {
        AccessLogUtil.logAction(user, HLAccessLogEntryType.HL_WORKSPACE_CREATED, "");
    }
}

