/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.homelibrary.unittest.workspace.test;

import java.util.ArrayList;
import java.util.List;
import org.gcube.portlets.user.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.portlets.user.homelibrary.home.workspace.Workspace;
import org.gcube.portlets.user.homelibrary.home.workspace.WorkspaceFolder;
import org.gcube.portlets.user.homelibrary.home.workspace.WorkspaceItem;
import org.gcube.portlets.user.homelibrary.home.workspace.WorkspaceItemType;
import org.gcube.portlets.user.homelibrary.home.workspace.WorkspaceSharedFolder;
import org.gcube.portlets.user.homelibrary.home.workspace.exceptions.InsufficientPrivilegesException;
import org.gcube.portlets.user.homelibrary.home.workspace.exceptions.ItemAlreadyExistException;
import org.gcube.portlets.user.homelibrary.home.workspace.exceptions.ItemNotFoundException;
import org.gcube.portlets.user.homelibrary.home.workspace.exceptions.WorkspaceFolderNotFoundException;
import org.gcube.portlets.user.homelibrary.home.workspace.exceptions.WrongDestinationException;
import org.gcube.portlets.user.homelibrary.testdata.TestDataFactory;
import org.gcube.portlets.user.homelibrary.unittest.workspace.AbstractWorkspaceTest;
import org.gcube.portlets.user.homelibrary.unittest.workspace.WorkspaceFactory;
import org.junit.Assert;
import org.junit.Test;

public class WorkspaceTestSharedFolders
extends AbstractWorkspaceTest {
    public WorkspaceTestSharedFolders(WorkspaceFactory factory) {
        super(factory);
    }

    private void checkContentSharedFolder(String sharedFolderId, int itemsSize, boolean hasDifferentName) throws Exception {
        WorkspaceSharedFolder folder = (WorkspaceSharedFolder)this.ownerWorkspace.getItem(sharedFolderId);
        List items = folder.getChildren();
        Assert.assertEquals((long)items.size(), (long)itemsSize);
        for (Workspace workspace : this.userWorkspaces.values()) {
            WorkspaceSharedFolder sharedFodler = (WorkspaceSharedFolder)workspace.getItem(sharedFolderId);
            List sharedItems = sharedFodler.getChildren();
            Assert.assertEquals((long)sharedItems.size(), (long)itemsSize);
            for (WorkspaceItem ownerItem : items) {
                Assert.assertTrue((boolean)ownerItem.isShared());
                boolean found = false;
                for (WorkspaceItem item : sharedItems) {
                    if (!ownerItem.getId().equals(item.getId())) continue;
                    Assert.assertTrue((boolean)item.isShared());
                    found = true;
                    if (hasDifferentName) {
                        Assert.assertFalse((boolean)ownerItem.getPath().equals(item.getPath()));
                        break;
                    }
                    Assert.assertTrue((boolean)ownerItem.getPath().equals(item.getPath()));
                    break;
                }
                Assert.assertTrue((boolean)found);
            }
        }
    }

    private final WorkspaceSharedFolder createSharedFolder(String name, String destinationFolderId) throws InsufficientPrivilegesException, ItemAlreadyExistException, WrongDestinationException, ItemNotFoundException, WorkspaceFolderNotFoundException, InternalErrorException {
        String description = "DescriptionSharedFolder";
        ArrayList<String> users = new ArrayList<String>();
        for (Workspace testWorkspace : this.userWorkspaces.values()) {
            users.add(testWorkspace.getOwner().getPortalLogin());
        }
        return this.ownerWorkspace.createSharedFolder(name, description, users, destinationFolderId);
    }

    private final void fillSharedFolder(WorkspaceFolder folder, int size) throws Exception {
        TestDataFactory.getInstance().fillExternalFiles(folder, size);
    }

    private final void markItemsAsRead(String sharedFolderId, boolean marked) throws Exception {
        WorkspaceSharedFolder sharedFolder = (WorkspaceSharedFolder)this.ownerWorkspace.getItem(sharedFolderId);
        for (WorkspaceItem item : sharedFolder.getChildren()) {
            item.markAsRead(marked);
        }
        for (Workspace workspace : this.userWorkspaces.values()) {
            WorkspaceSharedFolder userSharedFolder = (WorkspaceSharedFolder)workspace.getItem(sharedFolderId);
            for (WorkspaceItem item : userSharedFolder.getChildren()) {
                item.markAsRead(marked);
            }
        }
    }

    private final void checkItemsIsMarkAsRead(String sharedFolderId, boolean marked) throws Exception {
        WorkspaceSharedFolder sharedFolder = (WorkspaceSharedFolder)this.ownerWorkspace.getItem(sharedFolderId);
        for (WorkspaceItem item : sharedFolder.getChildren()) {
            Assert.assertTrue((boolean)item.isMarkedAsRead());
        }
        for (Workspace workspace : this.userWorkspaces.values()) {
            sharedFolder = (WorkspaceSharedFolder)workspace.getItem(sharedFolderId);
            for (WorkspaceItem item : sharedFolder.getChildren()) {
                if (marked) {
                    Assert.assertTrue((boolean)item.isMarkedAsRead());
                    continue;
                }
                Assert.assertFalse((boolean)item.isMarkedAsRead());
            }
        }
    }

    private final void checkCopySharedFodler(WorkspaceItem folder, WorkspaceItem folderCopy) throws InternalErrorException {
        for (WorkspaceItem item : folder.getChildren()) {
            boolean found = false;
            for (WorkspaceItem itemCopy : folderCopy.getChildren()) {
                if (!item.getName().equals(itemCopy.getName())) continue;
                found = true;
                Assert.assertFalse((boolean)item.getId().equals(itemCopy.getId()));
                Assert.assertFalse((boolean)itemCopy.isShared());
                this.checkCopySharedFodler(item, itemCopy);
            }
            Assert.assertTrue((boolean)found);
        }
    }

    @Test
    public final void checkSharedFolderWithItems() throws Exception {
        WorkspaceSharedFolder sharedFolder = this.createSharedFolder("SharedFolder", this.ownerWorkspace.getRoot().getId());
        int itemSize = 2;
        this.fillSharedFolder((WorkspaceFolder)sharedFolder, itemSize);
        this.checkContentSharedFolder(sharedFolder.getId(), itemSize, false);
    }

    @Test
    public final void checkSharedFolderWithItemsAndExistingNameInUsersRoot() throws Exception {
        String name = "FakeSharedFolder";
        for (Workspace workspace : this.userWorkspaces.values()) {
            workspace.getRoot().createFolder(name, "");
        }
        WorkspaceSharedFolder sharedFolder = this.createSharedFolder(name, this.ownerWorkspace.getRoot().getId());
        int itemSize = 2;
        this.fillSharedFolder((WorkspaceFolder)sharedFolder, itemSize);
        this.checkContentSharedFolder(sharedFolder.getId(), itemSize, true);
    }

    @Test(expected=WrongDestinationException.class)
    public final void createSharedFolderOnWrongDestination() throws Exception {
        String sharedFolderName1 = "SharedFolder1";
        WorkspaceSharedFolder sharedFolder1 = this.createSharedFolder(sharedFolderName1, this.ownerWorkspace.getRoot().getId());
        String sharedFolderName2 = "SharedFolder2";
        this.createSharedFolder(sharedFolderName2, sharedFolder1.getId());
    }

    @Test
    public final void checkIsMarkedAsRead() throws Exception {
        WorkspaceSharedFolder ownerSharedFolder = this.createSharedFolder("SharedFolder", this.ownerWorkspace.getRoot().getId());
        String sharedFolderId = ownerSharedFolder.getId();
        int itemSize = 2;
        this.fillSharedFolder((WorkspaceFolder)ownerSharedFolder, itemSize);
        this.checkItemsIsMarkAsRead(sharedFolderId, false);
        this.markItemsAsRead(sharedFolderId, true);
        this.checkItemsIsMarkAsRead(sharedFolderId, true);
        this.markItemsAsRead(sharedFolderId, false);
        this.checkItemsIsMarkAsRead(sharedFolderId, false);
    }

    @Test
    public final void renameOwnerSharedFolder() throws Exception {
        String name = "SharedFolder";
        WorkspaceSharedFolder folder = this.createSharedFolder(name, this.ownerWorkspace.getRoot().getId());
        String newName = "SharedFolderOwner";
        folder.rename(newName);
        Assert.assertEquals((Object)newName, (Object)folder.getName());
        Assert.assertEquals((Object)newName, (Object)this.ownerWorkspace.getItem(folder.getId()).getName());
        for (Workspace workspace : this.userWorkspaces.values()) {
            Assert.assertEquals((Object)name, (Object)workspace.getItem(folder.getId()).getName());
        }
    }

    @Test(expected=ItemAlreadyExistException.class)
    public final void renameOwnerSharedFolderWithExistingName() throws Exception {
        String name = "SharedFolder";
        WorkspaceSharedFolder sharedFolder = this.createSharedFolder(name, this.ownerWorkspace.getRoot().getId());
        String newName = "folder";
        this.ownerWorkspace.createFolder(newName, "folderDescription", this.ownerWorkspace.getRoot().getId());
        sharedFolder.rename(newName);
    }

    @Test
    public final void copySharedFolderWithItems() throws Exception {
        String nameSharedFolder = "SharedFolderCopy";
        String nameFolder = "Folder";
        int itemSize = 10;
        WorkspaceSharedFolder sharedFolder = this.createSharedFolder(nameSharedFolder, this.ownerWorkspace.getRoot().getId());
        this.fillSharedFolder((WorkspaceFolder)sharedFolder, itemSize);
        WorkspaceFolder folder = this.ownerWorkspace.getRoot().createFolder(nameFolder, "");
        WorkspaceItem item = this.ownerWorkspace.copy(sharedFolder.getId(), folder.getId());
        Assert.assertEquals((Object)WorkspaceItemType.FOLDER, (Object)item.getType());
        this.checkCopySharedFodler((WorkspaceItem)sharedFolder, (WorkspaceItem)((WorkspaceFolder)item));
    }

    @Test(expected=ItemAlreadyExistException.class)
    public final void copySharedFolderWithExistingName() throws Exception {
        String nameSharedFolder = "SharedFolderCopy";
        String nameFolder = "Folder";
        WorkspaceSharedFolder sharedFolder = this.createSharedFolder(nameSharedFolder, this.ownerWorkspace.getRoot().getId());
        WorkspaceFolder folder = this.ownerWorkspace.getRoot().createFolder(nameFolder, "");
        this.ownerWorkspace.copy(sharedFolder.getId(), nameFolder, this.ownerWorkspace.getRoot().getId());
    }

    @Test
    public final void moveSharedFolder() throws Exception {
        String nameSharedFolder = "SharedFolderCopy";
        String nameFolder = "Folder";
        WorkspaceSharedFolder sharedFolder = this.createSharedFolder(nameSharedFolder, this.ownerWorkspace.getRoot().getId());
        WorkspaceFolder folder = this.ownerWorkspace.getRoot().createFolder(nameFolder, "");
        this.ownerWorkspace.moveItem(sharedFolder.getId(), folder.getId());
        Assert.assertEquals((Object)sharedFolder.getParent().getName(), (Object)nameFolder);
        Assert.assertEquals((long)this.ownerWorkspace.getRoot().getChildren().size(), (long)1L);
    }

    @Test(expected=ItemAlreadyExistException.class)
    public final void moveSharedFodlerWithExistingName() throws Exception {
        String nameSharedFolder = "SharedFolderCopy";
        String nameFolder = "Folder";
        WorkspaceSharedFolder sharedFolder = this.createSharedFolder(nameSharedFolder, this.ownerWorkspace.getRoot().getId());
        WorkspaceFolder folder = this.ownerWorkspace.getRoot().createFolder(nameFolder, "");
        folder.createFolder(nameSharedFolder, "");
        this.ownerWorkspace.moveItem(sharedFolder.getId(), folder.getId());
    }

    @Test(expected=WrongDestinationException.class)
    public final void moveSharedFolderInWrongDestination() throws Exception {
        String sharedFolderName = "SharedFodler";
        WorkspaceSharedFolder sharedFolder = this.createSharedFolder(sharedFolderName, this.ownerWorkspace.getRoot().getId());
        WorkspaceSharedFolder otherSharedFolder = this.createSharedFolder("otherSharedFolder", this.ownerWorkspace.getRoot().getId());
        otherSharedFolder.move((WorkspaceFolder)sharedFolder);
    }

    @Test
    public final void moveItemsOnSharedFolder() throws Exception {
        String sharedFolderName = "SharedFodler";
        WorkspaceSharedFolder sharedFolder = this.createSharedFolder(sharedFolderName, this.ownerWorkspace.getRoot().getId());
        WorkspaceFolder folder = sharedFolder.createFolder("ItemFolder", "");
        WorkspaceFolder folder1 = sharedFolder.createFolder("ItemFolder1", "");
        folder.move(folder1);
    }

    @Test(expected=WrongDestinationException.class)
    public final void moveFolderContainingSharedItemOnOtherSharedFolder() throws Exception {
        String sharedFolderName = "Shared Fodler";
        String folderName = "Folder or in bla bla";
        WorkspaceFolder folder = this.ownerWorkspace.getRoot().createFolder(folderName, "");
        this.createSharedFolder(sharedFolderName, folder.getId());
        String otherSharedFolderName = "Other  or in  ,SharedFolder";
        WorkspaceSharedFolder otherSharedFolder = this.createSharedFolder(otherSharedFolderName, this.ownerWorkspace.getRoot().getId());
        folder.move((WorkspaceFolder)otherSharedFolder);
    }

    @Test
    public final void shareFolderWithItems() throws Exception {
        String name = "SharedFolder";
        int itemsSize = 10;
        WorkspaceFolder folder = this.ownerWorkspace.getRoot().createFolder(name, "");
        this.fillSharedFolder(folder, itemsSize);
        ArrayList<String> list = new ArrayList<String>();
        for (Workspace workspace : this.userWorkspaces.values()) {
            list.add(workspace.getOwner().getPortalLogin());
        }
        WorkspaceSharedFolder sharedFolder = folder.share(list);
        this.checkContentSharedFolder(sharedFolder.getId(), itemsSize, false);
    }

    @Test
    public final void unShareFolder() throws Exception {
        WorkspaceSharedFolder sharedFolder = this.createSharedFolder("SharedFolder", this.ownerWorkspace.getRoot().getId());
        String sharedFolderId = sharedFolder.getId();
        int itemsSize = 10;
        this.fillSharedFolder((WorkspaceFolder)sharedFolder, itemsSize);
        WorkspaceFolder folder = sharedFolder.unShare();
        folder.createFolder("Folder", "");
        Assert.assertEquals((long)folder.getChildren().size(), (long)(itemsSize + 1));
        Workspace userWorkspace = (Workspace)this.userWorkspaces.get("user.test1");
        Assert.assertEquals((long)userWorkspace.getItem(sharedFolderId).getChildren().size(), (long)itemsSize);
    }

    @Test
    public final void removeOwnerSharedFolder() throws Exception {
        WorkspaceSharedFolder sharedFolder = this.createSharedFolder("SharedFodler", this.ownerWorkspace.getRoot().getId());
        String sharedFolderId = sharedFolder.getId();
        String owner = sharedFolder.getOwner().getPortalLogin();
        sharedFolder.remove();
        for (Workspace userWorkspace : this.userWorkspaces.values()) {
            WorkspaceSharedFolder userSharedFolder = (WorkspaceSharedFolder)userWorkspace.getItem(sharedFolderId);
            Assert.assertFalse((boolean)userSharedFolder.getUsers().contains(owner));
        }
    }

    @Test
    public final void removeSharedItemsByOwner() throws Exception {
        String sharedFolderName = "SharedFodler";
        WorkspaceSharedFolder sharedFolder = this.createSharedFolder(sharedFolderName, this.ownerWorkspace.getRoot().getId());
        this.fillSharedFolder((WorkspaceFolder)sharedFolder, 1);
        for (WorkspaceItem item : sharedFolder.getChildren()) {
            item.remove();
        }
        Workspace userWorkspace = (Workspace)this.userWorkspaces.get("user.test1");
        WorkspaceSharedFolder userSharedFolder = (WorkspaceSharedFolder)userWorkspace.getItem(sharedFolder.getId());
        this.fillSharedFolder((WorkspaceFolder)userSharedFolder, 2);
        for (WorkspaceItem item : userSharedFolder.getChildren()) {
            item.remove();
        }
        this.fillSharedFolder((WorkspaceFolder)userSharedFolder, 2);
        for (WorkspaceItem item : sharedFolder.getChildren()) {
            item.remove();
        }
    }

    @Test(expected=InsufficientPrivilegesException.class)
    public final void removeSharedItemsByDifferentOwner() throws Exception {
        String sharedFolderName = "SharedFodler";
        WorkspaceSharedFolder sharedFolder = this.createSharedFolder(sharedFolderName, this.ownerWorkspace.getRoot().getId());
        this.fillSharedFolder((WorkspaceFolder)sharedFolder, 1);
        Workspace userWorkspace = (Workspace)this.userWorkspaces.get("user.test1");
        WorkspaceSharedFolder userSharedFolder = (WorkspaceSharedFolder)userWorkspace.getItem(sharedFolder.getId());
        for (WorkspaceItem item : userSharedFolder.getChildren()) {
            item.remove();
        }
    }
}

