/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.homelibrary.util.accesslog;

import org.gcube.portlets.user.homelibrary.home.User;
import org.gcube.portlets.user.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.portlets.user.homelibrary.home.workspace.WorkspaceItem;
import org.gcube.portlets.user.homelibrary.home.workspace.WorkspaceItemType;
import org.gcube.portlets.user.homelibrary.home.workspace.events.WorkspaceEvent;
import org.gcube.portlets.user.homelibrary.home.workspace.events.WorkspaceListener;
import org.gcube.portlets.user.homelibrary.home.workspace.events.WorkspaceSentEvent;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.FolderItem;
import org.gcube.portlets.user.homelibrary.util.accesslog.AccessLogUtil;

public class AccessLogProducer
implements WorkspaceListener {
    protected User user;

    public AccessLogProducer(User user) {
        this.user = user;
    }

    @Override
    public void workspaceEvent(WorkspaceEvent event) {
        WorkspaceItem target = event.getTarget();
        System.out.println("Event: " + (Object)((Object)event.getType()) + " target: " + target);
        try {
            if (target.getType() == WorkspaceItemType.FOLDER_ITEM) {
                FolderItem folderItem = (FolderItem)target;
                switch (event.getType()) {
                    case ITEM_CREATED: {
                        AccessLogUtil.logFolderItemCreated(this.user, folderItem);
                        break;
                    }
                    case ITEM_REMOVED: {
                        AccessLogUtil.logFolderItemRemoved(this.user, folderItem);
                        break;
                    }
                    case ITEM_IMPORTED: {
                        AccessLogUtil.logFolderItemImported(this.user, folderItem);
                    }
                }
            }
            switch (event.getType()) {
                case ITEM_SENT: {
                    WorkspaceSentEvent sentEvent = (WorkspaceSentEvent)event;
                    AccessLogUtil.logItemSent(this.user, target, sentEvent.getAddressees());
                }
            }
        }
        catch (InternalErrorException internalErrorException) {
            // empty catch block
        }
    }
}

