/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.homelibrary.unittest.workspace;

import org.gcube.portlets.user.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.portlets.user.homelibrary.home.workspace.Workspace;
import org.gcube.portlets.user.homelibrary.home.workspace.WorkspaceFolder;
import org.gcube.portlets.user.homelibrary.home.workspace.WorkspaceItem;
import org.gcube.portlets.user.homelibrary.home.workspace.exceptions.InsufficientPrivilegesException;
import org.gcube.portlets.user.homelibrary.home.workspace.exceptions.ItemAlreadyExistException;
import org.gcube.portlets.user.homelibrary.home.workspace.exceptions.ItemNotFoundException;
import org.gcube.portlets.user.homelibrary.home.workspace.exceptions.WrongDestinationException;
import org.gcube.portlets.user.homelibrary.unittest.workspace.UnitTestUtil;
import org.junit.Assert;
import org.junit.Test;

public abstract class WorkspaceItemTest {
    protected Workspace workspace;
    protected WorkspaceItem item;

    @Test
    public final void testCloneItem() throws InternalErrorException, InsufficientPrivilegesException, ItemAlreadyExistException, ItemNotFoundException {
        String expectedName = "TestItemClone";
        WorkspaceItem clone = this.item.cloneItem(expectedName);
        Assert.assertEquals((String)"Wrong name", (Object)expectedName, (Object)clone.getName());
        WorkspaceItem findClone = this.workspace.getItem(clone.getId());
        Assert.assertNotNull((String)"Find clone null", (Object)findClone);
        UnitTestUtil.testCopy(this.item, clone, false);
        UnitTestUtil.testRelationship(clone, (WorkspaceItem)this.item.getParent());
    }

    @Test(expected=IllegalArgumentException.class)
    public final void testCloneItemNullNameArgument() throws InternalErrorException, InsufficientPrivilegesException, ItemAlreadyExistException {
        String expectedName = null;
        this.item.cloneItem(expectedName);
    }

    @Test(expected=IllegalArgumentException.class)
    public final void testCloneItemIllegalCharInNameArgument() throws InternalErrorException, InsufficientPrivilegesException, ItemAlreadyExistException {
        String expectedName = "Test" + this.workspace.getPathSeparator() + "WorkspaceClone";
        this.item.cloneItem(expectedName);
    }

    @Test(expected=ItemAlreadyExistException.class)
    public final void testCloneItemDuplicateItem() throws InternalErrorException, InsufficientPrivilegesException, ItemAlreadyExistException {
        String expectedName = this.item.getName();
        this.item.cloneItem(expectedName);
    }

    @Test(expected=IllegalArgumentException.class)
    public final void testMoveDestinationNullArguments() throws InternalErrorException, WrongDestinationException, InsufficientPrivilegesException, ItemAlreadyExistException {
        this.item.move(null);
    }

    @Test(expected=ItemAlreadyExistException.class)
    public final void testMoveItemDuplicateItems() throws InternalErrorException, WrongDestinationException, InsufficientPrivilegesException, ItemAlreadyExistException {
        this.item.move(this.item.getParent());
    }

    @Test
    public void testRename() throws InternalErrorException, InsufficientPrivilegesException, ItemAlreadyExistException {
        String actualName = this.item.getName();
        String newName = actualName + "new";
        this.item.rename(newName);
        actualName = this.item.getName();
        Assert.assertEquals((Object)newName, (Object)actualName);
    }

    @Test(expected=IllegalArgumentException.class)
    public final void testRenameItemNullName() throws InternalErrorException, InsufficientPrivilegesException, ItemAlreadyExistException {
        this.item.rename(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public final void testRenameIllegalCharInNameArgument() throws InternalErrorException, InsufficientPrivilegesException, ItemAlreadyExistException {
        String expectedName = "New" + this.workspace.getPathSeparator() + "TestFolder";
        this.item.rename(expectedName);
    }

    @Test(expected=IllegalArgumentException.class)
    public final void testRemoveChildNullChildArgument() throws InternalErrorException, InsufficientPrivilegesException {
        this.item.removeChild(null);
    }

    @Test
    public final void testRemove() throws InternalErrorException, InsufficientPrivilegesException {
        WorkspaceFolder parent = this.item.getParent();
        this.item.remove();
        try {
            this.workspace.getItem(this.item.getId());
        }
        catch (ItemNotFoundException infe) {
            return;
        }
        Assert.fail((String)"Item not removed");
        Assert.assertEquals((String)"Wrong number of children", (long)0L, (long)parent.getChildren().size());
    }

    public final void testGetPath() throws InternalErrorException {
        Assert.assertNotNull((String)"Path null", (Object)this.item.getPath());
    }
}

