/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.homelibrary.consistency;

import java.util.List;
import org.apache.log4j.Logger;
import org.gcube.portlets.user.homelibrary.consistency.WorkspaceConsistencyChecker;
import org.gcube.portlets.user.homelibrary.consistency.statistics.CheckStatistics;
import org.gcube.portlets.user.homelibrary.consistency.statistics.HomeCheckStatistics;
import org.gcube.portlets.user.homelibrary.home.Home;
import org.gcube.portlets.user.homelibrary.home.HomeManager;
import org.gcube.portlets.user.homelibrary.home.HomeManagerFactory;
import org.gcube.portlets.user.homelibrary.home.User;
import org.gcube.portlets.user.homelibrary.home.exceptions.HomeNotFoundException;
import org.gcube.portlets.user.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.portlets.user.homelibrary.home.exceptions.UserNotFoundException;
import org.gcube.portlets.user.homelibrary.home.workspace.Workspace;

public class HomeManagerFactoryConsistencyChecker {
    protected Logger logger;
    protected HomeManagerFactory factory;
    protected boolean testEntireStream;
    protected CheckStatistics statistics;
    protected boolean acceptAllSentRequests;

    public HomeManagerFactoryConsistencyChecker(Logger logger, HomeManagerFactory factory, boolean testEntireStream, boolean acceptAllSentRequests) {
        this.logger = logger;
        this.factory = factory;
        this.testEntireStream = testEntireStream;
        this.acceptAllSentRequests = acceptAllSentRequests;
        this.statistics = new CheckStatistics();
    }

    public CheckStatistics getStatistics() {
        return this.statistics;
    }

    public boolean checkAllScopes() throws InternalErrorException {
        List scopes = this.factory.listScopes();
        boolean checkResult = true;
        for (String scope : scopes) {
            checkResult &= this.checkScope(scope);
        }
        return checkResult;
    }

    public boolean checkScope(String scope) throws InternalErrorException {
        this.logger.info((Object)("start checking " + scope));
        HomeManager manager = this.factory.getHomeManager();
        boolean passed = this.checkHomeManager(manager);
        this.logger.info((Object)(scope + " " + (passed ? "OK" : "FAILED")));
        return passed;
    }

    protected boolean checkHomeManager(HomeManager manager) throws InternalErrorException {
        boolean managerCheck = true;
        List users = manager.getUsers();
        String scope = manager.toString();
        HomeCheckStatistics homeStatistics = new HomeCheckStatistics();
        for (User user : users) {
            try {
                this.logger.debug((Object)("checking user " + user.getPortalLogin()));
                Home home = manager.getHome(user.getPortalLogin(), user.getScope());
                boolean passed = this.checkHome(home, homeStatistics);
                managerCheck &= passed;
                this.logger.info((Object)(scope + " " + user.getPortalLogin() + " " + (passed ? "OK" : "FAILED")));
            }
            catch (HomeNotFoundException hne) {
                this.logger.error((Object)(scope + " " + user.getPortalLogin() + " FAILED"), (Throwable)hne);
                managerCheck = false;
            }
            catch (UserNotFoundException e) {
                e.printStackTrace();
            }
        }
        return managerCheck;
    }

    protected boolean checkHome(Home home, HomeCheckStatistics homeStatistics) {
        try {
            Workspace wa = home.getWorkspace();
            WorkspaceConsistencyChecker waChecker = new WorkspaceConsistencyChecker(this.logger, wa, this.testEntireStream, this.acceptAllSentRequests);
            boolean result = waChecker.checkWorkspace();
            homeStatistics.addWorkspaceStatistics(home.getOwner().getPortalLogin(), waChecker.getStatistics());
            return result;
        }
        catch (Exception e) {
            this.logger.error((Object)"Error checking the home", (Throwable)e);
            return false;
        }
    }
}

