/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.homelibrary.consistency;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.Map;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.apache.log4j.SimpleLayout;
import org.gcube.portlets.user.homelibrary.consistency.HomeManagerFactoryConsistencyChecker;
import org.gcube.portlets.user.homelibrary.consistency.statistics.CheckStatistics;
import org.gcube.portlets.user.homelibrary.home.HomeLibrary;
import org.gcube.portlets.user.homelibrary.home.HomeManagerFactory;
import org.gcube.portlets.user.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.portlets.user.homelibrary.home.workspace.folder.FolderItemType;
import org.gcube.portlets.user.homelibrary.util.logging.LoggingUtil;

public class HomeLibraryConsistencyChecker {
    public static void main(String[] args) throws InternalErrorException, IOException {
        if (args.length == 1 && (args[0].equalsIgnoreCase("--help") || args[0].equalsIgnoreCase("help"))) {
            HomeLibraryConsistencyChecker.printUsage();
        }
        String rootDir = null;
        if (args.length == 0) {
            System.out.println("No parameters specified, I will try to get the Home Library Persistency root from the system");
        } else {
            System.out.println("Home Library Persistency root to use: " + args[0]);
            rootDir = args[0];
        }
        boolean testEntireStream = false;
        if (args.length > 1) {
            testEntireStream = Boolean.parseBoolean(args[1]);
        }
        System.out.println("Test entire stream: " + testEntireStream);
        boolean acceptAllRequests = false;
        if (args.length > 2) {
            acceptAllRequests = Boolean.parseBoolean(args[2]);
        }
        System.out.println("Accept all requests: " + acceptAllRequests);
        if (acceptAllRequests) {
            System.out.println("Are you sure to accept all send requests for each user? this will modify the user workspace!!! (y/n)");
            int reply = System.in.read();
            if (reply == 110 || reply == 78) {
                System.err.println("Abort request by user");
                System.exit(0);
            }
        }
        boolean loadScopeList = false;
        File scopeListFile = null;
        if (args.length > 3) {
            scopeListFile = new File(args[3]);
            if (!scopeListFile.exists()) {
                System.err.println("The scope list file " + scopeListFile + " don't exists.");
                System.exit(1);
            }
            loadScopeList = true;
        }
        LoggingUtil.reconfigureLogging();
        HomeManagerFactory factory = rootDir == null ? HomeLibrary.getHomeManagerFactory() : HomeLibrary.getHomeManagerFactory((String)rootDir);
        Logger logger = Logger.getLogger((String)"checker");
        logger.setLevel(Level.ALL);
        ConsoleAppender ca = new ConsoleAppender((Layout)new SimpleLayout());
        ca.setThreshold((Priority)Level.INFO);
        logger.addAppender((Appender)ca);
        FileAppender faTrace = new FileAppender((Layout)new SimpleLayout(), "hlcheck.trace.log", false);
        faTrace.setThreshold((Priority)Level.ALL);
        logger.addAppender((Appender)faTrace);
        FileAppender faInfo = new FileAppender((Layout)new SimpleLayout(), "hlcheck.info.log", false);
        faInfo.setThreshold((Priority)Level.INFO);
        logger.addAppender((Appender)faInfo);
        HomeManagerFactoryConsistencyChecker checker = new HomeManagerFactoryConsistencyChecker(logger, factory, testEntireStream, acceptAllRequests);
        boolean check = false;
        if (!loadScopeList) {
            check = checker.checkAllScopes();
        } else {
            LineNumberReader reader = new LineNumberReader(new FileReader(scopeListFile));
            String scope = reader.readLine();
            while (scope != null) {
                check &= checker.checkScope(scope);
                scope = reader.readLine();
            }
            reader.close();
        }
        if (check) {
            System.out.println("No error founds");
            HomeLibraryConsistencyChecker.printStatistics(checker.getStatistics());
            System.exit(0);
        } else {
            System.err.println("Error founds");
            HomeLibraryConsistencyChecker.printStatistics(checker.getStatistics());
            System.exit(1);
        }
    }

    protected static void printStatistics(CheckStatistics statistics) {
        System.out.println();
        System.out.println("Check statistics:");
        System.out.println("- checked scopes: " + statistics.getCheckedScopes());
        System.out.println("- checked users: " + statistics.getCheckedUsers());
        System.out.println("- errors: " + statistics.getErrors());
        System.out.println("- items: " + statistics.getCheckedItems());
        System.out.println("Item types:");
        System.out.println("- folders: " + statistics.getFolders());
        for (Map.Entry<FolderItemType, Integer> entry : statistics.getFolderItemTypesCount().entrySet()) {
            System.out.println("- " + entry.getKey().toString().toLowerCase() + ": " + entry.getValue());
        }
        System.out.println();
    }

    public static void printUsage() {
        System.out.println("Home Library Consistency Checker");
        System.out.println("HomeLibraryConsistencyChecker [home library persistence root] [check entire stream] [accept all requests (make the check destructive)] [scope list file]");
        System.out.println();
        System.exit(0);
    }
}

