/**
 * 
 */
package org.gcube.portlets.user.homelibrary.jcr.workspace.accounting;

import java.text.SimpleDateFormat;
import java.util.Calendar;

import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;

import org.gcube.portlets.user.homelibrary.home.workspace.accounting.AccountingEntry;
import org.gcube.portlets.user.homelibrary.home.workspace.accounting.AccountingEntryType;



/**
 * @author Antonio Gioia antonio.gioia@isti.cnr.it
 *
 */
public abstract class JCRAccountingEntry implements AccountingEntry {
	
	private static final String USER				= "hl:user";
	private static final String DATE				= "hl:date";
	
	private  String user;
	private  Calendar date;

	
	public JCRAccountingEntry(Node node) throws RepositoryException {
		
		this.user = node.getProperty(USER).getString();
		this.date = node.getProperty(DATE).getDate();
	}
	
	public JCRAccountingEntry(String user, Calendar date) {
		
		this.user = user;
		this.date = date;
	}

	@Override
	public abstract AccountingEntryType getEntryType();
	
	@Override
	public String getUser() {
		return user;
	}

	@Override
	public Calendar getDate() {
		return date;
	}

	public void save(Node entryNode) throws RepositoryException  {

		entryNode.setProperty(USER, user);
		entryNode.setProperty(DATE, date);	
	}

	@Override
	public String toString() {
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
		return String.format("[ user:%s, date:%s ]",user,sdf.format(date.getTime()));
	}

}
